/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.nio;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.ChannelOutboundHandler;
import com.hazelcast.internal.networking.InitResult;
import com.hazelcast.internal.networking.OutboundFrame;
import com.hazelcast.internal.networking.nio.AbstractHandler;
import com.hazelcast.internal.networking.nio.NioChannel;
import com.hazelcast.internal.networking.nio.NioThread;
import com.hazelcast.internal.networking.nio.iobalancer.IOBalancer;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NioChannelWriter
extends AbstractHandler
implements Runnable {
    private static final long TIMEOUT = 3L;
    @Probe(name="writeQueueSize")
    public final Queue<OutboundFrame> writeQueue = new ConcurrentLinkedQueue<OutboundFrame>();
    @Probe(name="priorityWriteQueueSize")
    public final Queue<OutboundFrame> urgentWriteQueue = new ConcurrentLinkedQueue<OutboundFrame>();
    private final ChannelInitializer initializer;
    private ByteBuffer outputBuffer;
    private final AtomicBoolean scheduled = new AtomicBoolean(false);
    @Probe(name="bytesWritten")
    private final SwCounter bytesWritten = SwCounter.newSwCounter();
    @Probe(name="normalFramesWritten")
    private final SwCounter normalFramesWritten = SwCounter.newSwCounter();
    @Probe(name="priorityFramesWritten")
    private final SwCounter priorityFramesWritten = SwCounter.newSwCounter();
    private ChannelOutboundHandler outboundHandler;
    private OutboundFrame currentFrame;
    private volatile long lastWriteTime;
    private NioThread newOwner;
    private long bytesReadLastPublish;
    private long normalFramesReadLastPublish;
    private long priorityFramesReadLastPublish;
    private long eventsLastPublish;

    public NioChannelWriter(NioChannel channel, NioThread ioThread, ILogger logger, IOBalancer balancer, ChannelInitializer initializer) {
        super(channel, ioThread, 4, logger, balancer);
        this.initializer = initializer;
    }

    @Override
    public long getLoad() {
        switch (LOAD_TYPE) {
            case 0: {
                return this.handleCount.get();
            }
            case 1: {
                return this.bytesWritten.get() + this.priorityFramesWritten.get();
            }
            case 2: {
                return this.normalFramesWritten.get() + this.priorityFramesWritten.get();
            }
        }
        throw new RuntimeException();
    }

    public int totalFramesPending() {
        return this.writeQueue.size() + this.urgentWriteQueue.size();
    }

    public long lastWriteTimeMillis() {
        return this.lastWriteTime;
    }

    @Probe(name="writeQueuePendingBytes", level=ProbeLevel.DEBUG)
    public long bytesPending() {
        return this.bytesPending(this.writeQueue);
    }

    @Probe(name="priorityWriteQueuePendingBytes", level=ProbeLevel.DEBUG)
    public long priorityBytesPending() {
        return this.bytesPending(this.urgentWriteQueue);
    }

    private long bytesPending(Queue<OutboundFrame> writeQueue) {
        long bytesPending = 0L;
        for (OutboundFrame frame : writeQueue) {
            if (!(frame instanceof Packet)) continue;
            bytesPending += (long)((Packet)frame).packetSize();
        }
        return bytesPending;
    }

    @Probe
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastWriteTime, 0L);
    }

    @Probe(level=ProbeLevel.DEBUG)
    private long isScheduled() {
        return this.scheduled.get() ? 1L : 0L;
    }

    public void flush() {
        this.ioThread.addTaskAndWakeup(this);
    }

    public void write(OutboundFrame frame) {
        if (frame.isUrgent()) {
            this.urgentWriteQueue.offer(frame);
        } else {
            this.writeQueue.offer(frame);
        }
        this.schedule();
    }

    private OutboundFrame poll() {
        OutboundFrame frame;
        boolean urgent;
        while (true) {
            urgent = true;
            frame = this.urgentWriteQueue.poll();
            if (frame == null) {
                urgent = false;
                frame = this.writeQueue.poll();
            }
            if (frame == null) {
                return null;
            }
            if (frame.getClass() != TaskFrame.class) break;
            TaskFrame taskFrame = (TaskFrame)frame;
            taskFrame.task.run();
        }
        if (urgent) {
            this.priorityFramesWritten.inc();
        } else {
            this.normalFramesWritten.inc();
        }
        return frame;
    }

    private void schedule() {
        if (this.scheduled.get()) {
            return;
        }
        if (!this.scheduled.compareAndSet(false, true)) {
            return;
        }
        this.ioThread.addTaskAndWakeup(this);
    }

    private void unschedule() throws IOException {
        if (this.dirtyOutputBuffer() || this.currentFrame != null) {
            this.registerOp(4);
            return;
        }
        this.unregisterOp(4);
        this.scheduled.set(false);
        if (this.writeQueue.isEmpty() && this.urgentWriteQueue.isEmpty()) {
            return;
        }
        if (!this.scheduled.compareAndSet(false, true)) {
            return;
        }
        this.ioThread.addTask(this);
    }

    @Override
    public void handle() throws Exception {
        this.handleCount.inc();
        this.lastWriteTime = System.currentTimeMillis();
        if (this.outboundHandler == null && !this.init()) {
            return;
        }
        this.fillOutputBuffer();
        if (this.dirtyOutputBuffer()) {
            this.writeOutputBufferToSocket();
        }
        if (this.newOwner == null) {
            this.unschedule();
        } else {
            this.startMigration();
        }
    }

    private boolean init() throws IOException {
        InitResult<ChannelOutboundHandler> init = this.initializer.initOutbound(this.channel);
        if (init == null) {
            this.unschedule();
            return false;
        }
        this.outputBuffer = init.getByteBuffer();
        this.outboundHandler = init.getHandler();
        this.registerOp(4);
        return true;
    }

    private void startMigration() throws IOException {
        NioThread newOwner = this.newOwner;
        this.newOwner = null;
        this.startMigration(newOwner);
    }

    private boolean dirtyOutputBuffer() {
        return this.outputBuffer != null && this.outputBuffer.position() > 0;
    }

    private void writeOutputBufferToSocket() throws IOException {
        this.outputBuffer.flip();
        int written = this.channel.write(this.outputBuffer);
        this.bytesWritten.inc(written);
        IOUtil.compactOrClear(this.outputBuffer);
    }

    private void fillOutputBuffer() throws Exception {
        if (this.currentFrame == null) {
            this.currentFrame = this.poll();
        }
        while (this.currentFrame != null) {
            if (!this.outboundHandler.onWrite(this.currentFrame, this.outputBuffer)) {
                return;
            }
            this.currentFrame = this.poll();
        }
    }

    @Override
    public void run() {
        try {
            this.handle();
        }
        catch (Throwable t) {
            this.onFailure(t);
        }
    }

    @Override
    public void close() {
        this.writeQueue.clear();
        this.urgentWriteQueue.clear();
        CloseTask closeTask = new CloseTask();
        this.write(new TaskFrame(closeTask));
        closeTask.awaitCompletion();
    }

    @Override
    public void requestMigration(NioThread newOwner) {
        this.write(new TaskFrame(new StartMigrationTask(newOwner)));
    }

    public String toString() {
        return this.channel + ".channelWriter";
    }

    @Override
    protected void publish() {
        this.ioThread.bytesTransceived += this.bytesWritten.get() - this.bytesReadLastPublish;
        this.ioThread.framesTransceived += this.normalFramesWritten.get() - this.normalFramesReadLastPublish;
        this.ioThread.priorityFramesTransceived += this.priorityFramesWritten.get() - this.priorityFramesReadLastPublish;
        this.ioThread.handleCount += this.handleCount.get() - this.eventsLastPublish;
        this.bytesReadLastPublish = this.bytesWritten.get();
        this.normalFramesReadLastPublish = this.normalFramesWritten.get();
        this.priorityFramesReadLastPublish = this.priorityFramesWritten.get();
        this.eventsLastPublish = this.handleCount.get();
    }

    private class CloseTask
    implements Runnable {
        private final CountDownLatch latch = new CountDownLatch(1);

        private CloseTask() {
        }

        @Override
        public void run() {
            try {
                NioChannelWriter.this.channel.closeOutbound();
            }
            catch (IOException e) {
                NioChannelWriter.this.logger.finest("Error while closing outbound", e);
            }
            finally {
                this.latch.countDown();
            }
        }

        void awaitCompletion() {
            try {
                this.latch.await(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private final class StartMigrationTask
    implements Runnable {
        private final NioThread theNewOwner;

        StartMigrationTask(NioThread theNewOwner) {
            this.theNewOwner = theNewOwner;
        }

        @Override
        public void run() {
            assert (NioChannelWriter.this.newOwner == null) : "No migration can be in progress";
            if (NioChannelWriter.this.ioThread == this.theNewOwner) {
                return;
            }
            NioChannelWriter.this.newOwner = this.theNewOwner;
        }
    }

    private static final class TaskFrame
    implements OutboundFrame {
        private final Runnable task;

        private TaskFrame(Runnable task) {
            this.task = task;
        }

        @Override
        public boolean isUrgent() {
            return true;
        }
    }
}

