/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.instance.LifecycleServiceImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.spi.CoreService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.SplitBrainHandlerService;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ClusterMergeTask
implements Runnable {
    private static final long MIN_WAIT_ON_FUTURE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private static final String MERGE_TASKS_EXECUTOR = "hz:cluster-merge";
    private final Node node;

    ClusterMergeTask(Node node) {
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LifecycleServiceImpl lifecycleService = this.node.hazelcastInstance.getLifecycleService();
        lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.MERGING);
        LifecycleEvent.LifecycleState finalLifecycleState = LifecycleEvent.LifecycleState.MERGE_FAILED;
        try {
            this.resetState();
            Collection<Runnable> coreTasks = this.collectMergeTasks(true);
            Collection<Runnable> nonCoreTasks = this.collectMergeTasks(false);
            this.resetServices();
            this.rejoin();
            finalLifecycleState = this.getFinalLifecycleState();
            if (finalLifecycleState == LifecycleEvent.LifecycleState.MERGED) {
                this.executeMergeTasks(coreTasks);
                this.executeMergeTasks(nonCoreTasks);
            }
        }
        finally {
            lifecycleService.fireLifecycleEvent(finalLifecycleState);
        }
    }

    private LifecycleEvent.LifecycleState getFinalLifecycleState() {
        return this.node.isRunning() && this.node.getClusterService().isJoined() ? LifecycleEvent.LifecycleState.MERGED : LifecycleEvent.LifecycleState.MERGE_FAILED;
    }

    private void resetState() {
        this.node.reset();
        this.node.getClusterService().reset();
        this.node.connectionManager.stop();
        this.node.nodeEngine.reset();
    }

    private Collection<Runnable> collectMergeTasks(boolean coreServices) {
        Collection<SplitBrainHandlerService> services = this.node.nodeEngine.getServices(SplitBrainHandlerService.class);
        LinkedList<Runnable> tasks = new LinkedList<Runnable>();
        for (SplitBrainHandlerService service : services) {
            Runnable runnable;
            if (coreServices != this.isCoreService(service) || (runnable = service.prepareMergeRunnable()) == null) continue;
            tasks.add(runnable);
        }
        return tasks;
    }

    private boolean isCoreService(SplitBrainHandlerService service) {
        return service instanceof CoreService;
    }

    private void resetServices() {
        Collection<ManagedService> managedServices = this.node.nodeEngine.getServices(ManagedService.class);
        for (ManagedService service : managedServices) {
            if (service instanceof ClusterService) continue;
            service.reset();
        }
    }

    private void rejoin() {
        this.node.connectionManager.start();
        this.node.join();
    }

    private void executeMergeTasks(Collection<Runnable> tasks) {
        LinkedList futures = new LinkedList();
        for (Runnable task : tasks) {
            Future<?> f = this.node.nodeEngine.getExecutionService().submit(MERGE_TASKS_EXECUTOR, task);
            futures.add(f);
        }
        long callTimeoutMillis = this.node.getProperties().getMillis(GroupProperty.OPERATION_CALL_TIMEOUT_MILLIS);
        for (Future future : futures) {
            try {
                this.waitOnFutureInterruptible(future, callTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (HazelcastInstanceNotActiveException e) {
                EmptyStatement.ignore(e);
            }
            catch (Exception e) {
                this.node.getLogger(this.getClass()).severe("While merging...", e);
            }
        }
    }

    private <V> V waitOnFutureInterruptible(Future<V> future, long timeout, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        Preconditions.isNotNull(timeUnit, "timeUnit");
        long totalTimeoutMs = timeUnit.toMillis(timeout);
        while (true) {
            long timeoutStepMs = Math.min(MIN_WAIT_ON_FUTURE_TIMEOUT_MILLIS, totalTimeoutMs);
            try {
                return future.get(timeoutStepMs, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException t) {
                if ((totalTimeoutMs -= timeoutStepMs) > 0L) continue;
                throw t;
                if (this.node.isRunning()) continue;
                future.cancel(true);
                throw new HazelcastInstanceNotActiveException();
            }
            break;
        }
    }
}

