/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.ringbuffer.impl.RingbufferContainer;
import com.hazelcast.ringbuffer.impl.RingbufferProxy;
import com.hazelcast.ringbuffer.impl.operations.ReplicationOperation;
import com.hazelcast.spi.DistributedObjectNamespace;
import com.hazelcast.spi.FragmentedMigrationAwareService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.ServiceNamespace;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.partition.MigrationEndpoint;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.version.Version;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RingbufferService
implements ManagedService,
RemoteService,
FragmentedMigrationAwareService {
    public static final String TOPIC_RB_PREFIX = "_hz_rb_";
    public static final String SERVICE_NAME = "hz:impl:ringbufferService";
    private final ConcurrentMap<Integer, Map<ObjectNamespace, RingbufferContainer>> containers = new ConcurrentHashMap<Integer, Map<ObjectNamespace, RingbufferContainer>>();
    private NodeEngine nodeEngine;

    public RingbufferService(NodeEngineImpl nodeEngine) {
        this.nodeEngine = Preconditions.checkNotNull(nodeEngine, "nodeEngine can't be null");
    }

    private static String getConfigName(String name) {
        if (name.startsWith(TOPIC_RB_PREFIX)) {
            name = name.substring(TOPIC_RB_PREFIX.length());
        }
        return name;
    }

    public ConcurrentMap<Integer, Map<ObjectNamespace, RingbufferContainer>> getContainers() {
        return this.containers;
    }

    @Override
    public DistributedObject createDistributedObject(String objectName) {
        RingbufferConfig ringbufferConfig = this.getRingbufferConfig(objectName);
        return new RingbufferProxy(this.nodeEngine, this, objectName, ringbufferConfig);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.destroyContainer(this.getRingbufferPartitionId(name), RingbufferService.getRingbufferNamespace(name));
        this.nodeEngine.getEventService().deregisterAllListeners(SERVICE_NAME, name);
    }

    public void destroyContainer(int partitionId, ObjectNamespace namespace) {
        Map partitionContainers = (Map)this.containers.get(partitionId);
        if (partitionContainers == null) {
            return;
        }
        partitionContainers.remove(namespace);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
    }

    @Override
    public void reset() {
        this.containers.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    public <T> RingbufferContainer<T> getOrCreateContainer(int partitionId, ObjectNamespace namespace, RingbufferConfig config) {
        if (config == null) {
            throw new NullPointerException("Ringbuffer config should not be null when ringbuffer is being created");
        }
        Version clusterVersion = this.nodeEngine.getClusterService().getClusterVersion();
        if (clusterVersion.isLessThan(Versions.V3_9) && !SERVICE_NAME.equals(namespace.getServiceName())) {
            throw new UnsupportedOperationException("Ringbuffer containers for service " + namespace.getServiceName() + " are not supported when cluster version is " + clusterVersion);
        }
        Map<ObjectNamespace, RingbufferContainer> partitionContainers = this.getOrCreateRingbufferContainers(partitionId);
        RingbufferContainer ringbuffer = partitionContainers.get(namespace);
        if (ringbuffer != null) {
            return ringbuffer;
        }
        ringbuffer = new RingbufferContainer(namespace, config, this.nodeEngine.getSerializationService(), this.nodeEngine.getConfigClassLoader(), partitionId);
        ringbuffer.getStore().instrument(this.nodeEngine);
        partitionContainers.put(namespace, ringbuffer);
        return ringbuffer;
    }

    public <T> RingbufferContainer<T> getContainerOrNull(int partitionId, ObjectNamespace namespace) {
        Map partitionContainers = (Map)this.containers.get(partitionId);
        return partitionContainers != null ? (RingbufferContainer)partitionContainers.get(namespace) : null;
    }

    private Map<ObjectNamespace, RingbufferContainer> getOrCreateRingbufferContainers(int partitionId) {
        Map partitionContainer = (Map)this.containers.get(partitionId);
        if (partitionContainer == null) {
            this.containers.putIfAbsent(partitionId, new HashMap());
        }
        return (Map)this.containers.get(partitionId);
    }

    public RingbufferConfig getRingbufferConfig(String name) {
        Config config = this.nodeEngine.getConfig();
        return config.findRingbufferConfig(RingbufferService.getConfigName(name));
    }

    public static ObjectNamespace getRingbufferNamespace(String name) {
        return new DistributedObjectNamespace(SERVICE_NAME, name);
    }

    public int getRingbufferPartitionId(String ringbufferName) {
        Object partitionAwareData = this.nodeEngine.getSerializationService().toData(ringbufferName, StringPartitioningStrategy.INSTANCE);
        return this.nodeEngine.getPartitionService().getPartitionId((Data)partitionAwareData);
    }

    public void addRingbuffer(int partitionId, RingbufferContainer ringbuffer, RingbufferConfig config) {
        Preconditions.checkNotNull(ringbuffer, "ringbuffer can't be null");
        SerializationService serializationService = this.nodeEngine.getSerializationService();
        ringbuffer.init(config, serializationService, this.nodeEngine.getConfigClassLoader());
        ringbuffer.getStore().instrument(this.nodeEngine);
        this.getOrCreateRingbufferContainers(partitionId).put(ringbuffer.getNamespace(), ringbuffer);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        return this.prepareReplicationOperation(event, this.getAllServiceNamespaces(event));
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        int partitionId = event.getPartitionId();
        Map partitionContainers = (Map)this.containers.get(partitionId);
        if (MapUtil.isNullOrEmpty(partitionContainers)) {
            return null;
        }
        HashMap<ObjectNamespace, RingbufferContainer> migrationData = new HashMap<ObjectNamespace, RingbufferContainer>();
        for (ServiceNamespace namespace : namespaces) {
            ObjectNamespace ns = (ObjectNamespace)namespace;
            RingbufferContainer container = (RingbufferContainer)partitionContainers.get(ns);
            if (container == null || container.getConfig().getTotalBackupCount() < event.getReplicaIndex()) continue;
            migrationData.put(ns, container);
        }
        if (migrationData.isEmpty()) {
            return null;
        }
        return new ReplicationOperation(migrationData, event.getPartitionId(), event.getReplicaIndex());
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearRingbuffersHavingLesserBackupCountThan(event.getPartitionId(), event.getNewReplicaIndex());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearRingbuffersHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
    }

    private void clearRingbuffersHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        Map partitionContainers = (Map)this.containers.get(partitionId);
        if (partitionContainers == null || partitionContainers.isEmpty()) {
            return;
        }
        Iterator iterator = partitionContainers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            RingbufferContainer container = (RingbufferContainer)entry.getValue();
            if (thresholdReplicaIndex >= 0 && container.getConfig().getTotalBackupCount() >= thresholdReplicaIndex) continue;
            iterator.remove();
        }
    }

    @Override
    public Collection<ServiceNamespace> getAllServiceNamespaces(PartitionReplicationEvent event) {
        int partitionId = event.getPartitionId();
        Map partitionContainers = (Map)this.containers.get(partitionId);
        if (partitionContainers == null || partitionContainers.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<ServiceNamespace> namespaces = new HashSet<ServiceNamespace>();
        for (RingbufferContainer container : partitionContainers.values()) {
            if (container.getConfig().getTotalBackupCount() < event.getReplicaIndex()) continue;
            namespaces.add(container.getNamespace());
        }
        return namespaces;
    }

    @Override
    public boolean isKnownServiceNamespace(ServiceNamespace namespace) {
        return namespace instanceof ObjectNamespace;
    }
}

