/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.client.impl.protocol.util.ClientMessageChannelInboundHandler;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelInboundHandler;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.ChannelOutboundHandler;
import com.hazelcast.internal.networking.InitResult;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ascii.TextChannelInboundHandler;
import com.hazelcast.nio.ascii.TextChannelOutboundHandler;
import com.hazelcast.nio.tcp.ClientChannelOutboundHandler;
import com.hazelcast.nio.tcp.MessageHandlerImpl;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.hazelcast.util.StringUtil;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;

public class MemberChannelInitializer
implements ChannelInitializer {
    private static final String PROTOCOL_BUFFER = "protocolbuffer";
    private static final String PROTOCOL = "protocol";
    private static final String TEXT_OUTBOUND_HANDLER = "outboundHandler";
    private final ILogger logger;
    private final IOService ioService;

    public MemberChannelInitializer(ILogger logger, IOService ioService) {
        this.logger = logger;
        this.ioService = ioService;
    }

    @Override
    public InitResult<ChannelInboundHandler> initInbound(Channel channel) throws IOException {
        String protocol = this.inboundProtocol(channel);
        if (protocol == null) {
            return null;
        }
        InitResult<ChannelInboundHandler> init = "HZC".equals(protocol) ? this.initInboundClusterProtocol(channel) : ("CB2".equals(protocol) ? this.initInboundClientProtocol(channel) : this.initInboundTextProtocol(channel, protocol));
        channel.flush();
        return init;
    }

    private String inboundProtocol(Channel channel) throws IOException {
        int readBytes;
        ConcurrentMap attributeMap = channel.attributeMap();
        ByteBuffer protocolBuffer = (ByteBuffer)attributeMap.get(PROTOCOL_BUFFER);
        if (protocolBuffer == null) {
            protocolBuffer = ByteBuffer.allocate(3);
            attributeMap.put(PROTOCOL_BUFFER, protocolBuffer);
        }
        if ((readBytes = channel.read(protocolBuffer)) == -1) {
            throw new EOFException("Could not read protocol type!");
        }
        if (protocolBuffer.hasRemaining()) {
            return null;
        }
        channel.attributeMap().remove(PROTOCOL_BUFFER);
        String protocol = StringUtil.bytesToString(protocolBuffer.array());
        channel.attributeMap().put(PROTOCOL, protocol);
        return protocol;
    }

    private InitResult<ChannelInboundHandler> initInboundClusterProtocol(Channel channel) throws IOException {
        TcpIpConnection connection = (TcpIpConnection)channel.attributeMap().get(TcpIpConnection.class);
        connection.setType(ConnectionType.MEMBER);
        ByteBuffer inputBuffer = this.newInputBuffer(connection.getChannel(), this.ioService.getSocketReceiveBufferSize());
        ChannelInboundHandler inboundHandler = this.ioService.createInboundHandler(connection);
        if (inboundHandler == null) {
            throw new IOException("Could not initialize ChannelInboundHandler!");
        }
        return new InitResult<ChannelInboundHandler>(inputBuffer, inboundHandler);
    }

    private InitResult<ChannelInboundHandler> initInboundClientProtocol(Channel channel) throws IOException {
        TcpIpConnection connection = (TcpIpConnection)channel.attributeMap().get(TcpIpConnection.class);
        ByteBuffer inputBuffer = this.newInputBuffer(channel, this.ioService.getSocketClientReceiveBufferSize());
        ClientMessageChannelInboundHandler inboundHandler = new ClientMessageChannelInboundHandler(new MessageHandlerImpl(connection, this.ioService.getClientEngine()));
        return new InitResult<ChannelInboundHandler>(inputBuffer, inboundHandler);
    }

    private InitResult<ChannelInboundHandler> initInboundTextProtocol(Channel channel, String protocol) {
        TcpIpConnection connection = (TcpIpConnection)channel.attributeMap().get(TcpIpConnection.class);
        TcpIpConnectionManager connectionManager = connection.getConnectionManager();
        connectionManager.incrementTextConnections();
        TextChannelOutboundHandler outboundHandler = new TextChannelOutboundHandler(connection);
        channel.attributeMap().put(TEXT_OUTBOUND_HANDLER, outboundHandler);
        ByteBuffer inputBuffer = this.newInputBuffer(channel, this.ioService.getSocketReceiveBufferSize());
        inputBuffer.put(StringUtil.stringToBytes(protocol));
        TextChannelInboundHandler inboundHandler = new TextChannelInboundHandler(connection, outboundHandler);
        return new InitResult<ChannelInboundHandler>(inputBuffer, inboundHandler);
    }

    private ByteBuffer newInputBuffer(Channel channel, int sizeKb) {
        boolean directBuffer = this.ioService.useDirectSocketBuffer();
        int sizeBytes = sizeKb * 1024;
        ByteBuffer inputBuffer = IOUtil.newByteBuffer(sizeBytes, directBuffer);
        try {
            channel.socket().setReceiveBufferSize(sizeBytes);
        }
        catch (SocketException e) {
            this.logger.finest("Failed to adjust TCP receive buffer of " + channel + " to " + sizeBytes + " B.", e);
        }
        return inputBuffer;
    }

    @Override
    public InitResult<ChannelOutboundHandler> initOutbound(Channel channel) {
        String protocol = this.outboundProtocol(channel);
        if (protocol == null) {
            return null;
        }
        if ("HZC".equals(protocol)) {
            return this.initOutboundClusterProtocol(channel);
        }
        if ("CB2".equals(protocol)) {
            return this.initOutboundClientProtocol(channel);
        }
        return this.initOutboundTextProtocol(channel);
    }

    private String outboundProtocol(Channel channel) {
        String protocol = (String)channel.attributeMap().get(PROTOCOL);
        if (protocol == null && channel.isClientMode()) {
            protocol = "HZC";
        }
        return protocol;
    }

    private InitResult<ChannelOutboundHandler> initOutboundClusterProtocol(Channel channel) {
        TcpIpConnection connection = (TcpIpConnection)channel.attributeMap().get(TcpIpConnection.class);
        ChannelOutboundHandler outboundHandler = this.ioService.createOutboundHandler(connection);
        ByteBuffer outputBuffer = this.newOutputBuffer(channel, this.ioService.getSocketSendBufferSize());
        outputBuffer.put(StringUtil.stringToBytes("HZC"));
        return new InitResult<ChannelOutboundHandler>(outputBuffer, outboundHandler);
    }

    private InitResult<ChannelOutboundHandler> initOutboundClientProtocol(Channel channel) {
        ClientChannelOutboundHandler outboundHandler = new ClientChannelOutboundHandler();
        ByteBuffer outputBuffer = this.newOutputBuffer(channel, this.ioService.getSocketClientSendBufferSize());
        return new InitResult<ChannelOutboundHandler>(outputBuffer, outboundHandler);
    }

    private InitResult<ChannelOutboundHandler> initOutboundTextProtocol(Channel channel) {
        ChannelOutboundHandler outboundHandler = (ChannelOutboundHandler)channel.attributeMap().get(TEXT_OUTBOUND_HANDLER);
        ByteBuffer outputBuffer = this.newOutputBuffer(channel, this.ioService.getSocketClientSendBufferSize());
        return new InitResult<ChannelOutboundHandler>(outputBuffer, outboundHandler);
    }

    private ByteBuffer newOutputBuffer(Channel channel, int sizeKb) {
        int size = 1024 * sizeKb;
        ByteBuffer outputBuffer = IOUtil.newByteBuffer(size, this.ioService.useDirectSocketBuffer());
        try {
            channel.socket().setSendBufferSize(size);
        }
        catch (SocketException e) {
            this.logger.finest("Failed to adjust TCP send buffer of " + channel + " to " + size + " B.", e);
        }
        return outputBuffer;
    }
}

