/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.invalidation;

import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.InternalCompletableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;

public abstract class MetaDataFetcher {
    protected static final int ASYNC_RESULT_WAIT_TIMEOUT_MINUTES = 1;
    protected final ILogger logger;

    public MetaDataFetcher(ILogger logger) {
        this.logger = logger;
    }

    protected abstract void extractAndPopulateResult(InternalCompletableFuture var1, ResultHolder var2) throws Exception;

    protected abstract List<InternalCompletableFuture> scanMembers(List<String> var1);

    public final void init(RepairingHandler handler) throws Exception {
        ResultHolder resultHolder = new ResultHolder();
        List<InternalCompletableFuture> futures = this.scanMembers(Collections.singletonList(handler.getName()));
        for (InternalCompletableFuture future : futures) {
            this.extractAndPopulateResult(future, resultHolder);
            this.initUuid(resultHolder.partitionUuidList, handler);
            this.initSequence(resultHolder.namePartitionSequenceList, handler);
        }
    }

    public final void process(InternalCompletableFuture future, ConcurrentMap<String, RepairingHandler> handlers) {
        block2: {
            try {
                ResultHolder resultHolder = new ResultHolder();
                this.extractAndPopulateResult(future, resultHolder);
                this.repairUuids(resultHolder.partitionUuidList, handlers);
                this.repairSequences(resultHolder.namePartitionSequenceList, handlers);
            }
            catch (Exception e) {
                if (!this.logger.isWarningEnabled()) break block2;
                this.logger.warning("Can't fetch invalidation meta-data [" + e.getClass().getSimpleName() + "] " + e.getMessage());
            }
        }
    }

    public final void fetchMetadata(ConcurrentMap<String, RepairingHandler> handlers) {
        if (handlers.isEmpty()) {
            return;
        }
        List<String> mapNames = this.getNames(handlers);
        List<InternalCompletableFuture> futures = this.scanMembers(mapNames);
        for (InternalCompletableFuture future : futures) {
            this.process(future, handlers);
        }
    }

    private List<String> getNames(ConcurrentMap<String, RepairingHandler> handlers) {
        ArrayList<String> names = new ArrayList<String>(handlers.size());
        for (RepairingHandler handler : handlers.values()) {
            names.add(handler.getName());
        }
        return names;
    }

    protected void repairUuids(Collection<Map.Entry<Integer, UUID>> uuids, ConcurrentMap<String, RepairingHandler> handlers) {
        for (Map.Entry<Integer, UUID> entry : uuids) {
            for (RepairingHandler handler : handlers.values()) {
                handler.checkOrRepairUuid(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void initUuid(Collection<Map.Entry<Integer, UUID>> uuids, RepairingHandler handler) {
        for (Map.Entry<Integer, UUID> entry : uuids) {
            int partitionID = entry.getKey();
            UUID partitionUuid = entry.getValue();
            handler.initUuid(partitionID, partitionUuid);
        }
    }

    protected void repairSequences(Collection<Map.Entry<String, List<Map.Entry<Integer, Long>>>> namePartitionSequenceList, ConcurrentMap<String, RepairingHandler> handlers) {
        for (Map.Entry<String, List<Map.Entry<Integer, Long>>> entry : namePartitionSequenceList) {
            for (Map.Entry<Integer, Long> subEntry : entry.getValue()) {
                RepairingHandler repairingHandler = (RepairingHandler)handlers.get(entry.getKey());
                repairingHandler.checkOrRepairSequence(subEntry.getKey(), subEntry.getValue(), true);
            }
        }
    }

    protected void initSequence(Collection<Map.Entry<String, List<Map.Entry<Integer, Long>>>> namePartitionSequenceList, RepairingHandler handler) {
        for (Map.Entry<String, List<Map.Entry<Integer, Long>>> entry : namePartitionSequenceList) {
            for (Map.Entry<Integer, Long> subEntry : entry.getValue()) {
                int partitionID = subEntry.getKey();
                long partitionSequence = subEntry.getValue();
                handler.initSequence(partitionID, partitionSequence);
            }
        }
    }

    protected static class ResultHolder {
        private Collection<Map.Entry<String, List<Map.Entry<Integer, Long>>>> namePartitionSequenceList;
        private Collection<Map.Entry<Integer, UUID>> partitionUuidList;

        protected ResultHolder() {
        }

        public void populate(Collection<Map.Entry<Integer, UUID>> partitionUuidList, Collection<Map.Entry<String, List<Map.Entry<Integer, Long>>>> namePartitionSequenceList) {
            this.namePartitionSequenceList = namePartitionSequenceList;
            this.partitionUuidList = partitionUuidList;
        }

        public Collection<Map.Entry<String, List<Map.Entry<Integer, Long>>>> getNamePartitionSequenceList() {
            return this.namePartitionSequenceList;
        }

        public Collection<Map.Entry<Integer, UUID>> getPartitionUuidList() {
            return this.partitionUuidList;
        }
    }
}

