/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.operations;

import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.multimap.impl.MultiMapDataSerializerHook;
import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.multimap.impl.MultiMapService;
import com.hazelcast.multimap.impl.MultiMapValue;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MultiMapReplicationOperation
extends Operation
implements IdentifiedDataSerializable {
    private Map<String, Map> map;

    public MultiMapReplicationOperation() {
    }

    public MultiMapReplicationOperation(Map<String, Map> map) {
        this.map = map;
    }

    @Override
    public void run() throws Exception {
        MultiMapService service = (MultiMapService)this.getService();
        service.insertMigratedData(this.getPartitionId(), this.map);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.map.size());
        for (Map.Entry<String, Map> entry : this.map.entrySet()) {
            String name = entry.getKey();
            out.writeUTF(name);
            Map collections = entry.getValue();
            out.writeInt(collections.size());
            for (Map.Entry collectionEntry : collections.entrySet()) {
                Data key = (Data)collectionEntry.getKey();
                out.writeData(key);
                MultiMapValue multiMapValue = (MultiMapValue)collectionEntry.getValue();
                Collection<MultiMapRecord> coll = multiMapValue.getCollection(false);
                out.writeInt(coll.size());
                String collectionType = MultiMapConfig.ValueCollectionType.SET.name();
                if (coll instanceof List) {
                    collectionType = MultiMapConfig.ValueCollectionType.LIST.name();
                }
                out.writeUTF(collectionType);
                for (MultiMapRecord record : coll) {
                    record.writeData(out);
                }
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int mapSize = in.readInt();
        this.map = new HashMap<String, Map>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            String name = in.readUTF();
            int collectionSize = in.readInt();
            HashMap<Data, MultiMapValue> collections = new HashMap<Data, MultiMapValue>();
            for (int j = 0; j < collectionSize; ++j) {
                Data key = in.readData();
                int collSize = in.readInt();
                String collectionType = in.readUTF();
                AbstractCollection coll = collectionType.equals(MultiMapConfig.ValueCollectionType.SET.name()) ? new HashSet() : new LinkedList();
                for (int k = 0; k < collSize; ++k) {
                    MultiMapRecord record = new MultiMapRecord();
                    record.readData(in);
                    coll.add((MultiMapRecord)record);
                }
                collections.put(key, new MultiMapValue(coll));
            }
            this.map.put(name, collections);
        }
    }

    @Override
    public int getFactoryId() {
        return MultiMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 45;
    }
}

