/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.impl.InternalMigrationListener;
import com.hazelcast.internal.partition.operation.BaseMigrationOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.partition.MigrationEndpoint;
import java.util.logging.Level;

abstract class BaseMigrationDestinationOperation
extends BaseMigrationOperation {
    private static final OperationResponseHandler ERROR_RESPONSE_HANDLER = new OperationResponseHandler(){

        public void sendResponse(Operation op, Object obj) {
            throw new HazelcastException("Migration operations can not send response!");
        }
    };
    Throwable failureReason;

    BaseMigrationDestinationOperation() {
    }

    BaseMigrationDestinationOperation(MigrationInfo migrationInfo, int partitionStateVersion) {
        super(migrationInfo, partitionStateVersion);
    }

    @Override
    protected PartitionMigrationEvent getMigrationEvent() {
        return new PartitionMigrationEvent(MigrationEndpoint.DESTINATION, this.migrationInfo.getPartitionId(), this.migrationInfo.getDestinationCurrentReplicaIndex(), this.migrationInfo.getDestinationNewReplicaIndex());
    }

    @Override
    protected InternalMigrationListener.MigrationParticipant getMigrationParticipantType() {
        return InternalMigrationListener.MigrationParticipant.DESTINATION;
    }

    protected void prepareOperation(Operation op) {
        op.setNodeEngine(this.getNodeEngine()).setPartitionId(this.getPartitionId()).setReplicaIndex(this.getReplicaIndex());
        op.setOperationResponseHandler(ERROR_RESPONSE_HANDLER);
        OperationAccessor.setCallerAddress(op, this.migrationInfo.getSource());
    }

    final void verifyMasterOnMigrationDestination() {
        NodeEngine nodeEngine = this.getNodeEngine();
        Address masterAddress = nodeEngine.getMasterAddress();
        if (!masterAddress.equals(this.migrationInfo.getMaster())) {
            ClusterService clusterService = nodeEngine.getClusterService();
            if (clusterService.getClusterVersion().isGreaterOrEqual(Versions.V3_9)) {
                throw new IllegalStateException("Migration initiator is not master node! => " + this.toString());
            }
            throw new RetryableHazelcastException("Migration initiator is not master node! => " + this.toString());
        }
    }

    final void runMigrationOperation(Operation op) throws Exception {
        this.prepareOperation(op);
        op.beforeRun();
        op.run();
        op.afterRun();
    }

    final void logMigrationCancelled() {
        this.getLogger().warning("Migration is cancelled -> " + this.migrationInfo);
    }

    final void logMigrationFailure(Throwable e) {
        ILogger logger;
        Level level = Level.WARNING;
        if (e instanceof IllegalStateException) {
            level = Level.FINEST;
        }
        if ((logger = this.getLogger()).isLoggable(level)) {
            logger.log(level, e.getMessage(), e);
        }
    }
}

