/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.create;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.servlet.ServletContext;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import uk.ltd.getahead.dwr.Creator;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.WebContext;
import uk.ltd.getahead.dwr.WebContextFactory;
import uk.ltd.getahead.dwr.create.AbstractCreator;
import uk.ltd.getahead.dwr.util.Logger;

public class ScriptedCreator
extends AbstractCreator
implements Creator {
    private static final Logger log = Logger.getLogger(ScriptedCreator.class);
    private Class clazz = null;
    private String language = null;
    private String scriptSrc = null;
    private String scriptPath = null;
    private boolean reloadable = true;
    private boolean useDynamicClasses = false;
    private long scriptModified = -1L;
    private String cachedScript;

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String isReloadable() {
        return String.valueOf(this.reloadable);
    }

    public void setReloadable(String reloadable) {
        this.reloadable = Boolean.valueOf(reloadable);
    }

    public String isUseDynamicClasses() {
        return String.valueOf(this.useDynamicClasses);
    }

    public void setUseDynamicClasses(String useDynamicClasses) {
        this.useDynamicClasses = Boolean.valueOf(useDynamicClasses);
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        if (this.scriptSrc != null) {
            throw new IllegalArgumentException(Messages.getString("ScriptCreator.MultipleScript"));
        }
        this.scriptPath = scriptPath;
    }

    private boolean scriptUpdated() {
        if (null == this.scriptPath) {
            return false;
        }
        ServletContext sc = WebContextFactory.get().getServletContext();
        File scriptFile = new File(sc.getRealPath(this.scriptPath));
        if (this.scriptModified < scriptFile.lastModified()) {
            log.debug("Script has been updated.");
            this.clazz = null;
            return true;
        }
        return false;
    }

    public String getScript() throws InstantiationException {
        if (this.scriptSrc != null) {
            return this.scriptSrc;
        }
        if (this.scriptPath == null) {
            throw new InstantiationException(Messages.getString("ScriptedCreator.MissingScript"));
        }
        if (!(this.cachedScript == null || this.reloadable && this.scriptUpdated())) {
            return this.cachedScript;
        }
        log.debug("Loading Script from Path: " + this.scriptPath);
        RandomAccessFile in = null;
        try {
            ServletContext sc = WebContextFactory.get().getServletContext();
            File scriptFile = new File(sc.getRealPath(this.scriptPath));
            this.scriptModified = scriptFile.lastModified();
            in = new RandomAccessFile(scriptFile, "r");
            byte[] bytes = new byte[(int)in.length()];
            in.readFully(bytes);
            String string = this.cachedScript = new String(bytes);
            return string;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new InstantiationException(Messages.getString("ScriptCreator.MissingScript"));
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    log.warn(ex.getMessage(), ex);
                }
            }
        }
    }

    public void setScript(String scriptSrc) {
        if (this.scriptPath != null) {
            throw new IllegalArgumentException(Messages.getString("ScriptCreator.MultipleScript"));
        }
        if (scriptSrc == null || scriptSrc.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.getString("ScriptedCreator.MissingScript"));
        }
        this.scriptSrc = scriptSrc;
    }

    public void setClass(String classname) {
        try {
            this.clazz = Class.forName(classname);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(Messages.getString("Creator.ClassNotFound", classname));
        }
    }

    public Class getType() {
        if (this.clazz == null || this.reloadable && this.scriptUpdated()) {
            try {
                this.clazz = this.getInstance().getClass();
            }
            catch (InstantiationException ex) {
                log.error("Failed to instansiate object to detect type.", ex);
                return Object.class;
            }
        }
        return this.clazz;
    }

    public Object getInstance() throws InstantiationException {
        try {
            if (this.useDynamicClasses && this.clazz != null) {
                return this.clazz.newInstance();
            }
            BSFManager bsfman = new BSFManager();
            try {
                WebContext context = WebContextFactory.get();
                bsfman.declareBean("context", (Object)context, context.getClass());
            }
            catch (BSFException ex) {
                log.warn("Failed to register WebContext with scripting engine: " + ex.getMessage());
            }
            return bsfman.eval(this.language, null == this.scriptPath ? "dwr.xml" : this.scriptPath, 0, 0, (Object)this.getScript());
        }
        catch (Exception ex) {
            log.error("Error executing script", ex);
            throw new InstantiationException(Messages.getString("Creator.IllegalAccess"));
        }
    }
}

