/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.tls.TlsCipherSuite;
import org.bouncycastle.crypto.tls.TlsMac;
import org.bouncycastle.crypto.tls.TlsProtocolHandler;
import org.bouncycastle.crypto.tls.TlsUtils;

public class TlsBlockCipherCipherSuite
extends TlsCipherSuite {
    private BlockCipher encryptCipher;
    private BlockCipher decryptCipher;
    private Digest writeDigest;
    private Digest readDigest;
    private int cipherKeySize;
    private short keyExchange;
    private TlsMac writeMac;
    private TlsMac readMac;

    protected TlsBlockCipherCipherSuite(BlockCipher blockCipher, BlockCipher blockCipher2, Digest digest, Digest digest2, int n, short s) {
        this.encryptCipher = blockCipher;
        this.decryptCipher = blockCipher2;
        this.writeDigest = digest;
        this.readDigest = digest2;
        this.cipherKeySize = n;
        this.keyExchange = s;
    }

    protected void init(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = 2 * this.cipherKeySize + 2 * this.writeDigest.getDigestSize() + 2 * this.encryptCipher.getBlockSize();
        byte[] byArray4 = new byte[n];
        byte[] byArray5 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray5, byArray3.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
        TlsUtils.PRF(byArray, "key expansion".getBytes(), byArray5, byArray4);
        int n2 = 0;
        this.writeMac = new TlsMac(this.writeDigest, byArray4, n2, this.writeDigest.getDigestSize());
        this.readMac = new TlsMac(this.readDigest, byArray4, n2 += this.writeDigest.getDigestSize(), this.readDigest.getDigestSize());
        this.initCipher(true, this.encryptCipher, byArray4, this.cipherKeySize, n2 += this.readDigest.getDigestSize(), n2 + this.cipherKeySize * 2);
        this.initCipher(false, this.decryptCipher, byArray4, this.cipherKeySize, n2 += this.cipherKeySize, n2 + this.cipherKeySize + this.decryptCipher.getBlockSize());
    }

    private void initCipher(boolean bl, BlockCipher blockCipher, byte[] byArray, int n, int n2, int n3) {
        KeyParameter keyParameter = new KeyParameter(byArray, n2, n);
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, byArray, n3, blockCipher.getBlockSize());
        blockCipher.init(bl, parametersWithIV);
    }

    protected byte[] encodePlaintext(short s, byte[] byArray, int n, int n2) {
        int n3;
        int n4 = this.encryptCipher.getBlockSize();
        int n5 = n4 - (n2 + this.writeMac.getSize() + 1) % n4;
        int n6 = n2 + this.writeMac.getSize() + n5 + 1;
        byte[] byArray2 = new byte[n6];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        byte[] byArray3 = this.writeMac.calculateMac(s, byArray, n, n2);
        System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
        int n7 = n2 + byArray3.length;
        for (n3 = 0; n3 <= n5; ++n3) {
            byArray2[n3 + n7] = (byte)n5;
        }
        for (n3 = 0; n3 < n6; n3 += n4) {
            this.encryptCipher.processBlock(byArray2, n3, byArray2, n3);
        }
        return byArray2;
    }

    protected byte[] decodeCiphertext(short s, byte[] byArray, int n, int n2, TlsProtocolHandler tlsProtocolHandler) throws IOException {
        int n3;
        int n4;
        int n5 = this.decryptCipher.getBlockSize();
        boolean bl = false;
        for (n4 = 0; n4 < n2; n4 += n5) {
            this.decryptCipher.processBlock(byArray, n4 + n, byArray, n4 + n);
        }
        n4 = byArray[n + n2 - 1];
        if (n + n2 - 1 - n4 < 0) {
            bl = true;
            n4 = 0;
        } else {
            for (n3 = 0; n3 <= n4; ++n3) {
                if (byArray[n + n2 - 1 - n3] == n4) continue;
                bl = true;
            }
        }
        n3 = n2 - this.readMac.getSize() - n4 - 1;
        byte[] byArray2 = this.readMac.calculateMac(s, byArray, n, n3);
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[n + n3 + i] == byArray2[i]) continue;
            bl = true;
        }
        if (bl) {
            tlsProtocolHandler.failWithError((short)2, (short)20);
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n, byArray3, 0, n3);
        return byArray3;
    }

    protected short getKeyExchangeAlgorithm() {
        return this.keyExchange;
    }
}

