/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlTemplate;
import org.jrobin.graph.ExportData;
import org.jrobin.graph.RrdGraphDef;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RrdGraphDefTemplate
extends XmlTemplate {
    private RrdGraphDef rrdGraphDef;

    public RrdGraphDefTemplate(InputSource inputSource) throws IOException, RrdException {
        super(inputSource);
    }

    public RrdGraphDefTemplate(File xmlFile) throws IOException, RrdException {
        super(xmlFile);
    }

    public RrdGraphDefTemplate(String xmlString) throws IOException, RrdException {
        super(xmlString);
    }

    public RrdGraphDef getRrdGraphDef() throws RrdException {
        if (!this.root.getTagName().equals("rrd_graph_def")) {
            throw new RrdException("XML definition must start with <rrd_graph_def>");
        }
        this.validateTagsOnlyOnce(this.root, new String[]{"span", "options", "datasources", "graph"});
        this.rrdGraphDef = new RrdGraphDef();
        Node[] childs = RrdGraphDefTemplate.getChildNodes(this.root);
        for (int i = 0; i < childs.length; ++i) {
            String nodeName = childs[i].getNodeName();
            if (nodeName.equals("span")) {
                this.resolveSpan(childs[i]);
                continue;
            }
            if (nodeName.equals("options")) {
                this.resolveOptions(childs[i]);
                continue;
            }
            if (nodeName.equals("datasources")) {
                this.resolveDatasources(childs[i]);
                continue;
            }
            if (!nodeName.equals("graph")) continue;
            this.resolveGraphElements(childs[i]);
        }
        return this.rrdGraphDef;
    }

    private void resolveGraphElements(Node graphNode) throws RrdException {
        this.validateTagsOnlyOnce(graphNode, new String[]{"area*", "line*", "stack*", "gprint*", "hrule*", "vrule*", "comment*", "time*"});
        Node[] childs = RrdGraphDefTemplate.getChildNodes(graphNode);
        for (int i = 0; i < childs.length; ++i) {
            int width;
            String legend;
            Color color;
            String colorStr;
            String datasource;
            String nodeName = childs[i].getNodeName();
            if (nodeName.equals("area")) {
                this.resolveArea(childs[i]);
                continue;
            }
            if (nodeName.equals("line")) {
                this.resolveLine(childs[i]);
                continue;
            }
            if (nodeName.equals("stack")) {
                this.validateTagsOnlyOnce(childs[i], new String[]{"datasource", "color", "legend"});
                datasource = this.getChildValue(childs[i], "datasource");
                String colorStr2 = this.getChildValue(childs[i], "color");
                Color color2 = Color.decode(colorStr2);
                String legend2 = this.getChildValue(childs[i], "legend", false);
                this.rrdGraphDef.stack(datasource, color2, legend2);
                continue;
            }
            if (nodeName.equals("comment")) {
                String comment = this.getValue(childs[i], false);
                this.rrdGraphDef.comment(comment);
                continue;
            }
            if (nodeName.equals("gprint")) {
                this.validateTagsOnlyOnce(childs[i], new String[]{"datasource", "cf", "format", "base"});
                datasource = this.getChildValue(childs[i], "datasource");
                String consolFun = this.getChildValue(childs[i], "cf");
                String format = this.getChildValue(childs[i], "format", false);
                if (!this.hasChildNode(childs[i], "base")) {
                    this.rrdGraphDef.gprint(datasource, consolFun, format);
                    continue;
                }
                this.rrdGraphDef.gprint(datasource, consolFun, format, this.getChildValueAsDouble(childs[i], "base"));
                continue;
            }
            if (nodeName.equals("time")) {
                this.validateTagsOnlyOnce(childs[i], new String[]{"format", "pattern", "value"});
                String format = this.getChildValue(childs[i], "format", false);
                String pattern = this.getChildValue(childs[i], "pattern");
                if (Util.Xml.hasChildNode(childs[i], "value")) {
                    String timestamp = this.getChildValue(childs[i], "value");
                    this.rrdGraphDef.time(format, pattern, (Calendar)Util.getGregorianCalendar(timestamp));
                    continue;
                }
                this.rrdGraphDef.time(format, pattern);
                continue;
            }
            if (nodeName.equals("hrule")) {
                this.validateTagsOnlyOnce(childs[i], new String[]{"value", "color", "legend", "width"});
                double value = this.getChildValueAsDouble(childs[i], "value");
                colorStr = this.getChildValue(childs[i], "color");
                color = Color.decode(colorStr);
                legend = this.getChildValue(childs[i], "legend", false);
                width = 1;
                try {
                    width = this.getChildValueAsInt(childs[i], "width");
                }
                catch (RrdException e) {
                    // empty catch block
                }
                this.rrdGraphDef.hrule(value, color, legend, width);
                continue;
            }
            if (!nodeName.equals("vrule")) continue;
            this.validateTagsOnlyOnce(childs[i], new String[]{"time", "color", "legend", "width"});
            String timeStr = this.getChildValue(childs[i], "time");
            GregorianCalendar gc = Util.getGregorianCalendar(timeStr);
            colorStr = this.getChildValue(childs[i], "color");
            color = Color.decode(colorStr);
            legend = this.getChildValue(childs[i], "legend", false);
            width = 1;
            try {
                width = this.getChildValueAsInt(childs[i], "width");
            }
            catch (RrdException e) {
                // empty catch block
            }
            this.rrdGraphDef.vrule(gc, color, legend, width);
        }
    }

    private void resolveLine(Node lineNode) throws RrdException {
        if (this.hasChildNode(lineNode, "datasource")) {
            this.validateTagsOnlyOnce(lineNode, new String[]{"datasource", "color", "legend", "width"});
            String datasource = this.getChildValue(lineNode, "datasource");
            String colorStr = this.getChildValue(lineNode, "color");
            Color color = Color.decode(colorStr);
            String legend = this.getChildValue(lineNode, "legend", false);
            int width = 1;
            try {
                width = this.getChildValueAsInt(lineNode, "width");
            }
            catch (RrdException e) {
                // empty catch block
            }
            this.rrdGraphDef.line(datasource, color, legend, width);
        } else if (this.hasChildNode(lineNode, "time1")) {
            this.validateTagsOnlyOnce(lineNode, new String[]{"time1", "time2", "value1", "value2", "color", "legend", "width"});
            String t1str = this.getChildValue(lineNode, "time1");
            GregorianCalendar gc1 = Util.getGregorianCalendar(t1str);
            String t2str = this.getChildValue(lineNode, "time2");
            GregorianCalendar gc2 = Util.getGregorianCalendar(t2str);
            double v1 = this.getChildValueAsDouble(lineNode, "value1");
            double v2 = this.getChildValueAsDouble(lineNode, "value2");
            String colorStr = this.getChildValue(lineNode, "color");
            Color color = Color.decode(colorStr);
            String legend = this.getChildValue(lineNode, "legend", false);
            int width = 1;
            try {
                width = this.getChildValueAsInt(lineNode, "width");
            }
            catch (RrdException e) {
                // empty catch block
            }
            this.rrdGraphDef.line(gc1, v1, gc2, v2, color, legend, width);
        } else {
            throw new RrdException("Unrecognized <line> format");
        }
    }

    private void resolveArea(Node areaNode) throws RrdException {
        if (this.hasChildNode(areaNode, "datasource")) {
            this.validateTagsOnlyOnce(areaNode, new String[]{"datasource", "color", "legend"});
            String datasource = this.getChildValue(areaNode, "datasource");
            String colorStr = this.getChildValue(areaNode, "color");
            Color color = Color.decode(colorStr);
            String legend = this.getChildValue(areaNode, "legend", false);
            this.rrdGraphDef.area(datasource, color, legend);
        } else if (this.hasChildNode(areaNode, "time1")) {
            this.validateTagsOnlyOnce(areaNode, new String[]{"time1", "time2", "value1", "value2", "color", "legend", "width"});
            String t1str = this.getChildValue(areaNode, "time1");
            GregorianCalendar gc1 = Util.getGregorianCalendar(t1str);
            String t2str = this.getChildValue(areaNode, "time2");
            GregorianCalendar gc2 = Util.getGregorianCalendar(t2str);
            double v1 = this.getChildValueAsDouble(areaNode, "value1");
            double v2 = this.getChildValueAsDouble(areaNode, "value2");
            String colorStr = this.getChildValue(areaNode, "color");
            Color color = Color.decode(colorStr);
            String legend = this.getChildValue(areaNode, "legend", false);
            this.rrdGraphDef.area(gc1, v1, gc2, v2, color, legend);
        } else {
            throw new RrdException("Unrecognized <area> format");
        }
    }

    private void resolveDatasources(Node datasourceNode) throws RrdException {
        int i;
        this.validateTagsOnlyOnce(datasourceNode, new String[]{"def*", "export_data*"});
        Node[] nodes = RrdGraphDefTemplate.getChildNodes(datasourceNode, "def");
        for (i = 0; i < nodes.length; ++i) {
            String name;
            if (this.hasChildNode(nodes[i], "rrd")) {
                this.validateTagsOnlyOnce(nodes[i], new String[]{"name", "rrd", "source", "cf", "backend"});
                name = this.getChildValue(nodes[i], "name");
                String rrd = this.getChildValue(nodes[i], "rrd");
                String dsName = this.getChildValue(nodes[i], "source");
                String consolFun = this.getChildValue(nodes[i], "cf");
                if (Util.Xml.hasChildNode(nodes[i], "backend")) {
                    String backend = this.getChildValue(nodes[i], "backend");
                    this.rrdGraphDef.datasource(name, rrd, dsName, consolFun, backend);
                    continue;
                }
                this.rrdGraphDef.datasource(name, rrd, dsName, consolFun);
                continue;
            }
            if (this.hasChildNode(nodes[i], "rpn")) {
                this.validateTagsOnlyOnce(nodes[i], new String[]{"name", "rpn"});
                name = this.getChildValue(nodes[i], "name");
                String rpn = this.getChildValue(nodes[i], "rpn");
                this.rrdGraphDef.datasource(name, rpn);
                continue;
            }
            if (this.hasChildNode(nodes[i], "cf") || this.hasChildNode(nodes[i], "datasource")) {
                this.validateTagsOnlyOnce(nodes[i], new String[]{"name", "datasource", "cf"});
                name = this.getChildValue(nodes[i], "name");
                String ds = this.getChildValue(nodes[i], "datasource");
                String cf = this.getChildValue(nodes[i], "cf");
                this.rrdGraphDef.datasource(name, ds, cf);
                continue;
            }
            throw new RrdException("Unrecognized <def> format");
        }
        nodes = RrdGraphDefTemplate.getChildNodes(datasourceNode, "export_data");
        for (i = 0; i < nodes.length; ++i) {
            this.validateTagsOnlyOnce(nodes[i], new String[]{"file", "ds_name_prefix", "use_legend_names"});
            String file = this.getChildValue(nodes[i], "file");
            String prefix = "d";
            boolean use_legends = false;
            if (Util.Xml.hasChildNode(nodes[i], "ds_name_prefix")) {
                prefix = this.getChildValue(nodes[i], "ds_name_prefix");
            }
            if (Util.Xml.hasChildNode(nodes[i], "use_legend_names")) {
                use_legends = this.getChildValueAsBoolean(nodes[i], "use_legend_names");
            }
            try {
                if (!prefix.equals("d")) {
                    this.rrdGraphDef.addExportData(new ExportData(new File(file), prefix));
                    continue;
                }
                this.rrdGraphDef.addExportData(new ExportData(new File(file), use_legends));
                continue;
            }
            catch (IOException ioe) {
                throw new RrdException(ioe);
            }
        }
    }

    private void resolveOptions(Node rootOptionNode) throws RrdException {
        this.validateTagsOnlyOnce(rootOptionNode, new String[]{"anti_aliasing", "arrow_color", "axis_color", "back_color", "background", "base_value", "canvas", "left_padding", "default_font", "default_font_color", "frame_color", "front_grid", "grid_range", "grid_x", "grid_y", "border", "major_grid_color", "major_grid_x", "major_grid_y", "minor_grid_color", "minor_grid_x", "minor_grid_y", "overlay", "show_legend", "show_signature", "time_axis", "time_axis_label", "title", "title_font", "title_font_color", "units_exponent", "value_axis", "vertical_label", "strict_export", "resolution", "lower_limit"});
        Node[] optionNodes = RrdGraphDefTemplate.getChildNodes(rootOptionNode);
        for (int i = 0; i < optionNodes.length; ++i) {
            String option = optionNodes[i].getNodeName();
            Node optionNode = optionNodes[i];
            if (option.equals("anti_aliasing")) {
                boolean antiAliasing = this.getValueAsBoolean(optionNode);
                this.rrdGraphDef.setAntiAliasing(antiAliasing);
                continue;
            }
            if (option.equals("arrow_color")) {
                String colorStr = this.getValue(optionNode);
                this.rrdGraphDef.setArrowColor(Color.decode(colorStr));
                continue;
            }
            if (option.equals("axis_color")) {
                String colorStr = this.getValue(optionNode);
                this.rrdGraphDef.setAxisColor(Color.decode(colorStr));
                continue;
            }
            if (option.equals("back_color")) {
                String colorStr = this.getValue(optionNode);
                this.rrdGraphDef.setBackColor(Color.decode(colorStr));
                continue;
            }
            if (option.equals("background")) {
                String backgroundFile = this.getValue(optionNode);
                this.rrdGraphDef.setBackground(backgroundFile);
                continue;
            }
            if (option.equals("base_value")) {
                double baseValue = this.getValueAsDouble(optionNode);
                this.rrdGraphDef.setBaseValue(baseValue);
                continue;
            }
            if (option.equals("canvas")) {
                String colorStr = this.getValue(optionNode);
                this.rrdGraphDef.setCanvasColor(Color.decode(colorStr));
                continue;
            }
            if (option.equals("left_padding")) {
                int padding = this.getValueAsInt(optionNode);
                this.rrdGraphDef.setChartLeftPadding(padding);
                continue;
            }
            if (option.equals("default_font")) {
                Font f = this.resolveFont(optionNode);
                this.rrdGraphDef.setDefaultFont(f);
                continue;
            }
            if (option.equals("default_font_color")) {
                String colorStr = this.getValue(optionNode);
                this.rrdGraphDef.setDefaultFontColor(Color.decode(colorStr));
                continue;
            }
            if (option.equals("frame_color")) {
                String colorStr = this.getValue(optionNode);
                this.rrdGraphDef.setFrameColor(Color.decode(colorStr));
                continue;
            }
            if (option.equals("front_grid")) {
                boolean frontGrid = this.getValueAsBoolean(optionNode);
                this.rrdGraphDef.setFrontGrid(frontGrid);
                continue;
            }
            if (option.equals("grid_range")) {
                this.validateTagsOnlyOnce(optionNode, new String[]{"lower", "upper", "rigid"});
                double lower = this.getChildValueAsDouble(optionNode, "lower");
                double upper = this.getChildValueAsDouble(optionNode, "upper");
                boolean rigid = this.getChildValueAsBoolean(optionNode, "rigid");
                this.rrdGraphDef.setGridRange(lower, upper, rigid);
                continue;
            }
            if (option.equals("lower_limit")) {
                double lower = this.getValueAsDouble(optionNode);
                this.rrdGraphDef.setLowerLimit(lower);
                continue;
            }
            if (option.equals("grid_x")) {
                boolean gx = this.getValueAsBoolean(optionNode);
                this.rrdGraphDef.setGridX(gx);
                continue;
            }
            if (option.equals("grid_y")) {
                boolean gy = this.getValueAsBoolean(optionNode);
                this.rrdGraphDef.setGridY(gy);
                continue;
            }
            if (option.equals("border")) {
                this.validateTagsOnlyOnce(optionNode, new String[]{"color", "width"});
                String colorStr = this.getChildValue(optionNode, "color");
                int width = this.getChildValueAsInt(optionNode, "width");
                this.rrdGraphDef.setImageBorder(Color.decode(colorStr), width);
                continue;
            }
            if (option.equals("major_grid_color")) {
                String colorStr = this.getValue(optionNode);
                this.rrdGraphDef.setMajorGridColor(Color.decode(colorStr));
                continue;
            }
            if (option.equals("major_grid_x")) {
                boolean gx = this.getValueAsBoolean(optionNode);
                this.rrdGraphDef.setMajorGridX(gx);
                continue;
            }
            if (option.equals("major_grid_y")) {
                boolean gy = this.getValueAsBoolean(optionNode);
                this.rrdGraphDef.setMajorGridY(gy);
                continue;
            }
            if (option.equals("minor_grid_color")) {
                String colorStr = this.getValue(optionNode);
                this.rrdGraphDef.setMinorGridColor(Color.decode(colorStr));
                continue;
            }
            if (option.equals("minor_grid_x")) {
                boolean gx = this.getValueAsBoolean(optionNode);
                this.rrdGraphDef.setMinorGridX(gx);
                continue;
            }
            if (option.equals("minor_grid_y")) {
                boolean gy = this.getValueAsBoolean(optionNode);
                this.rrdGraphDef.setMinorGridY(gy);
                continue;
            }
            if (option.equals("overlay")) {
                String overlay = this.getValue(optionNode);
                this.rrdGraphDef.setOverlay(overlay);
                continue;
            }
            if (option.equals("show_legend")) {
                boolean show = this.getValueAsBoolean(optionNode);
                this.rrdGraphDef.setShowLegend(show);
                continue;
            }
            if (option.equals("show_signature")) {
                boolean show = this.getValueAsBoolean(optionNode);
                this.rrdGraphDef.setShowSignature(show);
                continue;
            }
            if (option.equals("time_axis")) {
                this.validateTagsOnlyOnce(optionNode, new String[]{"min_grid_time_unit", "min_grid_unit_steps", "maj_grid_time_unit", "maj_grid_unit_steps", "date_format", "center_labels", "first_day_of_week"});
                if (this.hasChildNode(optionNode, "min_grid_time_unit")) {
                    int unit1 = this.resolveUnit(this.getChildValue(optionNode, "min_grid_time_unit"));
                    int step1 = this.getChildValueAsInt(optionNode, "min_grid_unit_steps");
                    int unit2 = this.resolveUnit(this.getChildValue(optionNode, "maj_grid_time_unit"));
                    int step2 = this.getChildValueAsInt(optionNode, "maj_grid_unit_steps");
                    String format = this.getChildValue(optionNode, "date_format");
                    boolean center = this.getChildValueAsBoolean(optionNode, "center_labels");
                    this.rrdGraphDef.setTimeAxis(unit1, step1, unit2, step2, format, center);
                }
                if (!this.hasChildNode(optionNode, "first_day_of_week")) continue;
                int dow = this.resolveDayUnit(this.getChildValue(optionNode, "first_day_of_week"));
                this.rrdGraphDef.setFirstDayOfWeek(dow);
                continue;
            }
            if (option.equals("time_axis_label")) {
                String label = this.getValue(optionNode);
                this.rrdGraphDef.setTimeAxisLabel(label);
                continue;
            }
            if (option.equals("title")) {
                String title = this.getValue(optionNode);
                this.rrdGraphDef.setTitle(title);
                continue;
            }
            if (option.equals("title_font")) {
                Font f = this.resolveFont(optionNode);
                this.rrdGraphDef.setTitleFont(f);
                continue;
            }
            if (option.equals("title_font_color")) {
                String colorStr = this.getValue(optionNode);
                this.rrdGraphDef.setTitleFontColor(Color.decode(colorStr));
                continue;
            }
            if (option.equals("units_exponent")) {
                int exp = this.getValueAsInt(optionNode);
                this.rrdGraphDef.setUnitsExponent(exp);
                continue;
            }
            if (option.equals("value_axis")) {
                this.validateTagsOnlyOnce(optionNode, new String[]{"grid_step", "label_step"});
                double gridStep = this.getChildValueAsDouble(optionNode, "grid_step");
                double labelStep = this.getChildValueAsDouble(optionNode, "label_step");
                this.rrdGraphDef.setValueAxis(gridStep, labelStep);
                continue;
            }
            if (option.equals("vertical_label")) {
                String label = this.getValue(optionNode);
                this.rrdGraphDef.setVerticalLabel(label);
                continue;
            }
            if (option.equals("strict_export")) {
                this.rrdGraphDef.setStrictExport(this.getValueAsBoolean(optionNode));
                continue;
            }
            if (!option.equals("resolution")) continue;
            this.rrdGraphDef.setResolution(this.getValueAsInt(optionNode));
        }
    }

    private int resolveUnit(String unit) {
        if (unit.equalsIgnoreCase("second")) {
            return 0;
        }
        if (unit.equalsIgnoreCase("minute")) {
            return 1;
        }
        if (unit.equalsIgnoreCase("hour")) {
            return 2;
        }
        if (unit.equalsIgnoreCase("day")) {
            return 3;
        }
        if (unit.equalsIgnoreCase("week")) {
            return 4;
        }
        if (unit.equalsIgnoreCase("month")) {
            return 5;
        }
        if (unit.equalsIgnoreCase("year")) {
            return 6;
        }
        throw new IllegalArgumentException("Invalid unit specified: " + unit);
    }

    private int resolveDayUnit(String unit) {
        if (unit.equalsIgnoreCase("monday")) {
            return 2;
        }
        if (unit.equalsIgnoreCase("tuesday")) {
            return 3;
        }
        if (unit.equalsIgnoreCase("wednesday")) {
            return 4;
        }
        if (unit.equalsIgnoreCase("thursday")) {
            return 5;
        }
        if (unit.equalsIgnoreCase("friday")) {
            return 6;
        }
        if (unit.equalsIgnoreCase("saturday")) {
            return 7;
        }
        if (unit.equalsIgnoreCase("sunday")) {
            return 1;
        }
        throw new IllegalArgumentException("Invalid day unit specified: " + unit);
    }

    private void resolveSpan(Node spanNode) throws RrdException {
        this.validateTagsOnlyOnce(spanNode, new String[]{"start", "end"});
        String startStr = this.getChildValue(spanNode, "start");
        String endStr = this.getChildValue(spanNode, "end");
        GregorianCalendar gc1 = Util.getGregorianCalendar(startStr);
        GregorianCalendar gc2 = Util.getGregorianCalendar(endStr);
        this.rrdGraphDef.setTimePeriod(gc1, gc2);
    }

    private Font resolveFont(Node fontNode) throws RrdException {
        this.validateTagsOnlyOnce(fontNode, new String[]{"name", "style", "size"});
        String name = this.getChildValue(fontNode, "name");
        String style = this.getChildValue(fontNode, "style");
        int size = this.getChildValueAsInt(fontNode, "size");
        int stl = 0;
        if (style.equalsIgnoreCase("BOLD")) {
            stl = 1;
        } else if (style.equalsIgnoreCase("ITALIC")) {
            stl = 2;
        } else if (style.equalsIgnoreCase("BOLDITALIC") || style.equalsIgnoreCase("ITALICBOLD") || style.equalsIgnoreCase("BOLD ITALIC") || style.equalsIgnoreCase("ITALIC BOLD")) {
            stl = 3;
        }
        return new Font(name, stl, size);
    }
}

