/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdOpener;
import org.jrobin.core.Util;
import org.jrobin.graph.Cdef;
import org.jrobin.graph.Def;
import org.jrobin.graph.ExportData;
import org.jrobin.graph.FetchSource;
import org.jrobin.graph.FetchSourceList;
import org.jrobin.graph.Pdef;
import org.jrobin.graph.RpnCalculator;
import org.jrobin.graph.RrdExportDef;
import org.jrobin.graph.Sdef;
import org.jrobin.graph.Source;
import org.jrobin.graph.ValueExtractor;

class RrdExporter {
    private RrdExportDef def;
    private RrdOpener rrdOpener;
    protected int numRows;
    protected int reducedNumRows;
    protected long startTime;
    protected long endTime;
    protected long reducedStartTime;
    protected long reducedEndTime;
    protected long reducedStep;
    protected long[] timestamps;
    protected Source[] sources;
    protected HashMap sourceIndex;

    RrdExporter(RrdExportDef def) {
        this.setRrdOpener(new RrdOpener(false, true));
        this.setExportDef(def);
    }

    RrdExporter(RrdExportDef def, RrdOpener rrdOpener) {
        this.setRrdOpener(rrdOpener);
        this.setExportDef(def);
    }

    void setExportDef(RrdExportDef def) {
        this.def = def;
    }

    void setRrdOpener(RrdOpener rrdOpener) {
        this.rrdOpener = rrdOpener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateSeries(int maxRows) throws RrdException, IOException {
        long vEndTime;
        long vStartTime;
        int i;
        Source[] edefList;
        int[] edefTs;
        FetchSourceList fetchSources = this.def.getFetchSources();
        fetchSources.setRrdOpener(this.rrdOpener);
        long finalEndTime = Long.MAX_VALUE;
        boolean changingEndTime = false;
        long startTime = this.def.getStartTime();
        long endTime = this.def.getEndTime();
        changingEndTime = endTime == 0L;
        this.numRows = maxRows;
        this.reducedNumRows = maxRows;
        int numDefs = this.def.getNumDefs();
        int numSdefs = this.def.getNumSdefs();
        Cdef[] cdefList = this.def.getCdefs();
        int numCdefs = cdefList.length;
        Pdef[] pdefList = this.def.getPdefs();
        int numPdefs = pdefList.length;
        ExportData[] edata = this.def.getExportData();
        if (edata.length > 0) {
            int i2;
            ArrayList<Integer> tsList = new ArrayList<Integer>(30);
            ArrayList<Source> list = new ArrayList<Source>(30);
            for (i2 = 0; i2 < edata.length; ++i2) {
                Source[] esrc = edata[i2].getSources();
                for (int j = 0; j < esrc.length; ++j) {
                    list.add(esrc[j]);
                    tsList.add(new Integer(i2));
                }
            }
            edefTs = new int[tsList.size()];
            for (i2 = 0; i2 < edefTs.length; ++i2) {
                edefTs[i2] = (Integer)tsList.get(i2);
            }
            edefList = list.toArray(new Source[0]);
        } else {
            edefTs = new int[]{};
            edefList = new Source[]{};
        }
        int numEdefs = edefList.length;
        this.sources = new Source[numDefs + numEdefs + numCdefs + numPdefs];
        this.sourceIndex = new HashMap(numDefs + numEdefs + numCdefs + numPdefs);
        int tblPos = 0;
        int vePos = 0;
        ValueExtractor[] veList = new ValueExtractor[fetchSources.size()];
        long requestedStep = (endTime - startTime) / (long)maxRows;
        if (requestedStep <= 0L) {
            requestedStep = 1L;
        }
        int minReduceFactor = 1;
        long minStep = Integer.MAX_VALUE;
        long maxStep = Integer.MIN_VALUE;
        if (fetchSources.size() > 0 || numEdefs > 0) {
            try {
                FetchSource src;
                fetchSources.openAll();
                for (i = 0; i < fetchSources.size(); ++i) {
                    src = fetchSources.get(i);
                    if (changingEndTime) {
                        if ((endTime = src.getLastSampleTime(startTime, endTime, this.def.getResolution())) < finalEndTime) {
                            finalEndTime = endTime;
                        }
                        if ((requestedStep = (endTime - startTime) / (long)maxRows) <= 0L) {
                            requestedStep = 1L;
                        }
                    }
                    long[] steps = src.getFetchStep(startTime, endTime, this.def.getResolution());
                    int reduceFactor = (int)Math.ceil((double)requestedStep / (double)steps[0]);
                    steps[0] = steps[0] * (long)reduceFactor;
                    if (steps[0] < minStep) {
                        minStep = steps[0];
                        minReduceFactor = reduceFactor;
                    }
                    if (steps[1] <= maxStep) continue;
                    maxStep = steps[1];
                }
                for (i = 0; i < edata.length; ++i) {
                    int reduceFactor;
                    long step = edata[i].getStep();
                    if ((step *= (long)(reduceFactor = (int)Math.ceil((double)requestedStep / (double)step))) < minStep) {
                        minStep = step;
                        minReduceFactor = reduceFactor;
                    }
                    if (step <= maxStep) continue;
                    maxStep = step;
                }
                vStartTime = Util.normalize(startTime, minStep);
                long l = vStartTime = vStartTime > startTime ? vStartTime - minStep : vStartTime;
                vEndTime = !changingEndTime ? ((vEndTime = Util.normalize(endTime, minStep)) < endTime ? vEndTime + minStep : vEndTime) : ((vEndTime = Util.normalize(finalEndTime, minStep)) < finalEndTime ? vEndTime + minStep : vEndTime);
                this.reducedEndTime = vEndTime;
                this.reducedStartTime = vStartTime;
                this.reducedStep = minStep;
                this.reducedNumRows = (int)((this.reducedEndTime - this.reducedStartTime) / this.reducedStep) + 1;
                long fetchEndTime = Util.normalize(vEndTime, maxStep);
                fetchEndTime = fetchEndTime < vEndTime ? vEndTime + maxStep : fetchEndTime;
                vEndTime = Util.normalize(fetchEndTime, minStep);
                vEndTime = vEndTime < fetchEndTime ? vEndTime + minStep : vEndTime;
                this.numRows = (int)((vEndTime - vStartTime) / minStep) + 1;
                for (i = 0; i < fetchSources.size(); ++i) {
                    src = fetchSources.get(i);
                    ValueExtractor ve = src.fetch(vStartTime, vEndTime, this.def.getResolution(), minReduceFactor);
                    String[] varList = ve.getNames();
                    for (int j = 0; j < varList.length; ++j) {
                        this.sources[tblPos] = new Def(varList[j], this.numRows, this.reducedNumRows);
                        this.sourceIndex.put(varList[j], new Integer(tblPos++));
                    }
                    veList[vePos++] = ve;
                }
            }
            finally {
                fetchSources.releaseAll();
            }
        } else {
            minStep = requestedStep;
            vStartTime = Util.normalize(startTime, minStep);
            long l = vStartTime = vStartTime > startTime ? vStartTime - minStep : vStartTime;
            vEndTime = !changingEndTime ? ((vEndTime = Util.normalize(endTime, minStep)) < endTime ? vEndTime + minStep : vEndTime) : ((vEndTime = Util.normalize(Util.getTime(), minStep)) < endTime ? vEndTime + minStep : vEndTime);
            this.reducedEndTime = vEndTime;
            this.reducedStartTime = vStartTime;
            this.reducedStep = minStep;
            this.reducedNumRows = (int)((this.reducedEndTime - this.reducedStartTime) / this.reducedStep) + 1;
            finalEndTime = endTime;
            vEndTime += minStep;
            this.numRows = this.reducedNumRows;
        }
        for (i = 0; i < edefList.length; ++i) {
            this.sources[tblPos] = new Def(edefList[i].getName(), this.numRows, this.reducedNumRows);
            this.sources[tblPos].setFetchedStep(edefList[i].getStep());
            this.sourceIndex.put(edefList[i].getName(), new Integer(tblPos++));
        }
        for (i = 0; i < pdefList.length; ++i) {
            pdefList[i].prepare(this.numRows, this.reducedNumRows);
            pdefList[i].setFetchedStep(minStep);
            this.sources[tblPos] = pdefList[i];
            this.sourceIndex.put(pdefList[i].getName(), new Integer(tblPos++));
        }
        int cdefStart = tblPos;
        for (int i3 = 0; i3 < cdefList.length; ++i3) {
            cdefList[i3].prepare(this.sourceIndex, this.numRows, this.reducedNumRows);
            cdefList[i3].setFetchedStep(minStep);
            this.sources[tblPos] = cdefList[i3];
            this.sourceIndex.put(cdefList[i3].getName(), new Integer(tblPos++));
        }
        this.timestamps = new long[this.numRows];
        RpnCalculator rpnCalc = new RpnCalculator(this.sources, minStep);
        int pos = 0;
        for (int j = 0; j < veList.length; ++j) {
            pos = veList[j].prepareSources(this.sources, pos);
        }
        if (numSdefs > 0) {
            int treeDepth = 0;
            int[] treeLevel = new int[this.sources.length];
            for (int i4 = cdefStart; i4 < this.sources.length; ++i4) {
                int level = ((Cdef)this.sources[i4]).calculateLevel(treeLevel);
                treeDepth = level > treeDepth ? level : treeDepth;
                treeLevel[i4] = level;
            }
            for (int l = 0; l <= treeDepth; ++l) {
                long t = vStartTime - minStep;
                for (int i5 = 0; i5 < this.numRows; ++i5) {
                    int j;
                    pos = cdefStart;
                    if (l == 0) {
                        pos = 0;
                        t += minStep;
                        for (j = 0; j < veList.length; ++j) {
                            pos = veList[j].extract(t, this.sources, i5, pos);
                        }
                        for (j = pos; j < pos + numEdefs; ++j) {
                            this.sources[j].set(i5, t, edefList[j - pos].get(t, edata[edefTs[j - pos]].getTimestamps()));
                        }
                        for (j = pos += numEdefs; j < pos + numPdefs; ++j) {
                            ((Pdef)this.sources[j]).set(i5, t);
                        }
                        pos += numPdefs;
                        this.timestamps[i5] = t;
                    } else {
                        t = this.timestamps[i5];
                    }
                    for (j = pos; j < this.sources.length; ++j) {
                        if (treeLevel[j] != l) continue;
                        if (this.sources[j] instanceof Sdef) {
                            ((Sdef)this.sources[j]).set(this.sources);
                            continue;
                        }
                        this.sources[j].set(i5, t, rpnCalc.evaluate((Cdef)this.sources[j], i5, t));
                    }
                }
            }
        } else {
            long t = vStartTime - minStep;
            for (int i6 = 0; i6 < this.numRows; ++i6) {
                int j;
                t += minStep;
                pos = 0;
                for (j = 0; j < veList.length; ++j) {
                    pos = veList[j].extract(t, this.sources, i6, pos);
                }
                for (j = pos; j < pos + numEdefs; ++j) {
                    this.sources[j].set(i6, t, edefList[j - pos].get(t, edata[edefTs[j - pos]].getTimestamps()));
                }
                for (j = pos += numEdefs; j < pos + numPdefs; ++j) {
                    ((Pdef)this.sources[j]).set(i6, t);
                }
                for (j = pos += numPdefs; j < this.sources.length; ++j) {
                    this.sources[j].set(i6, t, rpnCalc.evaluate((Cdef)this.sources[j], i6, t));
                }
                this.timestamps[i6] = t;
            }
        }
        veList = null;
        this.startTime = startTime;
        this.endTime = changingEndTime ? finalEndTime : endTime;
    }

    private Source getSource(String name) throws RrdException {
        if (!this.sourceIndex.containsKey(name)) {
            throw new RrdException("No such datasource: " + name);
        }
        return this.sources[(Integer)this.sourceIndex.get(name)];
    }

    protected ExportData createExportData() throws RrdException {
        int i;
        Source[] sourceSet;
        if (this.sources == null) {
            throw new RrdException("Sources not calculated, no data to return.");
        }
        String[][] export = this.def.getExportDatasources();
        HashMap<String, String> legends = new HashMap<String, String>(export.length);
        if (this.def.isStrict()) {
            sourceSet = new Def[export.length];
            for (i = 0; i < export.length; ++i) {
                sourceSet[i] = this.createReducedDef(this.getSource(export[i][0]));
            }
        } else {
            sourceSet = new Def[this.sources.length];
            for (i = 0; i < this.sources.length; ++i) {
                sourceSet[i] = this.createReducedDef(this.sources[i]);
                legends.put(sourceSet[i].getName(), sourceSet[i].getName());
            }
        }
        for (i = 0; i < export.length; ++i) {
            legends.put(export[i][0], export[i][1]);
        }
        long[] reducedTs = new long[this.reducedNumRows];
        System.arraycopy(this.timestamps, 0, reducedTs, 0, this.reducedNumRows);
        return new ExportData(reducedTs, sourceSet, legends);
    }

    private Def createReducedDef(Source origSrc) {
        Def src = new Def(origSrc.getName(), this.reducedNumRows, this.reducedNumRows);
        src.setFetchedStep(this.reducedStep);
        for (int i = 0; i < this.reducedNumRows; ++i) {
            src.set(i, this.timestamps[i], origSrc.get(i));
        }
        return src;
    }

    protected synchronized ExportData fetch(int maxRows) throws RrdException, IOException {
        this.calculateSeries(maxRows);
        return this.createExportData();
    }

    public RrdExportDef getExportDef() {
        return this.def;
    }

    public RrdOpener getRrdOpener() {
        return this.rrdOpener;
    }
}

