/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.ChartGraphics;
import org.jrobin.graph.PlotDef;
import org.jrobin.graph.Source;

class Line
extends PlotDef {
    protected static BasicStroke DEF_LINE_STROKE = new BasicStroke(1.0f);
    protected int lineWidth = 1;

    Line() {
    }

    Line(String sourceName, Color color) {
        super(sourceName, color);
    }

    Line(String sourceName, Color color, int lineWidth) {
        this(sourceName, color);
        this.lineWidth = lineWidth;
    }

    Line(Source source, double[] values, Color color, boolean stacked, boolean visible) {
        super(source, values, color, stacked, visible);
    }

    void draw(ChartGraphics g, int[] xValues, double[] stackValues, int lastPlotType) throws RrdException {
        g.setColor(this.color);
        g.setStroke(this.lineWidth != 1 ? new BasicStroke(this.lineWidth) : DEF_LINE_STROKE);
        Graphics2D gd = g.getGraphics();
        int len = this.values.length;
        int ax = 0;
        int ay = 0;
        int nx = 0;
        int ny = 0;
        for (int i = 0; i < len; ++i) {
            double value = this.values[i];
            nx = xValues[i];
            if (this.stacked) {
                value += stackValues[i];
            }
            ny = g.getY(value);
            if (this.visible && nx != 0 && ay != Integer.MIN_VALUE && ny != Integer.MIN_VALUE) {
                gd.drawLine(ax, -ay, nx, -ny);
            }
            stackValues[i] = value;
            ax = nx;
            ay = ny;
        }
        g.setStroke(STROKE);
    }

    int getLineWidth() {
        return this.lineWidth;
    }

    void exportXmlTemplate(XmlWriter xml, String legend) {
        xml.startTag("line");
        xml.writeTag("datasource", this.sourceName);
        xml.writeTag("color", this.color);
        xml.writeTag("legend", legend);
        xml.writeTag("width", this.lineWidth);
        xml.closeTag();
    }
}

