/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.Archive;
import org.jrobin.core.RrdAllocator;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdDoubleArray;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdInt;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Util;

public class Robin
implements RrdUpdater {
    private Archive parentArc;
    private RrdInt pointer;
    private RrdDoubleArray values;
    private int rows;
    static final /* synthetic */ boolean $assertionsDisabled;

    Robin(Archive parentArc, int rows, boolean shouldInitialize) throws IOException {
        this.parentArc = parentArc;
        this.pointer = new RrdInt(this);
        this.values = new RrdDoubleArray(this, rows);
        this.rows = rows;
        if (shouldInitialize) {
            this.pointer.set(0);
            this.values.set(0, Double.NaN, rows);
        }
    }

    public double[] getValues() throws IOException {
        return this.getValues(0, this.rows);
    }

    void store(double newValue) throws IOException {
        int position = this.pointer.get();
        this.values.set(position, newValue);
        this.pointer.set((position + 1) % this.rows);
    }

    void bulkStore(double newValue, int bulkCount) throws IOException {
        if (!$assertionsDisabled && bulkCount > this.rows) {
            throw new AssertionError((Object)("Invalid number of bulk updates: " + bulkCount + " rows=" + this.rows));
        }
        int position = this.pointer.get();
        int tailUpdateCount = Math.min(this.rows - position, bulkCount);
        this.values.set(position, newValue, tailUpdateCount);
        this.pointer.set((position + tailUpdateCount) % this.rows);
        int headUpdateCount = bulkCount - tailUpdateCount;
        if (headUpdateCount > 0) {
            this.values.set(0, newValue, headUpdateCount);
            this.pointer.set(headUpdateCount);
        }
    }

    void update(double[] newValues) throws IOException {
        if (!$assertionsDisabled && this.rows != newValues.length) {
            throw new AssertionError((Object)("Invalid number of values supplied: " + newValues.length + " rows=" + this.rows));
        }
        this.pointer.set(0);
        this.values.writeDouble(0, newValues);
    }

    String dump() throws IOException {
        StringBuffer buffer = new StringBuffer("Robin " + this.pointer.get() + "/" + this.rows + ": ");
        double[] values = this.getValues();
        for (int i = 0; i < values.length; ++i) {
            buffer.append(Util.formatDouble(values[i], true) + " ");
        }
        buffer.append("\n");
        return buffer.toString();
    }

    public double getValue(int index) throws IOException {
        int arrayIndex = (this.pointer.get() + index) % this.rows;
        return this.values.get(arrayIndex);
    }

    double[] getValues(int index, int count) throws IOException {
        if (!$assertionsDisabled && count > this.rows) {
            throw new AssertionError((Object)("Too many values requested: " + count + " rows=" + this.rows));
        }
        int startIndex = (this.pointer.get() + index) % this.rows;
        int tailReadCount = Math.min(this.rows - startIndex, count);
        double[] tailValues = this.values.get(startIndex, tailReadCount);
        if (tailReadCount < count) {
            int i;
            int headReadCount = count - tailReadCount;
            double[] headValues = this.values.get(0, headReadCount);
            double[] values = new double[count];
            int k = 0;
            for (i = 0; i < tailValues.length; ++i) {
                values[k++] = tailValues[i];
            }
            for (i = 0; i < headValues.length; ++i) {
                values[k++] = headValues[i];
            }
            return values;
        }
        return tailValues;
    }

    public Archive getParent() {
        return this.parentArc;
    }

    public int getSize() {
        return this.rows;
    }

    public void copyStateTo(RrdUpdater other) throws IOException, RrdException {
        if (!(other instanceof Robin)) {
            throw new RrdException("Cannot copy Robin object to " + other.getClass().getName());
        }
        Robin robin = (Robin)other;
        int rowsDiff = this.rows - robin.rows;
        if (rowsDiff == 0) {
            robin.pointer.set(this.pointer.get());
            robin.values.writeBytes(this.values.readBytes());
        } else {
            for (int i = 0; i < robin.rows; ++i) {
                int j = i + rowsDiff;
                robin.store(j >= 0 ? this.getValue(j) : Double.NaN);
            }
        }
    }

    void filterValues(double minValue, double maxValue) throws IOException {
        for (int i = 0; i < this.rows; ++i) {
            double value = this.values.get(i);
            if (!Double.isNaN(minValue) && !Double.isNaN(value) && minValue > value) {
                this.values.set(i, Double.NaN);
            }
            if (Double.isNaN(maxValue) || Double.isNaN(value) || !(maxValue < value)) continue;
            this.values.set(i, Double.NaN);
        }
    }

    public RrdBackend getRrdBackend() {
        return this.parentArc.getRrdBackend();
    }

    public RrdAllocator getRrdAllocator() {
        return this.parentArc.getRrdAllocator();
    }

    static {
        $assertionsDisabled = !Robin.class.desiredAssertionStatus();
    }
}

