/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.jrrd;

import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.jrobin.core.jrrd.CDPStatusBlock;
import org.jrobin.core.jrrd.ConsolidationFunctionType;
import org.jrobin.core.jrrd.DataChunk;
import org.jrobin.core.jrrd.RRDFile;
import org.jrobin.core.jrrd.RRDatabase;

public class Archive {
    RRDatabase db;
    long offset;
    long dataOffset;
    long size;
    ConsolidationFunctionType type;
    int rowCount;
    int pdpCount;
    double xff;
    ArrayList cdpStatusBlocks;
    int currentRow;
    private double[][] values;

    Archive(RRDatabase db) throws IOException {
        this.db = db;
        RRDFile file = db.rrdFile;
        this.offset = file.getFilePointer();
        this.type = ConsolidationFunctionType.get(file.readString(20));
        this.rowCount = file.readInt();
        this.pdpCount = file.readInt();
        file.align();
        this.xff = file.readDouble();
        file.align();
        file.skipBytes(72);
        this.size = file.getFilePointer() - this.offset;
    }

    public ConsolidationFunctionType getType() {
        return this.type;
    }

    void loadCDPStatusBlocks(RRDFile file, int numBlocks) throws IOException {
        this.cdpStatusBlocks = new ArrayList();
        for (int i = 0; i < numBlocks; ++i) {
            this.cdpStatusBlocks.add(new CDPStatusBlock(file));
        }
    }

    public CDPStatusBlock getCDPStatusBlock(int index) {
        return (CDPStatusBlock)this.cdpStatusBlocks.get(index);
    }

    public Iterator getCDPStatusBlocks() {
        return this.cdpStatusBlocks.iterator();
    }

    void loadCurrentRow(RRDFile file) throws IOException {
        this.currentRow = file.readInt();
    }

    void loadData(RRDFile file, int dsCount) throws IOException {
        this.dataOffset = file.getFilePointer();
        file.skipBytes(8 * this.rowCount * dsCount);
    }

    DataChunk loadData(DataChunk chunk) throws IOException {
        Calendar end = Calendar.getInstance();
        Calendar start = (Calendar)end.clone();
        start.add(5, -1);
        this.loadData(chunk, start.getTime().getTime() / 1000L, end.getTime().getTime() / 1000L);
        return chunk;
    }

    void loadData(DataChunk chunk, long startTime, long endTime) throws IOException {
        long pointer = chunk.start < 0 ? (long)(this.currentRow + 1) : (long)(this.currentRow + chunk.start + 1);
        this.db.rrdFile.ras.seek(this.dataOffset + pointer * 8L);
        double[][] data = chunk.data;
        int row = 0;
        int i = chunk.start;
        while (i < this.rowCount - chunk.end) {
            int ii;
            if (i < 0) {
                for (ii = 0; ii < chunk.dsCount; ++ii) {
                    data[row][ii] = Double.NaN;
                }
            } else if (i >= this.rowCount) {
                for (ii = 0; ii < chunk.dsCount; ++ii) {
                    data[row][ii] = Double.NaN;
                }
            } else {
                if (pointer >= (long)this.rowCount) {
                    this.db.rrdFile.ras.seek(this.dataOffset + (pointer -= (long)this.rowCount) * 8L);
                }
                for (ii = 0; ii < chunk.dsCount; ++ii) {
                    data[row][ii] = this.db.rrdFile.readDouble();
                }
                ++pointer;
            }
            ++i;
            ++row;
        }
    }

    void printInfo(PrintStream s, NumberFormat numberFormat, int index) {
        StringBuffer sb = new StringBuffer("rra[");
        sb.append(index);
        s.print(sb);
        s.print("].cf = \"");
        s.print(this.type);
        s.println("\"");
        s.print(sb);
        s.print("].rows = ");
        s.println(this.rowCount);
        s.print(sb);
        s.print("].pdp_per_row = ");
        s.println(this.pdpCount);
        s.print(sb);
        s.print("].xff = ");
        s.println(this.xff);
        sb.append("].cdp_prep[");
        int cdpIndex = 0;
        Iterator i = this.cdpStatusBlocks.iterator();
        while (i.hasNext()) {
            CDPStatusBlock cdp = (CDPStatusBlock)i.next();
            s.print(sb);
            s.print(cdpIndex);
            s.print("].value = ");
            double value = cdp.value;
            s.println(Double.isNaN(value) ? "NaN" : numberFormat.format(value));
            s.print(sb);
            s.print(cdpIndex++);
            s.print("].unknown_datapoints = ");
            s.println(cdp.unknownDatapoints);
        }
    }

    void toXml(PrintStream s) {
        try {
            s.println("\t<rra>");
            s.print("\t\t<cf> ");
            s.print(this.type);
            s.println(" </cf>");
            s.print("\t\t<pdp_per_row> ");
            s.print(this.pdpCount);
            s.print(" </pdp_per_row> <!-- ");
            s.print(this.db.header.pdpStep * this.pdpCount);
            s.println(" seconds -->");
            s.print("\t\t<xff> ");
            s.print(this.xff);
            s.println(" </xff>");
            s.println();
            s.println("\t\t<cdp_prep>");
            for (int i = 0; i < this.cdpStatusBlocks.size(); ++i) {
                ((CDPStatusBlock)this.cdpStatusBlocks.get(i)).toXml(s);
            }
            s.println("\t\t</cdp_prep>");
            s.println("\t\t<database>");
            long timer = -(this.rowCount - 1);
            int counter = 0;
            int row = this.currentRow;
            this.db.rrdFile.ras.seek(this.dataOffset + (long)((row + 1) * 16));
            long lastUpdate = this.db.lastUpdate.getTime() / 1000L;
            int pdpStep = this.db.header.pdpStep;
            DecimalFormat numberFormat = new DecimalFormat("0.0000000000E0");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
            while (counter++ < this.rowCount) {
                if (++row == this.rowCount) {
                    row = 0;
                    this.db.rrdFile.ras.seek(this.dataOffset);
                }
                long now = lastUpdate - lastUpdate % (long)(this.pdpCount * pdpStep) + timer * (long)this.pdpCount * (long)pdpStep;
                ++timer;
                s.print("\t\t\t<!-- ");
                s.print(dateFormat.format(new Date(now * 1000L)));
                s.print(" / ");
                s.print(now);
                s.print(" --> ");
                for (int col = 0; col < this.db.header.dsCount; ++col) {
                    s.print("<v> ");
                    double value = this.db.rrdFile.readDouble();
                    if (Double.isNaN(value)) {
                        s.print("NaN");
                    } else {
                        s.print(numberFormat.format(value));
                    }
                    s.print(" </v>");
                }
                s.println("</row>");
            }
            s.println("\t\t</database>");
            s.println("\t</rra>");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public double[][] getValues() throws IOException {
        if (this.values != null) {
            return this.values;
        }
        this.values = new double[this.db.header.dsCount][this.rowCount];
        int row = this.currentRow;
        this.db.rrdFile.ras.seek(this.dataOffset + (long)((row + 1) * 16));
        for (int counter = 0; counter < this.rowCount; ++counter) {
            if (++row == this.rowCount) {
                row = 0;
                this.db.rrdFile.ras.seek(this.dataOffset);
            }
            for (int col = 0; col < this.db.header.dsCount; ++col) {
                double value;
                this.values[col][counter] = value = this.db.rrdFile.readDouble();
            }
        }
        return this.values;
    }

    public int getPdpCount() {
        return this.pdpCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public double getXff() {
        return this.xff;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[Archive: OFFSET=0x");
        sb.append(Long.toHexString(this.offset));
        sb.append(", SIZE=0x");
        sb.append(Long.toHexString(this.size));
        sb.append(", type=");
        sb.append(this.type);
        sb.append(", rowCount=");
        sb.append(this.rowCount);
        sb.append(", pdpCount=");
        sb.append(this.pdpCount);
        sb.append(", xff=");
        sb.append(this.xff);
        sb.append(", currentRow=");
        sb.append(this.currentRow);
        sb.append("]");
        Iterator i = this.cdpStatusBlocks.iterator();
        while (i.hasNext()) {
            CDPStatusBlock cdp = (CDPStatusBlock)i.next();
            sb.append("\n\t\t");
            sb.append(cdp.toString());
        }
        return sb.toString();
    }
}

