/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jrobin.core.RrdBackendFactory;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdFileBackend;
import org.jrobin.core.RrdFileBackendFactory;

public class RrdDbPool
implements Runnable {
    private static RrdDbPool ourInstance;
    private static final boolean DEBUG = false;
    public static final int INITIAL_CAPACITY = 100;
    private int capacity = 100;
    private Map rrdMap = new HashMap();
    private List rrdGcList = new LinkedList();
    private RrdBackendFactory factory;
    private int poolHitsCount;
    private int poolRequestsCount;
    static /* synthetic */ Class class$org$jrobin$core$RrdDbPool;

    public static synchronized RrdDbPool getInstance() {
        if (ourInstance == null) {
            ourInstance = new RrdDbPool();
            ourInstance.startGarbageCollector();
        }
        return ourInstance;
    }

    private RrdDbPool() {
    }

    private void startGarbageCollector() {
        Thread gcThread = new Thread(this);
        gcThread.setDaemon(true);
        gcThread.start();
    }

    public synchronized RrdDb requestRrdDb(String path) throws IOException, RrdException {
        RrdDb rrdDbRequested;
        String keypath = RrdDbPool.getCanonicalPath(path);
        if (this.rrdMap.containsKey(keypath)) {
            RrdEntry rrdEntry = (RrdEntry)this.rrdMap.get(keypath);
            this.reportUsage(rrdEntry);
            RrdDbPool.debug("EXISTING: " + rrdEntry.dump());
            rrdDbRequested = rrdEntry.getRrdDb();
            ++this.poolHitsCount;
        } else {
            RrdDb rrdDb = new RrdDb(path, this.getFactory());
            this.addRrdEntry(keypath, rrdDb);
            rrdDbRequested = rrdDb;
        }
        ++this.poolRequestsCount;
        return rrdDbRequested;
    }

    public synchronized RrdDb requestRrdDb(String path, String xmlPath) throws IOException, RrdException {
        String keypath = RrdDbPool.getCanonicalPath(path);
        this.prooveInactive(keypath);
        RrdDb rrdDb = new RrdDb(path, xmlPath, this.getFactory());
        this.addRrdEntry(keypath, rrdDb);
        ++this.poolRequestsCount;
        return rrdDb;
    }

    public synchronized RrdDb requestRrdDb(RrdDef rrdDef) throws IOException, RrdException {
        String path = rrdDef.getPath();
        String keypath = RrdDbPool.getCanonicalPath(path);
        this.prooveInactive(keypath);
        RrdDb rrdDb = new RrdDb(rrdDef, this.getFactory());
        this.addRrdEntry(keypath, rrdDb);
        ++this.poolRequestsCount;
        return rrdDb;
    }

    private void reportUsage(RrdEntry rrdEntry) {
        if (rrdEntry.reportUsage() == 1) {
            this.rrdGcList.remove(rrdEntry);
        }
    }

    private void reportRelease(RrdEntry rrdEntry) {
        if (rrdEntry.reportRelease() == 0) {
            this.rrdGcList.add(rrdEntry);
        }
    }

    private void addRrdEntry(String keypath, RrdDb rrdDb) throws IOException {
        RrdEntry newEntry = new RrdEntry(rrdDb);
        this.reportUsage(newEntry);
        RrdDbPool.debug("NEW: " + newEntry.dump());
        this.rrdMap.put(keypath, newEntry);
        this.notify();
    }

    private void prooveInactive(String keypath) throws RrdException, IOException {
        if (this.rrdMap.containsKey(keypath)) {
            RrdEntry rrdEntry = (RrdEntry)this.rrdMap.get(keypath);
            if (rrdEntry.isInUse()) {
                throw new RrdException("VALIDATOR: Cannot create new RrdDb file. File " + keypath + " already active in pool");
            }
            RrdDbPool.debug("WILL BE RECREATED: " + rrdEntry.dump());
            this.removeRrdEntry(rrdEntry);
        }
    }

    private void removeRrdEntry(RrdEntry rrdEntry) throws IOException {
        rrdEntry.closeRrdDb();
        this.rrdMap.values().remove(rrdEntry);
        this.rrdGcList.remove(rrdEntry);
        RrdDbPool.debug("REMOVED: " + rrdEntry.dump());
    }

    public synchronized void release(RrdDb rrdDb) throws IOException, RrdException {
        if (rrdDb == null) {
            return;
        }
        if (rrdDb.isClosed()) {
            throw new RrdException("Cannot release: already closed");
        }
        String keypath = rrdDb.getCanonicalPath();
        if (!this.rrdMap.containsKey(keypath)) {
            throw new RrdException("RRD file " + keypath + " not in the pool");
        }
        RrdEntry rrdEntry = (RrdEntry)this.rrdMap.get(keypath);
        this.reportRelease(rrdEntry);
        RrdDbPool.debug("RELEASED: " + rrdEntry.dump());
        this.notify();
    }

    public void run() {
        RrdDbPool.debug("GC: started");
        RrdDbPool rrdDbPool = this;
        synchronized (rrdDbPool) {
            while (true) {
                if (this.rrdMap.size() > this.capacity && this.rrdGcList.size() > 0) {
                    try {
                        RrdEntry oldestRrdEntry = (RrdEntry)this.rrdGcList.get(0);
                        RrdDbPool.debug("GC: closing " + oldestRrdEntry.dump());
                        this.removeRrdEntry(oldestRrdEntry);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                try {
                    RrdDbPool.debug("GC: waiting: " + this.rrdMap.size() + " open, " + this.rrdGcList.size() + " released, " + "capacity = " + this.capacity + ", " + "hits = " + this.poolHitsCount + ", " + "requests = " + this.poolRequestsCount);
                    this.wait();
                    RrdDbPool.debug("GC: running");
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected void finalize() throws IOException {
        this.reset();
    }

    public synchronized void reset() throws IOException {
        Iterator it = this.rrdMap.values().iterator();
        while (it.hasNext()) {
            RrdEntry rrdEntry = (RrdEntry)it.next();
            rrdEntry.closeRrdDb();
        }
        this.rrdMap.clear();
        this.rrdGcList.clear();
        RrdDbPool.debug("Nothing left in the pool");
    }

    private static String getCanonicalPath(String path) throws IOException {
        return RrdFileBackend.getCanonicalPath(path);
    }

    private static void debug(String msg) {
    }

    public synchronized String dump() throws IOException {
        StringBuffer buff = new StringBuffer();
        Iterator it = this.rrdMap.values().iterator();
        while (it.hasNext()) {
            RrdEntry rrdEntry = (RrdEntry)it.next();
            buff.append(rrdEntry.dump());
            buff.append("\n");
        }
        return buff.toString();
    }

    public synchronized int getCapacity() {
        return this.capacity;
    }

    public synchronized void setCapacity(int capacity) {
        this.capacity = capacity;
        RrdDbPool.debug("Capacity set to: " + capacity);
    }

    private RrdBackendFactory getFactory() throws RrdException {
        if (this.factory == null) {
            this.factory = RrdBackendFactory.getDefaultFactory();
            if (!(this.factory instanceof RrdFileBackendFactory)) {
                this.factory = null;
                throw new RrdException("RrdDbPool cannot work with factories not derived from RrdFileBackendFactory");
            }
        }
        return this.factory;
    }

    public synchronized double getPoolEfficency() {
        if (this.poolRequestsCount == 0) {
            return 1.0;
        }
        double ratio = (double)this.poolHitsCount / (double)this.poolRequestsCount;
        return (double)Math.round(ratio * 1000.0) / 1000.0;
    }

    public synchronized int getPoolHitsCount() {
        return this.poolHitsCount;
    }

    public synchronized int getPoolRequestsCount() {
        return this.poolRequestsCount;
    }

    private class RrdEntry {
        private RrdDb rrdDb;
        private int usageCount;
        static final /* synthetic */ boolean $assertionsDisabled;

        public RrdEntry(RrdDb rrdDb) {
            this.rrdDb = rrdDb;
        }

        RrdDb getRrdDb() {
            return this.rrdDb;
        }

        int reportUsage() {
            if (!$assertionsDisabled && this.usageCount < 0) {
                throw new AssertionError((Object)("Unexpected reportUsage count: " + this.usageCount));
            }
            return ++this.usageCount;
        }

        int reportRelease() {
            if (!$assertionsDisabled && this.usageCount <= 0) {
                throw new AssertionError((Object)("Unexpected reportRelease count: " + this.usageCount));
            }
            return --this.usageCount;
        }

        boolean isInUse() {
            return this.usageCount > 0;
        }

        void closeRrdDb() throws IOException {
            this.rrdDb.close();
        }

        String dump() throws IOException {
            String keypath = this.rrdDb.getCanonicalPath();
            return keypath + " [" + this.usageCount + "]";
        }

        static {
            $assertionsDisabled = !(class$org$jrobin$core$RrdDbPool == null ? (class$org$jrobin$core$RrdDbPool = RrdDbPool.class$("org.jrobin.core.RrdDbPool")) : class$org$jrobin$core$RrdDbPool).desiredAssertionStatus();
        }
    }
}

