/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import java.io.IOException;
import java.util.EventObject;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.TransactionState;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class NistSipMessageHandlerImpl
implements ServerRequestInterface,
ServerResponseInterface {
    protected SIPTransaction transactionChannel;
    protected ListeningPointImpl listeningPoint;
    protected SipStackImpl sipStackImpl;
    private SIPRequest pendingRequest;
    private MessageChannel pendingMessageChannel;

    public void processPending() {
        this.processRequest(this.pendingRequest, this.pendingMessageChannel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequest(SIPRequest sipRequest, MessageChannel incomingMessageChannel) {
        RequestEvent sipEvent;
        SIPDialog dialog;
        String dialogId;
        SIPTransaction transaction;
        SipProviderImpl sipProvider;
        SipStackImpl sipStackImpl;
        SIPTransactionStack sipStack;
        block50: {
            SIPResponse sipResponse;
            block54: {
                block55: {
                    block52: {
                        block53: {
                            if (LogWriter.needsLogging) {
                                this.sipStackImpl.logMessage("PROCESSING INCOMING REQUEST " + sipRequest.getFirstLine());
                            }
                            if (this.listeningPoint == null) {
                                if (!LogWriter.needsLogging) return;
                                this.sipStackImpl.logMessage("Dropping message: No listening point registered!");
                                return;
                            }
                            sipStack = (SIPTransactionStack)this.transactionChannel.getSIPStack();
                            sipStackImpl = (SipStackImpl)sipStack;
                            sipProvider = this.listeningPoint.getProvider();
                            if (sipProvider == null) {
                                if (!LogWriter.needsLogging) return;
                                sipStackImpl.logMessage("No provider - dropping !!");
                                return;
                            }
                            SipListener sipListener = sipProvider.sipListener;
                            if (sipRequest.getHeader("Route") != null && sipStackImpl.stripRouteHeader) {
                                RouteList routes = sipRequest.getRouteHeaders();
                                Route route = (Route)routes.getFirst();
                                SipUri uri = (SipUri)route.getAddress().getURI();
                                int port = uri.getHostPort().hasPort() ? uri.getHostPort().getPort() : 5060;
                                String host = uri.getHost();
                                if (host.equals(this.listeningPoint.getHost()) && port == this.listeningPoint.getPort()) {
                                    if (routes.size() == 1) {
                                        sipRequest.removeHeader("Route");
                                    } else {
                                        routes.removeFirst();
                                    }
                                }
                            }
                            transaction = this.transactionChannel;
                            if (!sipRequest.getMethod().equalsIgnoreCase("ACK")) break block52;
                            dialogId = sipRequest.getDialogId(true);
                            dialog = sipStackImpl.getDialog(dialogId);
                            if (LogWriter.needsLogging) {
                                sipStackImpl.logMessage("Processing ACK for dialog " + dialog);
                            }
                            if (dialog != null) break block53;
                            if (LogWriter.needsLogging) {
                                sipStackImpl.logMessage("Dialog does not exist " + sipRequest.getFirstLine() + " isServerTransaction = " + true);
                            }
                            transaction = sipStackImpl.findTransaction(sipRequest, true);
                            break block50;
                        }
                        if (dialog.isAckSeen() && dialog.getRemoteSequenceNumber() == sipRequest.getCSeq().getSequenceNumber()) {
                            if (sipStackImpl.isRetransmissionFilterActive()) {
                                if (!LogWriter.needsLogging) return;
                                sipStackImpl.logMessage("Retransmission Filter enabled - dropping Ack retransmission");
                                return;
                            }
                            if (LogWriter.needsLogging) {
                                sipStackImpl.logMessage("ACK retransmission for 2XX response Sending ACK to the TU");
                            }
                            transaction.setDialog(dialog);
                            break block50;
                        } else {
                            SIPServerTransaction tr = dialog.getInviteTransaction();
                            SIPResponse sIPResponse = sipResponse = tr != null ? tr.getLastResponse() : null;
                            if (tr != null && sipResponse != null && sipResponse.getStatusCode() / 100 == 2 && sipResponse.getCSeq().getMethod().equals("INVITE") && sipResponse.getCSeq().getSequenceNumber() == sipRequest.getCSeq().getSequenceNumber()) {
                                transaction.setDialog(dialog);
                                dialog.ackReceived(sipRequest);
                                sipStackImpl.logMessage("ACK for 2XX response --- sending to TU ");
                                break block50;
                            } else {
                                if (!LogWriter.needsLogging) return;
                                sipStackImpl.logMessage(" INVITE transaction not found  -- Discarding ACK");
                                return;
                            }
                        }
                    }
                    if (!sipRequest.getMethod().equals("BYE")) break block54;
                    transaction = this.transactionChannel;
                    if (transaction == null || !((SIPServerTransaction)transaction).isTransactionMapped()) break block55;
                    dialogId = sipRequest.getDialogId(true);
                    if (LogWriter.needsLogging) {
                        sipStackImpl.logMessage("dialogId = " + dialogId);
                    }
                    if ((dialog = sipStackImpl.getDialog(dialogId)) != null) {
                        if (!dialog.isRequestConsumable(sipRequest)) {
                            sipStack.removeTransaction(transaction);
                            if (!LogWriter.needsLogging) return;
                            sipStackImpl.logMessage("Dropping bye  for " + dialogId);
                            return;
                        }
                        dialog.addTransaction(transaction);
                    }
                    break block50;
                }
                if (transaction != null) {
                    dialogId = sipRequest.getDialogId(true);
                    dialog = sipStack.getDialog(dialogId);
                    if (dialog != null) {
                        if (!LogWriter.needsLogging) return;
                        sipStackImpl.logMessage("Dropping out of sequence BYE");
                        return;
                    }
                    if (sipStackImpl.dialogSupport) {
                        transaction = null;
                    }
                }
                break block50;
            }
            if (sipRequest.getRequestLine().getMethod().equals("CANCEL")) {
                SIPServerTransaction serverTransaction = (SIPServerTransaction)sipStack.findCancelTransaction(sipRequest, true);
                if (serverTransaction == null) {
                    if (LogWriter.needsLogging) {
                        sipStackImpl.logMessage("transaction  does not exist " + sipRequest.getFirstLine() + "isServerTransaction = " + true);
                    }
                    transaction = null;
                } else {
                    transaction = serverTransaction;
                }
            } else if (sipRequest.getMethod().equals("INVITE")) {
                SIPTransaction lastTransaction;
                dialogId = sipRequest.getDialogId(true);
                dialog = sipStack.getDialog(dialogId);
                SIPTransaction sIPTransaction = lastTransaction = dialog == null ? null : dialog.getInviteTransaction();
                if (dialog != null && transaction != null && lastTransaction != null && sipRequest.getCSeq().getSequenceNumber() > dialog.getRemoteSequenceNumber() && lastTransaction instanceof SIPServerTransaction && lastTransaction.isInviteTransaction() && lastTransaction.getState() != TransactionState.COMPLETED && lastTransaction.getState() != TransactionState.TERMINATED && lastTransaction.getState() != TransactionState.CONFIRMED) {
                    if (LogWriter.needsLogging) {
                        sipStackImpl.logMessage("Sending 500 response for out of sequence message");
                    }
                    sipResponse = sipRequest.createResponse(500);
                    RetryAfter retryAfter = new RetryAfter();
                    try {
                        retryAfter.setRetryAfter((int)(10.0 * Math.random()));
                    }
                    catch (InvalidArgumentException ex) {
                        ex.printStackTrace();
                    }
                    sipResponse.addHeader(retryAfter);
                    try {
                        transaction.sendMessage(sipResponse);
                        return;
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    return;
                }
                SIPTransaction sIPTransaction2 = lastTransaction = dialog == null ? null : dialog.getLastTransaction();
                if (dialog != null && lastTransaction != null && lastTransaction.isInviteTransaction() && lastTransaction instanceof SIPClientTransaction && lastTransaction.getState() != TransactionState.COMPLETED && lastTransaction.getState() != TransactionState.TERMINATED) {
                    if (dialog.getRemoteSequenceNumber() + 1 != sipRequest.getCSeq().getSequenceNumber()) {
                        if (!LogWriter.needsLogging) return;
                        sipStackImpl.logMessage("Dropping message -- sequence number is too high!");
                        return;
                    }
                    dialog.setRemoteSequenceNumber(sipRequest.getCSeq().getSequenceNumber());
                    if (LogWriter.needsLogging) {
                        sipStackImpl.logMessage("Sending 491 response for out of sequence message");
                    }
                    sipResponse = sipRequest.createResponse(491);
                    try {
                        transaction.sendMessage(sipResponse);
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    dialog.requestConsumed();
                    return;
                }
            }
        }
        if (LogWriter.needsLogging) {
            sipStackImpl.logMessage("-----------------");
            sipStackImpl.logMessage(sipRequest.encodeMessage());
        }
        if (!((dialog = sipStackImpl.getDialog(dialogId = sipRequest.getDialogId(true))) == null || transaction == null || sipRequest.getMethod().equals("BYE") || sipRequest.getMethod().equals("CANCEL") || sipRequest.getMethod().equals("ACK"))) {
            if (dialog.getRemoteSequenceNumber() >= sipRequest.getCSeq().getSequenceNumber()) {
                if (LogWriter.needsLogging) {
                    sipStackImpl.logMessage("Dropping out of sequence message " + dialog.getRemoteSequenceNumber() + " " + sipRequest.getCSeq());
                }
                if (dialog.getRemoteSequenceNumber() <= sipRequest.getCSeq().getSequenceNumber()) return;
                if (LogWriter.needsLogging) {
                    sipStackImpl.logMessage("Sending 500 response for out of sequence message");
                }
                SIPResponse sipResponse = sipRequest.createResponse(500);
                try {
                    transaction.sendMessage(sipResponse);
                    return;
                }
                catch (IOException ex) {
                    // empty catch block
                }
                return;
            }
            if (!dialog.isRequestConsumable(sipRequest)) {
                return;
            }
            dialog.addTransaction(transaction);
            dialog.addRoute(sipRequest);
        }
        if (dialog == null && sipRequest.getMethod().equals("NOTIFY")) {
            SIPClientTransaction ct = sipStack.findSubscribeTransaction(sipRequest);
            if (ct != null) {
                transaction.setDialog((SIPDialog)ct.getDialog());
                sipEvent = ct.getDialog().getState() == null ? new RequestEvent((Object)sipProvider, null, (Request)sipRequest) : new RequestEvent((Object)sipProvider, (ServerTransaction)transaction, (Request)sipRequest);
            } else {
                sipEvent = new RequestEvent((Object)sipProvider, null, (Request)sipRequest);
            }
        } else {
            sipEvent = transaction != null && ((SIPServerTransaction)transaction).isTransactionMapped() ? new RequestEvent((Object)sipProvider, (ServerTransaction)transaction, (Request)sipRequest) : new RequestEvent((Object)sipProvider, null, (Request)sipRequest);
        }
        sipProvider.handleEvent((EventObject)sipEvent, transaction);
    }

    public void processResponse(SIPResponse sipResponse, MessageChannel incomingMessageChannel) {
        if (LogWriter.needsLogging) {
            this.sipStackImpl.logMessage("PROCESSING INCOMING RESPONSE" + sipResponse.encodeMessage());
        }
        if (this.listeningPoint == null) {
            if (LogWriter.needsLogging) {
                this.sipStackImpl.logMessage("Dropping message: No listening point registered!");
            }
            return;
        }
        SIPTransaction transaction = this.transactionChannel;
        SipProviderImpl sipProvider = this.listeningPoint.getProvider();
        if (sipProvider == null) {
            if (LogWriter.needsLogging) {
                this.sipStackImpl.logMessage("Dropping message:  no provider");
            }
            return;
        }
        SipStackImpl sipStackImpl = sipProvider.sipStack;
        if (LogWriter.needsLogging) {
            sipStackImpl.logMessage("Transaction = " + transaction);
        }
        if (this.transactionChannel == null) {
            String dialogId = sipResponse.getDialogId(false);
            SIPDialog dialog = sipStackImpl.getDialog(dialogId);
            if (sipProvider.sipListener == null) {
                return;
            }
            if (dialog != null) {
                if (sipResponse.getStatusCode() != 200) {
                    return;
                }
                if (sipStackImpl.isRetransmissionFilterActive() && sipResponse.getCSeq().getSequenceNumber() == ((SIPTransaction)dialog.getFirstTransaction()).getCSeq() && sipResponse.getCSeq().getMethod().equals(((SIPTransaction)dialog.getFirstTransaction()).getMethod())) {
                    try {
                        dialog.resendAck();
                        return;
                    }
                    catch (SipException ex) {
                        // empty catch block
                    }
                }
            }
            ResponseEvent sipEvent = new ResponseEvent((Object)sipProvider, null, (Response)sipResponse);
            sipProvider.handleEvent((EventObject)sipEvent, transaction);
            return;
        }
        SipListener sipListener = sipProvider.sipListener;
        ResponseEvent responseEvent = new ResponseEvent((Object)sipProvider, (ClientTransaction)transaction, (Response)sipResponse);
        sipProvider.handleEvent((EventObject)responseEvent, transaction);
    }

    public String getProcessingInfo() {
        return null;
    }
}

