/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.client;

import com.hazelcast.client.impl.client.KeyBasedClientRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.concurrent.lock.InternalLockNamespace;
import com.hazelcast.concurrent.lock.client.LockPortableHook;
import com.hazelcast.concurrent.lock.operations.SignalOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.LockPermission;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class SignalRequest
extends KeyBasedClientRequest
implements Portable,
SecureRequest {
    private ObjectNamespace namespace;
    private String name;
    private long threadId;
    private String conditionId;
    private boolean all;

    public SignalRequest() {
    }

    public SignalRequest(ObjectNamespace namespace, String name, long threadId, String conditionId, boolean all) {
        this.namespace = namespace;
        this.name = name;
        this.threadId = threadId;
        this.conditionId = conditionId;
        this.all = all;
    }

    @Override
    protected Object getKey() {
        return this.name;
    }

    @Override
    protected Operation prepareOperation() {
        Object key = this.serializationService.toData(this.name);
        return new SignalOperation(this.namespace, (Data)key, this.threadId, this.conditionId, this.all);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:lockService";
    }

    @Override
    public int getFactoryId() {
        return LockPortableHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("name", this.name);
        writer.writeUTF("cid", this.conditionId);
        writer.writeLong("tid", this.threadId);
        writer.writeBoolean("all", this.all);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.namespace.writeData(out);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("name");
        this.conditionId = reader.readUTF("cid");
        this.threadId = reader.readLong("tid");
        this.all = reader.readBoolean("all");
        ObjectDataInput in = reader.getRawDataInput();
        this.namespace = new InternalLockNamespace();
        this.namespace.readData(in);
    }

    @Override
    public Permission getRequiredPermission() {
        return new LockPermission(this.namespace.getObjectName(), "lock");
    }
}

