/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chapter;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.text.RtfSection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfChapter
extends RtfSection {
    public RtfChapter(RtfDocument doc, Chapter chapter) {
        super(doc, chapter);
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (this.document.getLastElementWritten() != null && !(this.document.getLastElementWritten() instanceof RtfChapter)) {
                result.write("\\page".getBytes());
            }
            result.write("\\sectd".getBytes());
            result.write(this.document.getDocumentHeader().writeSectionDefinition());
            if (this.title != null) {
                result.write(this.title.write());
            }
            int i = 0;
            while (i < this.items.size()) {
                result.write(((RtfBasicElement)this.items.get(i)).write());
                ++i;
            }
            result.write("\\sect".getBytes());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

