/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import net.sf.jqql.net.AbstractPort;
import net.sf.jqql.net.IConnectionPolicy;
import net.sf.jqql.net.INIOHandler;
import net.sf.jqql.net.IProxyHandler;
import net.sf.jqql.net.PortGate;
import net.sf.jqql.net.Socks5Proxy;
import net.sf.jqql.packets.ErrorPacket;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08InPacket;
import net.sf.jqql.packets._08OutPacket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPSocks5Port
extends AbstractPort
implements IProxyHandler {
    private static final Log log = LogFactory.getLog(UDPSocks5Port.class);
    private DatagramChannel channel;
    private Socks5Proxy proxy;
    private boolean ready = false;

    public UDPSocks5Port(IConnectionPolicy iConnectionPolicy, InetSocketAddress inetSocketAddress) throws IOException {
        super(iConnectionPolicy);
        this.remoteAddress = inetSocketAddress;
        this.channel = DatagramChannel.open();
        this.channel.configureBlocking(false);
        this.channel.socket().bind(new InetSocketAddress(0));
        this.proxy = new Socks5Proxy(this, iConnectionPolicy.getProxyUsername(), iConnectionPolicy.getProxyPassword(), this.channel);
        this.proxy.setProxyAddress(iConnectionPolicy.getProxy());
        this.proxy.setRemoteAddress(inetSocketAddress);
        this.proxy.setClientPort(this.channel.socket().getLocalPort());
    }

    public void dispose() {
        this.proxy.dispose();
    }

    public void start() {
        this.proxy.start();
    }

    public SelectableChannel channel() {
        return this.channel;
    }

    public void receive() throws IOException, PacketParseException {
        this.receiveBuf.clear();
        int n = this.channel.read(this.receiveBuf);
        while (n > 0) {
            this.receiveBuf.flip();
            this.skipProxyHeader();
            _08InPacket _08InPacket2 = this.policy.parseIn(this.receiveBuf, false);
            if (_08InPacket2 == null) {
                this.receiveBuf.clear();
            } else {
                this.policy.pushIn(_08InPacket2);
                this.receiveBuf.clear();
            }
            n = this.channel.read(this.receiveBuf);
        }
    }

    protected void skipProxyHeader() {
        int n = this.receiveBuf.position();
        byte by = this.receiveBuf.get(3);
        if (by == 3) {
            this.receiveBuf.position(n + 6 + this.receiveBuf.get(4));
        } else if (by == 1) {
            this.receiveBuf.position(n + 10);
        } else if (by == 4) {
            this.receiveBuf.position(n + 22);
        } else {
            log.error((Object)"\u4ee3\u7406\u5934\u90e8\u5305\u542b\u4e0d\u652f\u6301\u7684\u5730\u5740\u7c7b\u578b");
        }
    }

    protected void fillProxyHeader() {
        this.sendBuf.putChar('\u0000').put((byte)0).put(this.proxy.isIp ? (byte)1 : 3).put(this.proxy.remoteAddress).putChar((char)this.proxy.remotePort);
    }

    public void send() throws IOException {
        while (!this.isEmpty()) {
            this.sendBuf.clear();
            this.fillProxyHeader();
            _08OutPacket _08OutPacket2 = this.remove();
            _08OutPacket2.fill(this.sendBuf);
            this.sendBuf.flip();
            if (_08OutPacket2.needAck()) {
                this.channel.write(this.sendBuf);
                _08OutPacket2.setTimeout(System.currentTimeMillis() + 5000L);
                this.policy.pushResend(_08OutPacket2, this.getId());
                log.debug((Object)("Sent - " + _08OutPacket2.toString()));
                continue;
            }
            int n = _08OutPacket2.getSendCount();
            for (int i = 0; i < n; ++i) {
                this.sendBuf.rewind();
                this.channel.write(this.sendBuf);
                log.debug((Object)("Sent - " + _08OutPacket2.toString()));
            }
        }
    }

    public void send(_08OutPacket _08OutPacket2) {
        try {
            this.sendBuf.clear();
            this.fillProxyHeader();
            _08OutPacket2.fill(this.sendBuf);
            this.sendBuf.flip();
            if (_08OutPacket2.needAck()) {
                this.channel.write(this.sendBuf);
                log.debug((Object)("Sent - " + _08OutPacket2.toString()));
            } else {
                int n = _08OutPacket2.getSendCount();
                for (int i = 0; i < n; ++i) {
                    this.sendBuf.rewind();
                    this.channel.write(this.sendBuf);
                    log.debug((Object)("Sent - " + _08OutPacket2.toString()));
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage());
        }
    }

    public void send(ByteBuffer byteBuffer) {
        try {
            if (this.ready) {
                this.channel.write(byteBuffer);
            }
        }
        catch (IOException iOException) {
            log.error((Object)iOException.getMessage());
        }
    }

    public INIOHandler getNIOHandler() {
        if (this.ready) {
            return this;
        }
        return this.proxy;
    }

    public boolean isConnected() {
        return true;
    }

    public void processConnect(SelectionKey selectionKey) throws IOException {
    }

    public void processRead(SelectionKey selectionKey) throws IOException, PacketParseException {
        this.receive();
    }

    public void processWrite() throws IOException {
        this.send();
    }

    public void proxyReady(InetSocketAddress inetSocketAddress) throws IOException {
        this.ready = true;
        this.channel.connect(inetSocketAddress);
        ((PortGate)this.getPool()).getPorter().register(this, 1);
    }

    public void proxyAuthFail() {
        this.proxyError("Proxy Auth Fail");
    }

    public void proxyError(String string) {
        ErrorPacket errorPacket = this.policy.createErrorPacket(2, this.getId());
        errorPacket.errorMessage = string;
        this.policy.pushIn(errorPacket);
    }
}

