/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.client.impl.client.ClientPortableHook;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.PartitionLostEvent;
import com.hazelcast.partition.PartitionLostListener;
import com.hazelcast.spi.impl.PortablePartitionLostEvent;
import java.security.Permission;

public class AddPartitionLostListenerRequest
extends CallableClientRequest
implements RetryableRequest {
    public Object call() {
        final ClientEndpoint endpoint = this.getEndpoint();
        InternalPartitionService partitionService = (InternalPartitionService)this.getService();
        PartitionLostListener listener = new PartitionLostListener(){

            @Override
            public void partitionLost(PartitionLostEvent event) {
                if (endpoint.isAlive()) {
                    PortablePartitionLostEvent portableEvent = new PortablePartitionLostEvent(event.getPartitionId(), event.getLostBackupCount(), event.getEventSource());
                    endpoint.sendEvent(null, portableEvent, AddPartitionLostListenerRequest.this.getCallId());
                }
            }
        };
        String registrationId = partitionService.addPartitionLostListener(listener);
        endpoint.setListenerRegistration("hz:core:partitionService", ".partitionLost", registrationId);
        return registrationId;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public String getMethodName() {
        return "addPartitionLostListener";
    }

    @Override
    public int getFactoryId() {
        return ClientPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }
}

