/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.eviction;

import com.hazelcast.cache.impl.eviction.EvictionConfig;
import com.hazelcast.cache.impl.eviction.EvictionStrategy;
import com.hazelcast.cache.impl.eviction.EvictionStrategyType;
import com.hazelcast.cache.impl.eviction.impl.strategy.sampling.SamplingBasedEvictionStrategy;
import java.util.HashMap;
import java.util.Map;

public final class EvictionStrategyProvider {
    private static final Map<EvictionStrategyType, EvictionStrategy> EVICTION_STRATEGY_MAP = new HashMap<EvictionStrategyType, EvictionStrategy>();

    private EvictionStrategyProvider() {
    }

    private static void init() {
        EVICTION_STRATEGY_MAP.put(EvictionStrategyType.SAMPLING_BASED_EVICTION, new SamplingBasedEvictionStrategy());
    }

    public static EvictionStrategy getEvictionStrategy(EvictionConfig evictionConfig) {
        if (evictionConfig == null) {
            return null;
        }
        EvictionStrategyType evictionStrategyType = evictionConfig.getEvictionStrategyType();
        if (evictionStrategyType == null) {
            return null;
        }
        return EVICTION_STRATEGY_MAP.get((Object)evictionStrategyType);
    }

    public static EvictionStrategy getDefaultEvictionStrategy() {
        return EVICTION_STRATEGY_MAP.get((Object)EvictionStrategyType.DEFAULT_EVICTION_STRATEGY);
    }

    static {
        EvictionStrategyProvider.init();
    }
}

