/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.impl.tx;

import com.hazelcast.config.QueueConfig;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.queue.impl.QueueItem;
import com.hazelcast.queue.impl.QueueService;
import com.hazelcast.queue.impl.operations.SizeOperation;
import com.hazelcast.queue.impl.tx.QueueTransactionLog;
import com.hazelcast.queue.impl.tx.TransactionLogKey;
import com.hazelcast.queue.impl.tx.TxnOfferOperation;
import com.hazelcast.queue.impl.tx.TxnPeekOperation;
import com.hazelcast.queue.impl.tx.TxnPollOperation;
import com.hazelcast.queue.impl.tx.TxnReserveOfferOperation;
import com.hazelcast.queue.impl.tx.TxnReservePollOperation;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionSupport;
import com.hazelcast.util.ExceptionUtil;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public abstract class TransactionalQueueProxySupport
extends AbstractDistributedObject<QueueService>
implements TransactionalObject {
    protected final String name;
    protected final TransactionSupport tx;
    protected final int partitionId;
    protected final QueueConfig config;
    private final LinkedList<QueueItem> offeredQueue = new LinkedList();
    private final Set<Long> itemIdSet = new HashSet<Long>();

    protected TransactionalQueueProxySupport(NodeEngine nodeEngine, QueueService service, String name, TransactionSupport tx) {
        super(nodeEngine, service);
        this.name = name;
        this.tx = tx;
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(this.getNameAsPartitionAwareData());
        this.config = nodeEngine.getConfig().findQueueConfig(name);
    }

    protected void checkTransactionState() {
        if (!this.tx.getState().equals((Object)Transaction.State.ACTIVE)) {
            throw new TransactionNotActiveException("Transaction is not active!");
        }
    }

    public boolean offerInternal(Data data, long timeout) {
        TxnReserveOfferOperation operation = new TxnReserveOfferOperation(this.name, timeout, this.offeredQueue.size(), this.tx.getTxnId());
        try {
            InternalCompletableFuture f = this.invoke(operation);
            Long itemId = (Long)f.get();
            if (itemId != null) {
                if (!this.itemIdSet.add(itemId)) {
                    throw new TransactionException("Duplicate itemId: " + itemId);
                }
                this.offeredQueue.offer(new QueueItem(null, itemId, data));
                TxnOfferOperation txnOfferOperation = new TxnOfferOperation(this.name, itemId, data);
                QueueTransactionLog transactionLog = new QueueTransactionLog(this.tx.getTxnId(), itemId, this.name, this.partitionId, txnOfferOperation);
                this.tx.addTransactionLog(transactionLog);
                return true;
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return false;
    }

    public Data pollInternal(long timeout) {
        QueueItem reservedOffer = this.offeredQueue.peek();
        long itemId = reservedOffer == null ? -1L : reservedOffer.getItemId();
        TxnReservePollOperation operation = new TxnReservePollOperation(this.name, timeout, itemId, this.tx.getTxnId());
        try {
            InternalCompletableFuture f = this.invoke(operation);
            QueueItem item = (QueueItem)f.get();
            if (item != null) {
                if (reservedOffer != null && item.getItemId() == reservedOffer.getItemId()) {
                    this.offeredQueue.poll();
                    this.tx.removeTransactionLog(new TransactionLogKey(reservedOffer.getItemId(), this.name));
                    this.itemIdSet.remove(reservedOffer.getItemId());
                    return reservedOffer.getData();
                }
                if (!this.itemIdSet.add(item.getItemId())) {
                    throw new TransactionException("Duplicate itemId: " + item.getItemId());
                }
                TxnPollOperation op = new TxnPollOperation(this.name, item.getItemId());
                QueueTransactionLog transactionLog = new QueueTransactionLog(this.tx.getTxnId(), item.getItemId(), this.name, this.partitionId, op);
                this.tx.addTransactionLog(transactionLog);
                return item.getData();
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return null;
    }

    public Data peekInternal(long timeout) {
        QueueItem offer = this.offeredQueue.peek();
        long itemId = offer == null ? -1L : offer.getItemId();
        TxnPeekOperation operation = new TxnPeekOperation(this.name, timeout, itemId, this.tx.getTxnId());
        try {
            InternalCompletableFuture f = this.invoke(operation);
            QueueItem item = (QueueItem)f.get();
            if (item != null) {
                if (offer != null && item.getItemId() == offer.getItemId()) {
                    return offer.getData();
                }
                return item.getData();
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return null;
    }

    public int size() {
        this.checkTransactionState();
        SizeOperation operation = new SizeOperation(this.name);
        try {
            InternalCompletableFuture f = this.invoke(operation);
            Integer size = (Integer)f.get();
            return size + this.offeredQueue.size();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private <E> InternalCompletableFuture<E> invoke(Operation operation) {
        OperationService operationService = this.getNodeEngine().getOperationService();
        return operationService.invokeOnPartition("hz:impl:queueService", operation, this.partitionId);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:queueService";
    }
}

