/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.ReplicaErrorLogger;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;

public final class CheckReplicaVersion
extends Operation
implements PartitionAwareOperation {
    private long version;
    private boolean returnResponse;
    private boolean response;

    public CheckReplicaVersion() {
    }

    public CheckReplicaVersion(long version, boolean returnResponse) {
        this.version = version;
        this.returnResponse = returnResponse;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        long[] currentVersions = partitionService.getPartitionReplicaVersions(partitionId);
        long currentVersion = currentVersions[replicaIndex - 1];
        if (currentVersion == this.version) {
            this.response = true;
        } else {
            this.logBackupVersionMismatch(currentVersion);
            partitionService.triggerPartitionReplicaSync(partitionId, replicaIndex, 0L);
            this.response = false;
        }
    }

    private void logBackupVersionMismatch(long currentVersion) {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Partition: " + this.getPartitionId() + ", Replica: " + this.getReplicaIndex() + " version is not matching to version of the owner! " + " Expected: " + this.version + ", Actual: " + currentVersion);
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return this.returnResponse;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeLong(this.version);
        out.writeBoolean(this.returnResponse);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.version = in.readLong();
        this.returnResponse = in.readBoolean();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CheckReplicaVersion");
        sb.append("{partition=").append(this.getPartitionId());
        sb.append(", replica=").append(this.getReplicaIndex());
        sb.append(", version=").append(this.version);
        sb.append('}');
        return sb.toString();
    }
}

