/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.clientstate.Channel;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.AbstractCommand;
import f00f.net.irc.martyr.util.FullNick;
import org.apache.log4j.Logger;

public class JoinCommand
extends AbstractCommand {
    static Logger log = Logger.getLogger(JoinCommand.class);
    private String channel;
    private String secret;
    private FullNick user;

    public JoinCommand() {
        this.user = null;
        this.channel = null;
        this.secret = null;
    }

    private JoinCommand(FullNick user, String channel) {
        this.user = user;
        this.channel = channel;
        this.secret = null;
    }

    public JoinCommand(String channel, String secret) {
        this.secret = secret;
        this.user = null;
        this.channel = channel;
    }

    public JoinCommand(String channel) {
        this.secret = null;
        this.user = null;
        this.channel = channel;
    }

    public InCommand parse(String prefix, String identifier, String params) {
        return new JoinCommand(new FullNick(prefix), this.getParameter(params, 0));
    }

    public String getIrcIdentifier() {
        return "JOIN";
    }

    public String renderParams() {
        if (this.secret == null) {
            return this.channel;
        }
        return this.channel + " " + this.secret;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getSecret() {
        return this.secret;
    }

    public FullNick getUser() {
        return this.user;
    }

    public boolean weJoined(ClientState state) {
        return this.user.equals(state.getNick());
    }

    public boolean updateClientState(ClientState state) {
        if (this.weJoined(state)) {
            log.debug((Object)("JOIN: We've joined " + this.channel));
            state.addChannel(this.channel);
            return true;
        }
        log.debug((Object)("JOIN: " + this.user + " joined " + this.channel));
        Channel channelObj = state.getChannel(this.channel);
        channelObj.addMember(this.user, (InCommand)this);
        return true;
    }
}

