/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message;

import gov.nist.core.GenericObject;
import gov.nist.core.GenericObjectList;
import java.lang.reflect.Field;

public abstract class MessageObject
extends GenericObject {
    protected static final String MESSAGE_PACKAGE = "gov.nist.javax.sip.message";
    protected static final String SIP_PACKAGE = "gov.nist.javax.sip";
    protected static final String PARSER_PACKAGE = "gov.nist.javax.sip.parser";
    protected static final String SIPHEADERS_PACKAGE = "gov.nist.javax.sip.header";

    public abstract String encode();

    public void dbgPrint() {
        super.dbgPrint();
    }

    public String debugDump() {
        this.stringRepresentation = "";
        Class<?> clazz = this.getClass();
        this.sprint(clazz.getName());
        this.sprint("{");
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n = field.getModifiers();
            if (n == 2) continue;
            Class<?> clazz2 = field.getType();
            String string = field.getName();
            if (string.compareTo("stringRepresentation") == 0 || string.compareTo("indentation") == 0) continue;
            this.sprint(string + ":");
            try {
                if (clazz2.isPrimitive()) {
                    String string2 = clazz2.toString();
                    this.sprint(string2 + ":");
                    if (string2.compareTo("int") == 0) {
                        int n2 = field.getInt(this);
                        this.sprint(n2);
                        continue;
                    }
                    if (string2.compareTo("short") == 0) {
                        short s = field.getShort(this);
                        this.sprint(s);
                        continue;
                    }
                    if (string2.compareTo("char") == 0) {
                        char c = field.getChar(this);
                        this.sprint(c);
                        continue;
                    }
                    if (string2.compareTo("long") == 0) {
                        long l = field.getLong(this);
                        this.sprint(l);
                        continue;
                    }
                    if (string2.compareTo("boolean") == 0) {
                        boolean bl = field.getBoolean(this);
                        this.sprint(bl);
                        continue;
                    }
                    if (string2.compareTo("double") == 0) {
                        double d = field.getDouble(this);
                        this.sprint(d);
                        continue;
                    }
                    if (string2.compareTo("float") != 0) continue;
                    float f = field.getFloat(this);
                    this.sprint(f);
                    continue;
                }
                if (MessageObject.getClassFromName("gov.nist.javax.sip.GenericObject").isAssignableFrom(clazz2)) {
                    if (field.get(this) != null) {
                        this.sprint(((GenericObject)field.get(this)).debugDump(this.indentation + 1));
                        continue;
                    }
                    this.sprint("<null>");
                    continue;
                }
                if (MessageObject.getClassFromName("gov.nist.javax.sip.GenericObjectList").isAssignableFrom(clazz2)) {
                    if (field.get(this) != null) {
                        this.sprint(((GenericObjectList)field.get(this)).debugDump(this.indentation + 1));
                        continue;
                    }
                    this.sprint("<null>");
                    continue;
                }
                if (field.get(this) != null) {
                    this.sprint(field.get(this).getClass().getName() + ":");
                } else {
                    this.sprint(clazz2.getName() + ":");
                }
                this.sprint("{");
                if (field.get(this) != null) {
                    this.sprint(field.get(this).toString());
                } else {
                    this.sprint("<null>");
                }
                this.sprint("}");
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        this.sprint("}");
        return this.stringRepresentation;
    }

    protected MessageObject() {
    }

    public String dbgPrint(int n) {
        int n2 = this.indentation;
        this.indentation = n;
        String string = this.toString();
        this.indentation = n2;
        return string;
    }
}

