/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.util.TreeMap;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.ElementFactory;

public class CanonicalUtils {
    public static String normalizeCharacters(String string, boolean bl) {
        if (string.length() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    if (!bl) {
                        stringBuffer.append("&gt;");
                        break;
                    }
                    stringBuffer.append('>');
                    break;
                }
                case '\t': {
                    if (bl) {
                        stringBuffer.append("&#x9;");
                        break;
                    }
                    stringBuffer.append('\t');
                    break;
                }
                case '\n': {
                    if (bl) {
                        stringBuffer.append("&#xA;");
                        break;
                    }
                    stringBuffer.append('\n');
                    break;
                }
                case '\r': {
                    stringBuffer.append("&#xD;");
                    break;
                }
                case '\"': {
                    if (bl) {
                        stringBuffer.append("&quot;");
                        break;
                    }
                    stringBuffer.append('\"');
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n]);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static AttributeIterator sortNamespaces(AttributeIterator attributeIterator, AttributeIterator attributeIterator2) {
        Attribute attribute;
        TreeMap<String, Attribute> treeMap = new TreeMap<String, Attribute>();
        while (attributeIterator.hasNext()) {
            attribute = attributeIterator.next();
            treeMap.put(attribute.getName().getQualifiedName(), attribute);
        }
        while (attributeIterator2.hasNext()) {
            attribute = attributeIterator2.next();
            treeMap.put(attribute.getName().getQualifiedName(), attribute);
        }
        return ElementFactory.createAttributeIterator(treeMap.values().iterator());
    }

    public static AttributeIterator sortNamespaces(AttributeIterator attributeIterator) {
        TreeMap<String, Attribute> treeMap = new TreeMap<String, Attribute>();
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            treeMap.put(attribute.getName().getQualifiedName(), attribute);
        }
        return ElementFactory.createAttributeIterator(treeMap.values().iterator());
    }

    public static AttributeIterator sortAttributes(AttributeIterator attributeIterator) {
        TreeMap<String, Attribute> treeMap = new TreeMap<String, Attribute>();
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            String string = attribute.getName().getNamespaceUri();
            if (string == null) {
                treeMap.put(attribute.getName().getQualifiedName(), attribute);
                continue;
            }
            treeMap.put(string + attribute.getName().getLocalName(), attribute);
        }
        return ElementFactory.createAttributeIterator(treeMap.values().iterator());
    }
}

