/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.Debug;
import gov.nist.core.GenericObjectList;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.Match;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class GenericObject
implements Serializable,
Cloneable {
    protected static final String SEMICOLON = ";";
    protected static final String COLON = ":";
    protected static final String COMMA = ",";
    protected static final String SLASH = "/";
    protected static final String SP = " ";
    protected static final String EQUALS = "=";
    protected static final String STAR = "*";
    protected static final String NEWLINE = "\r\n";
    protected static final String RETURN = "\n";
    protected static final String LESS_THAN = "<";
    protected static final String GREATER_THAN = ">";
    protected static final String AT = "@";
    protected static final String DOT = ".";
    protected static final String QUESTION = "?";
    protected static final String POUND = "#";
    protected static final String AND = "&";
    protected static final String LPAREN = "(";
    protected static final String RPAREN = ")";
    protected static final String DOUBLE_QUOTE = "\"";
    protected static final String QUOTE = "'";
    protected static final String HT = "\t";
    protected static final String PERCENT = "%";
    protected static final Set immutableClasses = new HashSet(10);
    protected static final String[] immutableClassNames = new String[]{"String", "Character", "Boolean", "Byte", "Short", "Integer", "Long", "Float", "Double"};
    protected int indentation = 0;
    protected String stringRepresentation = "";
    protected Match matchExpression;

    public void setMatcher(Match match) {
        if (match == null) {
            throw new IllegalArgumentException("null arg!");
        }
        this.matchExpression = match;
    }

    public Match getMatcher() {
        return this.matchExpression;
    }

    public static Class getClassFromName(String string) {
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            InternalErrorHandler.handleException(exception);
            return null;
        }
    }

    public static boolean isMySubclass(Class clazz) {
        try {
            return GenericObject.class.isAssignableFrom(clazz);
        }
        catch (Exception exception) {
            InternalErrorHandler.handleException(exception);
            return false;
        }
    }

    public static Object makeClone(Object object) {
        if (object == null) {
            throw new NullPointerException("null obj!");
        }
        Class<?> clazz = object.getClass();
        Object object2 = object;
        if (immutableClasses.contains(clazz)) {
            return object;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (!clazz2.isPrimitive()) {
                object2 = ((Object[])object).clone();
            } else {
                if (clazz2 == Character.TYPE) {
                    object2 = ((char[])object).clone();
                } else if (clazz2 == Boolean.TYPE) {
                    object2 = ((boolean[])object).clone();
                }
                if (clazz2 == Byte.TYPE) {
                    object2 = ((byte[])object).clone();
                } else if (clazz2 == Short.TYPE) {
                    object2 = ((short[])object).clone();
                } else if (clazz2 == Integer.TYPE) {
                    object2 = ((int[])object).clone();
                } else if (clazz2 == Long.TYPE) {
                    object2 = ((long[])object).clone();
                } else if (clazz2 == Float.TYPE) {
                    object2 = ((float[])object).clone();
                } else if (clazz2 == Double.TYPE) {
                    object2 = ((double[])object).clone();
                }
            }
        } else if (GenericObject.class.isAssignableFrom(clazz)) {
            object2 = ((GenericObject)object).clone();
        } else if (GenericObjectList.class.isAssignableFrom(clazz)) {
            object2 = ((GenericObjectList)object).clone();
        } else if (Cloneable.class.isAssignableFrom(clazz)) {
            try {
                Method method = clazz.getMethod("clone", null);
                object2 = method.invoke(object, (Object[])null);
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                InternalErrorHandler.handleException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return object2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error");
        }
    }

    public void merge(Object object) {
        if (!object.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Bad override object");
        }
        if (object == null) {
            return;
        }
        Class<?> clazz = this.getClass();
        do {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                int n = field.getModifiers();
                if (Modifier.isPrivate(n) || Modifier.isStatic(n) || Modifier.isInterface(n)) continue;
                Class<?> clazz2 = field.getType();
                String string = field.getName();
                String string2 = clazz2.toString();
                try {
                    if (clazz2.isPrimitive()) {
                        if (string2.compareTo("int") == 0) {
                            int n2 = field.getInt(object);
                            field.setInt(this, n2);
                            continue;
                        }
                        if (string2.compareTo("short") == 0) {
                            short s = field.getShort(object);
                            field.setShort(this, s);
                            continue;
                        }
                        if (string2.compareTo("char") == 0) {
                            char c = field.getChar(object);
                            field.setChar(this, c);
                            continue;
                        }
                        if (string2.compareTo("long") == 0) {
                            long l = field.getLong(object);
                            field.setLong(this, l);
                            continue;
                        }
                        if (string2.compareTo("boolean") == 0) {
                            boolean bl = field.getBoolean(object);
                            field.setBoolean(this, bl);
                            continue;
                        }
                        if (string2.compareTo("double") == 0) {
                            double d = field.getDouble(object);
                            field.setDouble(this, d);
                            continue;
                        }
                        if (string2.compareTo("float") != 0) continue;
                        float f = field.getFloat(object);
                        field.setFloat(this, f);
                        continue;
                    }
                    Object object2 = field.get(this);
                    Object object3 = field.get(object);
                    if (object3 == null) continue;
                    if (object2 == null) {
                        field.set(this, object3);
                        continue;
                    }
                    if (object2 instanceof GenericObject) {
                        GenericObject genericObject = (GenericObject)object2;
                        genericObject.merge(object3);
                        continue;
                    }
                    field.set(this, object3);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
        } while (!(clazz = clazz.getSuperclass()).equals(class$gov$nist$core$GenericObject == null ? GenericObject.class$("gov.nist.core.GenericObject") : class$gov$nist$core$GenericObject));
    }

    protected GenericObject() {
    }

    protected String getIndentation() {
        char[] cArray = new char[this.indentation];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    protected void sprint(String string) {
        if (string == null) {
            this.stringRepresentation = this.stringRepresentation + this.getIndentation();
            this.stringRepresentation = this.stringRepresentation + "<null>\n";
            return;
        }
        if (string.compareTo("}") == 0 || string.compareTo("]") == 0) {
            --this.indentation;
        }
        this.stringRepresentation = this.stringRepresentation + this.getIndentation();
        this.stringRepresentation = this.stringRepresentation + string;
        this.stringRepresentation = this.stringRepresentation + RETURN;
        if (string.compareTo("{") == 0 || string.compareTo("[") == 0) {
            ++this.indentation;
        }
    }

    protected void sprint(Object object) {
        this.sprint(object.toString());
    }

    protected void sprint(int n) {
        this.sprint(String.valueOf(n));
    }

    protected void sprint(short s) {
        this.sprint(String.valueOf(s));
    }

    protected void sprint(char c) {
        this.sprint(String.valueOf(c));
    }

    protected void sprint(long l) {
        this.sprint(String.valueOf(l));
    }

    protected void sprint(boolean bl) {
        this.sprint(String.valueOf(bl));
    }

    protected void sprint(double d) {
        this.sprint(String.valueOf(d));
    }

    protected void sprint(float f) {
        this.sprint(String.valueOf(f));
    }

    protected void dbgPrint() {
        Debug.println(this.debugDump());
    }

    protected void dbgPrint(String string) {
        Debug.println(string);
    }

    public boolean equals(Object object) {
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = object.getClass();
        while (true) {
            Field[] fieldArray = clazz.getDeclaredFields();
            Field[] fieldArray2 = clazz2.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                Field field2 = fieldArray2[i];
                int n = field.getModifiers();
                if ((n & 2) == 2) continue;
                Class<?> clazz3 = field.getType();
                String string = field.getName();
                if (string.compareTo("stringRepresentation") == 0 || string.compareTo("indentation") == 0) continue;
                try {
                    if (clazz3.isPrimitive()) {
                        String string2 = clazz3.toString();
                        if (!(string2.compareTo("int") == 0 ? field.getInt(this) != field2.getInt(object) : (string2.compareTo("short") == 0 ? field.getShort(this) != field2.getShort(object) : (string2.compareTo("char") == 0 ? field.getChar(this) != field2.getChar(object) : (string2.compareTo("long") == 0 ? field.getLong(this) != field2.getLong(object) : (string2.compareTo("boolean") == 0 ? field.getBoolean(this) != field2.getBoolean(object) : (string2.compareTo("double") == 0 ? field.getDouble(this) != field2.getDouble(object) : string2.compareTo("float") == 0 && field.getFloat(this) != field2.getFloat(object)))))))) continue;
                        return false;
                    }
                    if (field2.get(object) == field.get(this)) {
                        return true;
                    }
                    if (field.get(this) == null) {
                        return false;
                    }
                    if (field2.get(object) == null) {
                        return false;
                    }
                    if (field2.get(object) == null && field.get(this) != null) {
                        return false;
                    }
                    if (field.get(this).equals(field2.get(object))) continue;
                    return false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    InternalErrorHandler.handleException(illegalAccessException);
                }
            }
            if (clazz.equals(class$gov$nist$core$GenericObject == null ? GenericObject.class$("gov.nist.core.GenericObject") : class$gov$nist$core$GenericObject)) break;
            clazz = clazz.getSuperclass();
            clazz2 = clazz2.getSuperclass();
        }
        return true;
    }

    public boolean match(Object object) {
        if (object == null) {
            return true;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        GenericObject genericObject = (GenericObject)object;
        Class<?> clazz = this.getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        Class<?> clazz2 = object.getClass();
        Field[] fieldArray2 = clazz2.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            Field field2 = fieldArray2[i];
            int n = field.getModifiers();
            if ((n & 2) == 2) continue;
            Class<?> clazz3 = field.getType();
            String string = field.getName();
            if (string.compareTo("stringRepresentation") == 0 || string.compareTo("indentation") == 0) continue;
            try {
                Object object2;
                if (clazz3.isPrimitive()) {
                    object2 = clazz3.toString();
                    if (!(((String)object2).compareTo("int") == 0 ? field.getInt(this) != field2.getInt(genericObject) : (((String)object2).compareTo("short") == 0 ? field.getShort(this) != field2.getShort(genericObject) : (((String)object2).compareTo("char") == 0 ? field.getChar(this) != field2.getChar(genericObject) : (((String)object2).compareTo("long") == 0 ? field.getLong(this) != field2.getLong(genericObject) : (((String)object2).compareTo("boolean") == 0 ? field.getBoolean(this) != field2.getBoolean(genericObject) : (((String)object2).compareTo("double") == 0 ? field.getDouble(this) != field2.getDouble(genericObject) : ((String)object2).compareTo("float") == 0 && field.getFloat(this) != field2.getFloat(genericObject)))))))) continue;
                    return false;
                }
                object2 = field.get(this);
                Object object3 = field2.get(genericObject);
                if (object3 != null && object2 == null) {
                    return false;
                }
                if (object3 == null && object2 != null || object3 == null && object2 == null) continue;
                if (object3 instanceof String && object2 instanceof String) {
                    if (((String)object3).trim().equals("") || ((String)object2).compareToIgnoreCase((String)object3) == 0) continue;
                    return false;
                }
                if (GenericObject.isMySubclass(object2.getClass()) && !((GenericObject)object2).match(object3)) {
                    return false;
                }
                if (!GenericObjectList.isMySubclass(object2.getClass()) || ((GenericObjectList)object2).match(object3)) continue;
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                InternalErrorHandler.handleException(illegalAccessException);
            }
        }
        return true;
    }

    public String debugDump() {
        this.stringRepresentation = "";
        Class<?> clazz = this.getClass();
        this.sprint(clazz.getName());
        this.sprint("{");
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n = field.getModifiers();
            if ((n & 2) == 2) continue;
            Class<?> clazz2 = field.getType();
            String string = field.getName();
            if (string.compareTo("stringRepresentation") == 0 || string.compareTo("indentation") == 0) continue;
            this.sprint(string + COLON);
            try {
                if (clazz2.isPrimitive()) {
                    String string2 = clazz2.toString();
                    this.sprint(string2 + COLON);
                    if (string2.compareTo("int") == 0) {
                        int n2 = field.getInt(this);
                        this.sprint(n2);
                        continue;
                    }
                    if (string2.compareTo("short") == 0) {
                        short s = field.getShort(this);
                        this.sprint(s);
                        continue;
                    }
                    if (string2.compareTo("char") == 0) {
                        char c = field.getChar(this);
                        this.sprint(c);
                        continue;
                    }
                    if (string2.compareTo("long") == 0) {
                        long l = field.getLong(this);
                        this.sprint(l);
                        continue;
                    }
                    if (string2.compareTo("boolean") == 0) {
                        boolean bl = field.getBoolean(this);
                        this.sprint(bl);
                        continue;
                    }
                    if (string2.compareTo("double") == 0) {
                        double d = field.getDouble(this);
                        this.sprint(d);
                        continue;
                    }
                    if (string2.compareTo("float") != 0) continue;
                    float f = field.getFloat(this);
                    this.sprint(f);
                    continue;
                }
                if ((class$gov$nist$core$GenericObject == null ? GenericObject.class$("gov.nist.core.GenericObject") : class$gov$nist$core$GenericObject).isAssignableFrom(clazz2)) {
                    if (field.get(this) != null) {
                        this.sprint(((GenericObject)field.get(this)).debugDump(this.indentation + 1));
                        continue;
                    }
                    this.sprint("<null>");
                    continue;
                }
                if ((class$gov$nist$core$GenericObjectList == null ? GenericObject.class$("gov.nist.core.GenericObjectList") : class$gov$nist$core$GenericObjectList).isAssignableFrom(clazz2)) {
                    if (field.get(this) != null) {
                        this.sprint(((GenericObjectList)field.get(this)).debugDump(this.indentation + 1));
                        continue;
                    }
                    this.sprint("<null>");
                    continue;
                }
                if (field.get(this) != null) {
                    this.sprint(field.get(this).getClass().getName() + COLON);
                } else {
                    this.sprint(clazz2.getName() + COLON);
                }
                this.sprint("{");
                if (field.get(this) != null) {
                    this.sprint(field.get(this).toString());
                } else {
                    this.sprint("<null>");
                }
                this.sprint("}");
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (Exception exception) {
                InternalErrorHandler.handleException(exception);
            }
        }
        this.sprint("}");
        return this.stringRepresentation;
    }

    public String debugDump(int n) {
        this.indentation = n;
        String string = this.debugDump();
        this.indentation = 0;
        return string;
    }

    public abstract String encode();

    static {
        try {
            for (int i = 0; i < immutableClassNames.length; ++i) {
                immutableClasses.add(Class.forName("java.lang." + immutableClassNames[i]));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Internal error", classNotFoundException);
        }
    }
}

