/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.management;

import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoServiceListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.management.IoSessionStat;

public class StatCollector {
    public static final String KEY = StatCollector.class.getName() + ".stat";
    private static volatile int nextId = 0;
    private final int id = nextId++;
    private final IoService service;
    private Worker worker;
    private int pollingInterval = 5000;
    private Queue<IoSession> polledSessions;
    private AtomicLong totalProcessedSessions = new AtomicLong();
    private AtomicInteger msgWrittenThroughput = new AtomicInteger();
    private AtomicInteger msgReadThroughput = new AtomicInteger();
    private AtomicInteger bytesWrittenThroughput = new AtomicInteger();
    private AtomicInteger bytesReadThroughput = new AtomicInteger();
    private final IoServiceListener serviceListener = new IoServiceListener(){

        public void serviceActivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        }

        public void serviceDeactivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        }

        public void sessionCreated(IoSession session) {
            StatCollector.this.addSession(session);
        }

        public void sessionDestroyed(IoSession session) {
            StatCollector.this.removeSession(session);
        }
    };

    public StatCollector(IoService service) {
        this(service, 5000);
    }

    public StatCollector(IoService service, int pollingInterval) {
        this.service = service;
        this.pollingInterval = pollingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            if (this.worker != null && this.worker.isAlive()) {
                throw new RuntimeException("Stat collecting already started");
            }
            this.polledSessions = new ConcurrentLinkedQueue<IoSession>();
            for (SocketAddress element : this.service.getManagedServiceAddresses()) {
                Iterator<IoSession> iter2 = this.service.getManagedSessions(element).iterator();
                while (iter2.hasNext()) {
                    this.addSession(iter2.next());
                }
            }
            this.service.addListener(this.serviceListener);
            this.worker = new Worker();
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            this.service.removeListener(this.serviceListener);
            this.worker.stop = true;
            this.worker.interrupt();
            while (this.worker.isAlive()) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException e) {}
            }
            for (IoSession session : this.polledSessions) {
                session.removeAttribute(KEY);
            }
            this.polledSessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            return this.worker != null && !this.worker.stop;
        }
    }

    private void addSession(IoSession session) {
        IoSessionStat sessionStats = new IoSessionStat();
        sessionStats.lastPollingTime = System.currentTimeMillis();
        session.setAttribute(KEY, sessionStats);
        this.totalProcessedSessions.incrementAndGet();
        this.polledSessions.add(session);
    }

    private void removeSession(IoSession session) {
        this.polledSessions.remove(session);
        IoSessionStat sessStat = (IoSessionStat)session.getAttribute(KEY);
        float pollDelta = (float)(System.currentTimeMillis() - sessStat.lastPollingTime) / 1000.0f;
        this.msgWrittenThroughput.addAndGet(Float.floatToIntBits((float)(session.getWrittenMessages() - sessStat.lastMessageWrite) / pollDelta));
        this.msgReadThroughput.addAndGet(Float.floatToIntBits((float)(session.getReadMessages() - sessStat.lastMessageRead) / pollDelta));
        this.bytesWrittenThroughput.addAndGet(Float.floatToIntBits((float)(session.getWrittenBytes() - sessStat.lastByteWrite) / pollDelta));
        this.bytesReadThroughput.addAndGet(Float.floatToIntBits((float)(session.getReadBytes() - sessStat.lastByteRead) / pollDelta));
        session.removeAttribute(KEY);
    }

    public long getTotalProcessedSessions() {
        return this.totalProcessedSessions.longValue();
    }

    public float getBytesReadThroughput() {
        return Float.intBitsToFloat(this.bytesReadThroughput.getAndSet(0));
    }

    public float getBytesWrittenThroughput() {
        return Float.intBitsToFloat(this.bytesWrittenThroughput.getAndSet(0));
    }

    public float getMsgReadThroughput() {
        return Float.intBitsToFloat(this.msgReadThroughput.getAndSet(0));
    }

    public float getMsgWrittenThroughput() {
        return Float.intBitsToFloat(this.msgWrittenThroughput.getAndSet(0));
    }

    public long getSessionCount() {
        return this.polledSessions.size();
    }

    private class Worker
    extends Thread {
        boolean stop;

        private Worker() {
            super("StatCollectorWorker-" + StatCollector.this.id);
            this.stop = false;
        }

        public void run() {
            while (!this.stop) {
                try {
                    Thread.sleep(StatCollector.this.pollingInterval);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                float tmpMsgWrittenThroughput = 0.0f;
                float tmpMsgReadThroughput = 0.0f;
                float tmpBytesWrittenThroughput = 0.0f;
                float tmpBytesReadThroughput = 0.0f;
                for (IoSession session : StatCollector.this.polledSessions) {
                    IoSessionStat sessStat = (IoSessionStat)session.getAttribute(KEY);
                    long currentTimestamp = System.currentTimeMillis();
                    float pollDelta = (float)(currentTimestamp - sessStat.lastPollingTime) / 1000.0f;
                    sessStat.lastPollingTime = currentTimestamp;
                    long readBytes = session.getReadBytes();
                    long writtenBytes = session.getWrittenBytes();
                    long readMessages = session.getReadMessages();
                    long writtenMessages = session.getWrittenMessages();
                    sessStat.byteReadThroughput = (float)(readBytes - sessStat.lastByteRead) / pollDelta;
                    sessStat.byteWrittenThroughput = (float)(writtenBytes - sessStat.lastByteWrite) / pollDelta;
                    sessStat.messageReadThroughput = (float)(readMessages - sessStat.lastMessageRead) / pollDelta;
                    sessStat.messageWrittenThroughput = (float)(writtenMessages - sessStat.lastMessageWrite) / pollDelta;
                    sessStat.lastByteRead = readBytes;
                    sessStat.lastByteWrite = writtenBytes;
                    sessStat.lastMessageRead = readMessages;
                    sessStat.lastMessageWrite = writtenMessages;
                    tmpMsgWrittenThroughput += sessStat.messageWrittenThroughput;
                    tmpMsgReadThroughput += sessStat.messageReadThroughput;
                    tmpBytesWrittenThroughput += sessStat.byteWrittenThroughput;
                    tmpBytesReadThroughput += sessStat.byteReadThroughput;
                }
                StatCollector.this.msgWrittenThroughput.addAndGet(Float.floatToIntBits(tmpMsgWrittenThroughput));
                StatCollector.this.msgReadThroughput.addAndGet(Float.floatToIntBits(tmpMsgReadThroughput));
                StatCollector.this.bytesWrittenThroughput.addAndGet(Float.floatToIntBits(tmpBytesWrittenThroughput));
                StatCollector.this.bytesReadThroughput.addAndGet(Float.floatToIntBits(tmpBytesReadThroughput));
            }
        }
    }
}

