/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.direct;

import com.lowagie.text.rtf.direct.RtfImportHeader;
import java.awt.Color;

public class RtfColorTableParser {
    private RtfImportHeader importHeader = null;
    private int colorNr = 0;
    private int red = -1;
    private int green = -1;
    private int blue = -1;

    public RtfColorTableParser(RtfImportHeader importHeader) {
        this.importHeader = importHeader;
        this.colorNr = 0;
        this.red = -1;
        this.green = -1;
        this.blue = -1;
    }

    public static boolean stringMatches(String text, String start) {
        int last;
        if (!text.startsWith(start)) {
            return false;
        }
        int first = start.length();
        if (first == (last = text.length())) {
            return false;
        }
        int k = first;
        while (k < last) {
            char c = text.charAt(k);
            if (c < '0' || c > '9') {
                return false;
            }
            ++k;
        }
        return true;
    }

    public void handleCtrlWord(String ctrlWord, int groupLevel) {
        if (RtfColorTableParser.stringMatches(ctrlWord, "\\red")) {
            this.red = Integer.parseInt(ctrlWord.substring(4));
        } else if (RtfColorTableParser.stringMatches(ctrlWord, "\\green")) {
            this.red = Integer.parseInt(ctrlWord.substring(6));
        } else if (RtfColorTableParser.stringMatches(ctrlWord, "\\blue")) {
            this.red = Integer.parseInt(ctrlWord.substring(5));
        }
    }

    public void handleText(String text, int groupLevel) {
        if (text.indexOf(59) != -1) {
            if (this.red != -1 && this.green != -1 && this.blue != -1) {
                this.importHeader.importColor(Integer.toString(this.colorNr), new Color(this.red, this.green, this.blue));
            }
            ++this.colorNr;
        }
    }
}

