/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfCell;
import com.lowagie.text.rtf.RtfTable;
import com.lowagie.text.rtf.RtfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfRow {
    public static final byte[] tableBorder = "brdrs".getBytes();
    public static final byte[] tableBorderWidth = "brdrw".getBytes();
    public static final byte[] tableBorderColor = "brdrcf".getBytes();
    private static final byte[] rowBegin = "trowd".getBytes();
    private static final byte[] rowEnd = "row".getBytes();
    private static final byte[] rowAutofit = "trautofit1".getBytes();
    private static final byte[] graphLeft = "trgaph".getBytes();
    private static final byte[] rowBorderLeft = "trbrdrl".getBytes();
    private static final byte[] rowBorderRight = "trbrdrr".getBytes();
    private static final byte[] rowBorderTop = "trbrdrt".getBytes();
    private static final byte[] rowBorderBottom = "trbrdrb".getBytes();
    private static final byte[] rowBorderInlineHorizontal = "trbrdrh".getBytes();
    private static final byte[] rowBorderInlineVertical = "trbrdrv".getBytes();
    private static final byte[] rowSpacingLeft = "trspdl".getBytes();
    private static final byte[] rowSpacingRight = "trspdr".getBytes();
    private static final byte[] rowSpacingTop = "trspdt".getBytes();
    private static final byte[] rowSpacingBottom = "trspdb".getBytes();
    private static final byte[] rowSpacingLeftStyle = "trspdfl3".getBytes();
    private static final byte[] rowSpacingRightStyle = "trspdfr3".getBytes();
    private static final byte[] rowSpacingTopStyle = "trspdft3".getBytes();
    private static final byte[] rowSpacingBottomStyle = "trspdfb3".getBytes();
    private static final byte[] rowPaddingLeft = "trpaddl".getBytes();
    private static final byte[] rowPaddingRight = "trpaddr".getBytes();
    private static final byte[] rowPaddingLeftStyle = "trpaddfl3".getBytes();
    private static final byte[] rowPaddingRightStyle = "trpaddfr3".getBytes();
    private static final byte[] rowWidthStyle = "trftsWidth3".getBytes();
    private static final byte[] rowWidth = "trwWidth".getBytes();
    private static final byte[] rowHeader = "trhdr".getBytes();
    private static final byte[] rowKeep = "trkeep".getBytes();
    private static final byte[] rowAlignLeft = "trql".getBytes();
    private static final byte[] rowAlignCenter = "trqc".getBytes();
    private static final byte[] rowAlignRight = "trqr".getBytes();
    private ArrayList cells = new ArrayList();
    private RtfWriter writer = null;
    private RtfTable mainTable = null;
    private int width = 100;
    private int cellpadding = 115;
    private int cellspacing = 14;
    private int borders = 0;
    private Color borderColor = null;
    private float borderWidth = 0.0f;
    private Row origRow = null;

    public RtfRow(RtfWriter writer, RtfTable mainTable) {
        this.writer = writer;
        this.mainTable = mainTable;
    }

    public void pregenerateRows(int columns) {
        int i = 0;
        while (i < columns) {
            RtfCell rtfCell = new RtfCell(this.writer, this.mainTable);
            this.cells.add(rtfCell);
            ++i;
        }
    }

    public boolean importRow(Row row, float[] propWidths, int tableWidth, int pageWidth, int cellpadding, int cellspacing, int borders, Color borderColor, float borderWidth, int y) {
        this.origRow = row;
        this.width = pageWidth * tableWidth / 100;
        this.cellpadding = cellpadding;
        this.cellspacing = cellspacing;
        this.borders = borders;
        this.borderColor = borderColor;
        this.borderWidth = borderWidth;
        if (this.borderWidth > 2.0f) {
            this.borderWidth = 2.0f;
        }
        int cellLeft = 0;
        int i = 0;
        while (i < row.columns()) {
            RtfCell rtfCell;
            Element cell = (Element)row.getCell(i);
            int cellWidth = (int)((float)this.width * propWidths[i] / 100.0f);
            if (cell != null) {
                if (cell.type() == 20) {
                    rtfCell = (RtfCell)this.cells.get(i);
                    cellLeft = rtfCell.importCell((Cell)cell, cellLeft, cellWidth, i, y, cellpadding);
                }
            } else {
                rtfCell = (RtfCell)this.cells.get(i);
                cellLeft = rtfCell.importCell(null, cellLeft, cellWidth, i, y, cellpadding);
            }
            ++i;
        }
        int columns = row.columns();
        int i2 = 0;
        while (i2 < columns) {
            RtfCell firstCell = (RtfCell)this.cells.get(i2);
            Cell cell = firstCell.getStore();
            int cols = 0;
            if (cell != null) {
                cols = cell.colspan();
            }
            if (cols > 1) {
                RtfCell lastCell = (RtfCell)this.cells.get(i2 + cols - 1);
                firstCell.setCellRight(lastCell.getCellRight());
                int width = firstCell.getCellWidth();
                int j = i2 + 1;
                while (j < i2 + cols) {
                    RtfCell cCell = (RtfCell)this.cells.get(j);
                    width += cCell.getCellWidth();
                    ++j;
                }
                firstCell.setCellWidth(width);
                i2 += cols - 1;
            }
            ++i2;
        }
        return true;
    }

    public boolean writeRow(ByteArrayOutputStream os, int rowNum, Table table) throws DocumentException, IOException {
        RtfCell cell;
        os.write(92);
        os.write(rowBegin);
        os.write(10);
        os.write(92);
        os.write(rowWidthStyle);
        os.write(92);
        os.write(rowWidth);
        this.writeInt(os, this.width);
        if (this.mainTable.getOriginalTable().hasToFitPageCells()) {
            os.write(92);
            os.write(rowKeep);
        }
        if (rowNum < table.firstDataRow()) {
            os.write(92);
            os.write(rowHeader);
        }
        os.write(92);
        switch (this.origRow.horizontalAlignment()) {
            case 0: {
                os.write(rowAlignLeft);
                break;
            }
            case 1: {
                os.write(rowAlignCenter);
                break;
            }
            case 2: {
                os.write(rowAlignRight);
                break;
            }
            default: {
                os.write(rowAlignLeft);
            }
        }
        os.write(92);
        os.write(graphLeft);
        this.writeInt(os, 10);
        if ((this.borders & 4) == 4 && this.borderWidth > 0.0f) {
            this.writeBorder(os, rowBorderLeft);
        }
        if ((this.borders & 1) == 1 && this.borderWidth > 0.0f) {
            this.writeBorder(os, rowBorderTop);
        }
        if ((this.borders & 2) == 2 && this.borderWidth > 0.0f) {
            this.writeBorder(os, rowBorderBottom);
        }
        if ((this.borders & 8) == 8 && this.borderWidth > 0.0f) {
            this.writeBorder(os, rowBorderRight);
        }
        if ((this.borders & 0xF) == 15 && this.borderWidth > 0.0f) {
            this.writeBorder(os, rowBorderInlineHorizontal);
            this.writeBorder(os, rowBorderInlineVertical);
        }
        if (this.cellspacing > 0) {
            os.write(92);
            os.write(rowSpacingLeft);
            this.writeInt(os, this.cellspacing / 2);
            os.write(92);
            os.write(rowSpacingLeftStyle);
            os.write(92);
            os.write(rowSpacingTop);
            this.writeInt(os, this.cellspacing / 2);
            os.write(92);
            os.write(rowSpacingTopStyle);
            os.write(92);
            os.write(rowSpacingBottom);
            this.writeInt(os, this.cellspacing / 2);
            os.write(92);
            os.write(rowSpacingBottomStyle);
            os.write(92);
            os.write(rowSpacingRight);
            this.writeInt(os, this.cellspacing / 2);
            os.write(92);
            os.write(rowSpacingRightStyle);
        }
        os.write(92);
        os.write(rowPaddingLeft);
        this.writeInt(os, this.cellpadding / 2);
        os.write(92);
        os.write(rowPaddingRight);
        this.writeInt(os, this.cellpadding / 2);
        os.write(92);
        os.write(rowPaddingLeftStyle);
        os.write(92);
        os.write(rowPaddingRightStyle);
        os.write(10);
        Iterator cellIterator = this.cells.iterator();
        while (cellIterator.hasNext()) {
            cell = (RtfCell)cellIterator.next();
            cell.writeCellSettings(os);
        }
        os.write(92);
        os.write("intbl".getBytes());
        cellIterator = this.cells.iterator();
        while (cellIterator.hasNext()) {
            cell = (RtfCell)cellIterator.next();
            cell.writeCellContent(os);
        }
        os.write(32);
        os.write(92);
        os.write(rowEnd);
        return true;
    }

    private void writeBorder(ByteArrayOutputStream os, byte[] borderType) throws IOException {
        os.write(92);
        os.write(borderType);
        os.write(92);
        os.write(tableBorder);
        os.write(92);
        os.write(tableBorderWidth);
        this.writeInt(os, (int)((double)this.borderWidth * 20.0));
        os.write(92);
        os.write(tableBorderColor);
        if (this.borderColor == null) {
            this.writeInt(os, this.writer.addColor(new Color(0, 0, 0)));
        } else {
            this.writeInt(os, this.writer.addColor(this.borderColor));
        }
        os.write(10);
    }

    public void setMerge(int x, int mergeType, RtfCell mergeCell) {
        RtfCell cell = (RtfCell)this.cells.get(x);
        cell.setMerge(mergeType, mergeCell);
    }

    private void writeInt(ByteArrayOutputStream out, int i) throws IOException {
        out.write(Integer.toString(i).getBytes());
    }
}

