/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtil {
    private ClassUtil() {
    }

    public static Class classForName(String pClassName, ClassLoader ... pClassLoaders) {
        return ClassUtil.classForName(pClassName, true, pClassLoaders);
    }

    public static Class classForName(String pClassName, boolean pInitialize, ClassLoader ... pClassLoaders) {
        HashSet<ClassLoader> tried = new HashSet<ClassLoader>();
        Iterator<ClassLoader> i$ = ClassUtil.findClassLoaders(pClassLoaders).iterator();
        while (i$.hasNext()) {
            for (ClassLoader loader = i$.next(); loader != null; loader = loader.getParent()) {
                try {
                    if (!tried.contains(loader)) {
                        return Class.forName(pClassName, pInitialize, loader);
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                tried.add(loader);
            }
        }
        return null;
    }

    private static List<ClassLoader> findClassLoaders(ClassLoader ... pClassLoaders) {
        ArrayList<ClassLoader> classLoadersToTry = new ArrayList<ClassLoader>(Arrays.asList(pClassLoaders));
        classLoadersToTry.add(Thread.currentThread().getContextClassLoader());
        classLoadersToTry.add(ClassUtil.class.getClassLoader());
        ArrayList<ClassLoader> ret = new ArrayList<ClassLoader>();
        HashSet<ClassLoader> visited = new HashSet<ClassLoader>();
        for (ClassLoader cll : classLoadersToTry) {
            if (cll == null || visited.contains(cll)) continue;
            ret.add(cll);
            visited.add(cll);
        }
        return ret;
    }

    public static InputStream getResourceAsStream(String pPath) {
        for (ClassLoader loader : new ClassLoader[]{Thread.currentThread().getContextClassLoader(), ClassUtil.class.getClassLoader()}) {
            InputStream is;
            if (loader == null || (is = loader.getResourceAsStream(pPath)) == null) continue;
            return is;
        }
        return null;
    }

    public static boolean checkForClass(String pClassName) {
        return ClassUtil.classForName(pClassName, false, new ClassLoader[0]) != null;
    }

    public static <T> T newInstance(String pClass) {
        try {
            Class clazz = ClassUtil.classForName(pClass, new ClassLoader[0]);
            if (clazz != null) {
                return clazz.newInstance();
            }
            throw new IllegalArgumentException("Cannot find " + pClass);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate " + pClass + ": " + e, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot instantiate " + pClass + ": " + e, e);
        }
    }

    public static Set<String> getResources(String pResource) throws IOException {
        List<ClassLoader> clls = ClassUtil.findClassLoaders(new ClassLoader[0]);
        if (clls.size() != 0) {
            HashSet<String> ret = new HashSet<String>();
            for (ClassLoader cll : clls) {
                Enumeration<URL> urlEnum = cll.getResources(pResource);
                ret.addAll(ClassUtil.extractUrlAsStringsFromEnumeration(urlEnum));
            }
            return ret;
        }
        return ClassUtil.extractUrlAsStringsFromEnumeration(ClassLoader.getSystemResources(pResource));
    }

    private static Set<String> extractUrlAsStringsFromEnumeration(Enumeration<URL> urlEnum) {
        HashSet<String> ret = new HashSet<String>();
        while (urlEnum.hasMoreElements()) {
            ret.add(urlEnum.nextElement().toExternalForm());
        }
        return ret;
    }
}

