/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.utils.Objects;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Maps {
    public static <T extends Map<?, ?>> T make(String ... args) {
        return Maps.make((Object[])args);
    }

    public static Map<String, String> cast(Properties properties) {
        Object result = Maps.make(new String[0]);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            key = key != null ? key.toString() : null;
            Object value = entry.getValue();
            value = value != null ? value.toString() : null;
            result.put((String)((String)key), (String)((String)value));
        }
        return result;
    }

    public static <T extends Map<?, ?>> T make(Object ... args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("expected even number of args");
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < args.length; i += 2) {
            map.put(args[i], args[i + 1]);
        }
        return (T)map;
    }

    public static <T extends Map<?, ?>, K extends Enum<K>> T makeEnumMap(Class<K> keyClazz) {
        EnumMap map;
        EnumMap result = map = new EnumMap(keyClazz);
        return (T)result;
    }

    public static <T extends Map<?, ?>, K extends Enum<K>> T makeEnumMap(K firstKey, Object ... args) {
        Objects.assertion((args.length + 1) % 2 == 0, "expected even number of args", new Object[0]);
        Class<K> enumClazz = firstKey.getDeclaringClass();
        EnumMap<Enum, Object> map = new EnumMap<Enum, Object>(enumClazz);
        map.put(firstKey, args[0]);
        for (int i = 1; i < args.length; i += 2) {
            Enum key = (Enum)enumClazz.cast(args[i]);
            Object value = args[i + 1];
            map.put(key, value);
        }
        EnumMap<Enum, Object> result = map;
        return (T)result;
    }

    public static <K, V, MapType extends Map<? super K, ? super V>> MapType make(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return (MapType)map;
    }

    public static <K, V> V get(Map<K, V> map, K key, V def) {
        V value = map.get(key);
        if (value != null) {
            return value;
        }
        return def;
    }
}

