/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.util.Vector;
import java.util.logging.Logger;
import javax.media.Manager;
import javax.media.PackageManager;
import net.sf.fmj.utility.LoggerSingleton;

public final class ClasspathChecker {
    private static final Logger logger = LoggerSingleton.logger;

    public static boolean check() {
        boolean result = true;
        if (!ClasspathChecker.checkFMJPrefixInPackageManager()) {
            result = false;
        }
        if (!ClasspathChecker.checkManagerImplementation()) {
            result = false;
        }
        return result;
    }

    public static boolean checkAndWarn() {
        boolean result = true;
        if (!ClasspathChecker.checkFMJPrefixInPackageManager()) {
            logger.warning("net.sf.fmj not found in PackageManager.getContentPrefixList() and PackageManager.getProtocolPrefixList(); is JMF ahead of FMJ in the classpath?");
            result = false;
        }
        if (ClasspathChecker.checkJMFInClassPath()) {
            logger.info("JMF detected in classpath");
        }
        if (!ClasspathChecker.checkManagerImplementation()) {
            logger.warning("javax.media.Manager is JMF's implementation, not FMJ's; is JMF ahead of FMJ in the classpath?");
            result = false;
        }
        logger.info("javax.media.Manager version: " + Manager.getVersion());
        return result;
    }

    public static boolean checkFMJPrefixInPackageManager() {
        Vector contentList = PackageManager.getContentPrefixList();
        if (!contentList.contains("net.sf.fmj")) {
            return false;
        }
        Vector protocolList = PackageManager.getProtocolPrefixList();
        return protocolList.contains("net.sf.fmj");
    }

    public static boolean checkJMFInClassPath() {
        try {
            Class.forName("com.sun.media.BasicClock");
            Class.forName("com.sun.media.BasicCodec");
            Class.forName("com.sun.media.BasicConnector");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkManagerImplementation() {
        try {
            Manager.class.getField("FMJ_TAG");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

