/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Roster
extends IQ {
    public Roster() {
        this.element.addElement("query", "jabber:iq:roster");
    }

    public Roster(IQ.Type type) {
        super(type);
        this.element.addElement("query", "jabber:iq:roster");
    }

    public Roster(IQ.Type type, String string) {
        super(type, string);
        this.element.addElement("query", "jabber:iq:roster");
    }

    public Roster(Element element) {
        super(element);
    }

    public Item addItem(String string, Subscription subscription) {
        if (this.getType() == IQ.Type.get || this.getType() == IQ.Type.error) {
            throw new IllegalStateException("IQ type must be 'result' or 'set'");
        }
        if (string == null) {
            throw new NullPointerException("JID cannot be null");
        }
        return this.addItem(new JID(string), null, null, subscription, null);
    }

    public Item addItem(JID jID, Subscription subscription) {
        if (this.getType() != IQ.Type.result || this.getType() != IQ.Type.set) {
            throw new IllegalStateException("IQ type must be 'result' or 'set'");
        }
        if (jID == null) {
            throw new NullPointerException("JID cannot be null");
        }
        return this.addItem(jID, null, null, subscription, null);
    }

    public Item addItem(JID jID, String string, Ask ask, Subscription subscription, Collection<String> collection) {
        if (jID == null) {
            throw new NullPointerException("JID cannot be null");
        }
        if (subscription == null) {
            throw new NullPointerException("Subscription cannot be null");
        }
        Element element = this.element.element(new QName("query", Namespace.get((String)"jabber:iq:roster")));
        if (element == null) {
            element = this.element.addElement("query", "jabber:iq:roster");
        }
        Element element2 = null;
        Iterator<String> iterator = element.elementIterator("item");
        while (iterator.hasNext()) {
            Element object = (Element)iterator.next();
            if (!object.attributeValue("jid").equals(jID.toString())) continue;
            element2 = object;
        }
        if (element2 == null) {
            element2 = element.addElement("item");
        }
        element2.addAttribute("jid", jID.toString());
        element2.addAttribute("name", string);
        if (ask != null) {
            element2.addAttribute("ask", ask.toString());
        }
        element2.addAttribute("subscription", subscription.toString());
        iterator = element2.elementIterator("group");
        while (iterator.hasNext()) {
            element2.remove((Element)iterator.next());
        }
        if (collection != null) {
            for (String string2 : collection) {
                element2.addElement("group").setText(string2);
            }
        }
        return new Item(jID, string, ask, subscription, collection);
    }

    public void removeItem(JID jID) {
        Element element = this.element.element(new QName("query", Namespace.get((String)"jabber:iq:roster")));
        if (element != null) {
            Iterator iterator = element.elementIterator("item");
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                if (!element2.attributeValue("jid").equals(jID.toString())) continue;
                element.remove(element2);
                return;
            }
        }
    }

    public Collection<Item> getItems() {
        ArrayList<Item> arrayList = new ArrayList<Item>();
        Element element = this.element.element(new QName("query", Namespace.get((String)"jabber:iq:roster")));
        if (element != null) {
            Iterator iterator = element.elementIterator("item");
            while (iterator.hasNext()) {
                Object object;
                Element element2 = (Element)iterator.next();
                String string = element2.attributeValue("jid");
                String string2 = element2.attributeValue("name");
                String string3 = element2.attributeValue("ask");
                String string4 = element2.attributeValue("subscription");
                ArrayList<String> arrayList2 = new ArrayList<String>();
                Object object2 = element2.elementIterator("group");
                while (object2.hasNext()) {
                    object = (Element)object2.next();
                    arrayList2.add(object.getTextTrim());
                }
                object2 = string3 == null ? null : Ask.valueOf(string3);
                object = string4 == null ? null : Subscription.valueOf(string4);
                arrayList.add(new Item(new JID(string), string2, (Ask)((Object)object2), (Subscription)((Object)object), arrayList2));
            }
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    public Roster createCopy() {
        Element element = this.element.createCopy();
        docFactory.createDocument().add(this.element.createCopy());
        return new Roster(element);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Ask {
        subscribe,
        unsubscribe;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Subscription {
        none,
        to,
        from,
        both,
        remove;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Item {
        private JID jid;
        private String name;
        private Ask ask;
        private Subscription subscription;
        private Collection<String> groups;

        private Item(JID jID, String string, Ask ask, Subscription subscription, Collection<String> collection) {
            this.jid = jID;
            this.name = string;
            this.ask = ask;
            this.subscription = subscription;
            this.groups = collection;
        }

        public JID getJID() {
            return this.jid;
        }

        public String getName() {
            return this.name;
        }

        public Ask getAsk() {
            return this.ask;
        }

        public Subscription getSubscription() {
            return this.subscription;
        }

        public Collection<String> getGroups() {
            if (this.groups == null) {
                return Collections.emptyList();
            }
            return this.groups;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<item ");
            stringBuffer.append("jid=\"").append(this.jid).append("\"");
            if (this.name != null) {
                stringBuffer.append(" name=\"").append(this.name).append("\"");
            }
            stringBuffer.append(" subscrption=\"").append((Object)this.subscription).append("\"");
            if (this.groups == null || this.groups.isEmpty()) {
                stringBuffer.append("/>");
            } else {
                stringBuffer.append(">\n");
                for (String string : this.groups) {
                    stringBuffer.append("  <group>").append(string).append("</group>\n");
                }
                stringBuffer.append("</item>");
            }
            return stringBuffer.toString();
        }
    }
}

