/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import java.io.StringWriter;
import java.io.Writer;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xmpp.packet.JID;
import org.xmpp.packet.PacketError;

public abstract class Packet {
    protected static DocumentFactory docFactory = DocumentFactory.getInstance();
    protected Element element;

    public Packet(Element element) {
        Object object;
        this.element = element;
        String string = element.attributeValue("to");
        if (string != null) {
            object = new JID(string);
            element.addAttribute("to", ((JID)object).toString());
        }
        if ((object = element.attributeValue("from")) != null) {
            JID jID = new JID((String)object);
            element.addAttribute("from", jID.toString());
        }
    }

    public String getID() {
        return this.element.attributeValue("id");
    }

    public void setID(String string) {
        this.element.attribute("id");
        this.element.addAttribute("id", string);
    }

    public JID getTo() {
        String string = this.element.attributeValue("to");
        if (string == null) {
            return null;
        }
        return new JID(string, null);
    }

    public void setTo(String string) {
        if (string != null) {
            string = new JID(string).toString();
        }
        this.element.addAttribute("to", string);
    }

    public void setTo(JID jID) {
        if (jID == null) {
            this.element.addAttribute("to", null);
        } else {
            this.setTo(jID.toString());
        }
    }

    public JID getFrom() {
        String string = this.element.attributeValue("from");
        if (string == null) {
            return null;
        }
        return new JID(string, null);
    }

    public void setFrom(String string) {
        if (string != null) {
            string = new JID(string).toString();
        }
        this.element.addAttribute("from", string);
    }

    public void setFrom(JID jID) {
        if (jID == null) {
            this.element.addAttribute("from", null);
        } else {
            this.setFrom(jID.toString());
        }
    }

    public PacketError getError() {
        Element element = this.element.element("error");
        if (element != null) {
            return new PacketError(this.element);
        }
        return null;
    }

    public void setError(PacketError packetError) {
        if (this.element == null) {
            throw new NullPointerException("Error cannot be null");
        }
        this.element.addAttribute("type", "error");
        if (this.element.element("error") != null) {
            this.element.remove(this.element.element("error"));
        }
        this.element.add(packetError.getElement());
    }

    public void setError(PacketError.Condition condition) {
        this.setError(new PacketError(condition));
    }

    public abstract Packet createCopy();

    public Element getElement() {
        return this.element;
    }

    public String toXML() {
        return this.element.asXML();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        XMLWriter xMLWriter = new XMLWriter((Writer)stringWriter, OutputFormat.createPrettyPrint());
        try {
            xMLWriter.write(this.element);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringWriter.toString();
    }
}

