/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.spring;

import com.voxeo.utils.Event;
import com.voxeo.utils.EventDispatcher;
import com.voxeo.utils.EventListener;
import com.voxeo.utils.IEventDispatcher;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDispatcherFactoryBean
implements FactoryBean<IEventDispatcher>,
InitializingBean {
    private Class<?> eventClass;
    private IEventDispatcher dispatcher;
    private List<EventListener<?>> listeners;

    public void afterPropertiesSet() throws Exception {
        if (this.dispatcher == null) {
            this.dispatcher = new EventDispatcher();
        }
        if (this.listeners != null) {
            for (EventListener<?> listener : this.listeners) {
                if (this.eventClass == null) {
                    this.eventClass = Event.class;
                }
                this.dispatcher.addListener(this.eventClass, listener);
            }
        }
    }

    public IEventDispatcher getObject() throws Exception {
        return this.dispatcher;
    }

    public Class<?> getObjectType() {
        return IEventDispatcher.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public IEventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(IEventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void setListeners(List<EventListener<?>> listeners) {
        this.listeners = listeners;
    }

    public List<EventListener<?>> getListeners() {
        return this.listeners;
    }

    public Class<?> getEventClass() {
        return this.eventClass;
    }

    public void setEventClass(Class<?> eventClass) {
        this.eventClass = eventClass;
    }
}

