/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network.challenge;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.openymsg.network.challenge.ChallengeResponseUtility;
import org.openymsg.network.challenge.ChallengeResponseV10Tables;
import org.openymsg.network.challenge.SHA1;

public class ChallengeResponseV10
extends ChallengeResponseUtility
implements ChallengeResponseV10Tables {
    private static final String ALPHANUM_LOOKUP = "qzec2tb3um1olpar8whx4dfgijknsvy5";
    private static final String OPERATORS_LOOKUP = "+|&%/*^-";
    private static final String ENCODE1_LOOKUP = "FBZDWAGHrJTLMNOPpRSKUVEXYChImkwQ";
    private static final String ENCODE2_LOOKUP = "F0E1D2C3B4A59687abcdefghijklmnop";
    private static final String ENCODE3_LOOKUP = ",;";
    private static final String BINARY_DATA = "/challenge.bin";
    private static byte[] data = null;

    public static String[] getStrings(String username, String password, String challenge) throws NoSuchAlgorithmException, IOException {
        int i;
        int operand = 0;
        int cnt = 0;
        for (i = 0; i < challenge.length(); ++i) {
            if (!ChallengeResponseV10.isOperator(challenge.charAt(i))) continue;
            ++cnt;
        }
        int[] magic = new int[cnt];
        cnt = 0;
        for (i = 0; i < challenge.length(); ++i) {
            char c = challenge.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) {
                operand = ALPHANUM_LOOKUP.indexOf(c) << 3;
                continue;
            }
            if (!ChallengeResponseV10.isOperator(c)) continue;
            int a = OPERATORS_LOOKUP.indexOf(c);
            magic[cnt] = (operand | a) & 0xFF;
            ++cnt;
        }
        for (i = magic.length - 2; i >= 0; --i) {
            int a = magic[i];
            int b = magic[i + 1];
            magic[i + 1] = a = (a * 205 ^ b) & 0xFF;
        }
        byte[] comparison = ChallengeResponseV10._part3Munge(magic);
        long seed = 0L;
        byte[] binLookup = new byte[7];
        for (i = 0; i < 4; ++i) {
            seed <<= 8;
            seed += (long)(comparison[3 - i] & 0xFF);
            binLookup[i] = (byte)(comparison[i] & 0xFF);
        }
        int table = 0;
        int depth = 0;
        MessageDigest localMd5 = MessageDigest.getInstance("MD5");
        for (i = 0; i < 65535; ++i) {
            for (int j = 0; j < 5; ++j) {
                binLookup[4] = (byte)(i & 0xFF);
                binLookup[5] = (byte)(i >> 8 & 0xFF);
                binLookup[6] = (byte)j;
                localMd5.reset();
                byte[] result = localMd5.digest(binLookup);
                if (!ChallengeResponseV10._part3Compare(result, comparison)) continue;
                depth = i;
                table = j;
                i = 65535;
                j = 5;
            }
        }
        byte[] magicValue = new byte[4];
        seed = ChallengeResponseV10._part3Lookup(table, depth, seed);
        seed = ChallengeResponseV10._part3Lookup(table, depth, seed);
        for (i = 0; i < magicValue.length; ++i) {
            magicValue[i] = (byte)(seed & 0xFFL);
            seed >>= 8;
        }
        String regular = ChallengeResponseV10.yahoo64(ChallengeResponseV10.md5(password));
        String crypted = ChallengeResponseV10.yahoo64(ChallengeResponseV10.md5(ChallengeResponseV10.md5Crypt(password, "$1$_2S43d5f")));
        boolean hackSha1 = table >= 3;
        String[] s = new String[]{ChallengeResponseV10._part4Encode(ChallengeResponseV10._part4Hash(regular, magicValue, hackSha1)), ChallengeResponseV10._part4Encode(ChallengeResponseV10._part4Hash(crypted, magicValue, hackSha1))};
        return s;
    }

    private static byte[] _part3Munge(int[] magic) {
        int i = 1;
        byte[] comparison = new byte[20];
        for (int c = 0; c < comparison.length; c += 2) {
            int res;
            int a;
            if ((a = magic[i++]) <= 127) {
                res = a;
            } else {
                if (a >= 224) {
                    int b = magic[i++];
                    a = (a & 0xF) << 6;
                    res = a + (b &= 0x3F) << 6;
                } else {
                    res = (a & 0x1F) << 6;
                }
                res += magic[i++] & 0x3F;
            }
            comparison[c] = (byte)((res & 0xFF00) >> 8);
            comparison[c + 1] = (byte)(res & 0xFF);
        }
        return comparison;
    }

    private static int _part3Lookup(int table, int depth, long seed) throws IOException {
        char offset = '\u0000';
        long idx = seed;
        int iseed = (int)seed;
        for (int i = 0; i < depth; ++i) {
            long a;
            int j;
            long c;
            if (table == 0) {
                return iseed;
            }
            if (idx < 0L) {
                idx += 0x100000000L;
            }
            int[] opArr = OPS[table][(int)(idx % 96L)];
            switch (opArr[0]) {
                case 2: {
                    iseed ^= opArr[1];
                    break;
                }
                case 3: {
                    iseed = iseed * opArr[1] + opArr[2];
                    break;
                }
                case 4: {
                    offset = TABLE_OFFSETS[opArr[1]];
                    long b = ChallengeResponseV10._data(offset, iseed & 0xFF) | ChallengeResponseV10._data(offset, iseed >> 8 & 0xFF) << 8 | ChallengeResponseV10._data(offset, iseed >> 16 & 0xFF) << 16 | ChallengeResponseV10._data(offset, iseed >> 24 & 0xFF) << 24;
                    iseed = (int)b;
                    break;
                }
                case 5: {
                    long b;
                    offset = TABLE_OFFSETS[opArr[1]];
                    c = 0L;
                    for (j = 0; j < 32; ++j) {
                        a = (iseed >> j & 1) << ChallengeResponseV10._data(offset, j);
                        b = (long)(~(1 << ChallengeResponseV10._data(offset, j))) & c;
                        c = a | b;
                    }
                    iseed = (int)c;
                }
            }
            if (depth - i <= 1) {
                return iseed;
            }
            a = 0L;
            c = iseed;
            for (j = 0; j < 4; ++j) {
                a = (a ^ c & 0xFFL) * -1640531535L;
                c >>= 8;
            }
            idx = (int)((a ^ a >> 8) >> 16 ^ a ^ a >> 8) & 0xFF;
            iseed *= 69069;
        }
        return iseed;
    }

    private static final int _data(int offset, int idx) throws IOException {
        if (data == null) {
            ChallengeResponseV10.loadData();
        }
        return data[offset + idx] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadData() throws IOException {
        char size = TABLE_OFFSETS[TABLE_OFFSETS.length - 1];
        InputStream stream = ChallengeResponseV10.class.getResourceAsStream(BINARY_DATA);
        if (stream == null) {
            throw new IOException("BINARY_DATA does not seem to exist [/challenge.bin]");
        }
        data = new byte[size];
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(stream);
            if (is.read(data) != size) {
                throw new IllegalStateException("Data too short?");
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private static final boolean _part3Compare(byte[] a, byte[] b) {
        for (int i = 0; i < 16; ++i) {
            if (a[i] == b[i + 4]) continue;
            return false;
        }
        return true;
    }

    private static String _part4Encode(byte[] buffer) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buffer.length; i += 2) {
            int a = ((buffer[i] & 0xFF) << 8) + (buffer[i + 1] & 0xFF);
            sb.append(ENCODE1_LOOKUP.charAt(a >> 11 & 0x1F));
            sb.append('=');
            sb.append(ENCODE2_LOOKUP.charAt(a >> 6 & 0x1F));
            sb.append(ENCODE2_LOOKUP.charAt(a >> 1 & 0x1F));
            sb.append(ENCODE3_LOOKUP.charAt(a & 1));
        }
        return sb.toString();
    }

    private static byte[] _part4Hash(String target, byte[] magicValue, boolean hackSha1) {
        byte[] xor1 = ChallengeResponseV10._part4Xor(target, 54);
        byte[] xor2 = ChallengeResponseV10._part4Xor(target, 92);
        SHA1 sha1 = new SHA1();
        sha1.update(xor1);
        if (hackSha1) {
            sha1.setBitCount(511L);
        }
        sha1.update(magicValue);
        byte[] digest1 = sha1.digest();
        sha1.reset();
        sha1.update(xor2);
        sha1.update(digest1);
        byte[] digest2 = sha1.digest();
        return digest2;
    }

    private static byte[] _part4Xor(String s, int op) {
        int i;
        byte[] arr = new byte[64];
        for (i = 0; i < s.length(); ++i) {
            arr[i] = (byte)(s.charAt(i) ^ op);
        }
        for (i = s.length(); i < arr.length; ++i) {
            arr[i] = (byte)op;
        }
        return arr;
    }

    private static boolean isOperator(char c) {
        return OPERATORS_LOOKUP.indexOf(c) >= 0;
    }
}

