/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flapcmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.flapcmd.SnacCommand;
import org.jetbrains.annotations.Nullable;

public final class SnacPacket
implements LiveWritable {
    private final SnacCommand snacCommand;
    private final int family;
    private final int command;
    private final long reqid;
    private final short flag1;
    private final short flag2;
    private final ByteBlock block;

    static boolean isValidSnacPacket(ByteBlock data) {
        return data.getLength() >= 10;
    }

    @Nullable
    public static SnacPacket readSnacPacket(ByteBlock flapData) {
        if (!SnacPacket.isValidSnacPacket(flapData)) {
            return null;
        }
        int family = BinaryTools.getUShort((ByteBlock)flapData, (int)0);
        int command = BinaryTools.getUShort((ByteBlock)flapData, (int)2);
        short flag1 = BinaryTools.getUByte((ByteBlock)flapData, (int)4);
        short flag2 = BinaryTools.getUByte((ByteBlock)flapData, (int)5);
        long reqid = BinaryTools.getUInt((ByteBlock)flapData, (int)6);
        ByteBlock block = flapData.subBlock(10);
        return new SnacPacket(family, command, reqid, flag1, flag2, block);
    }

    public SnacPacket(int family, int command, long reqid, short flag1, short flag2, ByteBlock data) {
        DefensiveTools.checkRange((int)family, (String)"family", (int)0);
        DefensiveTools.checkRange((int)command, (String)"command", (int)0);
        DefensiveTools.checkRange((long)reqid, (String)"reqid", (long)0L);
        DefensiveTools.checkRange((int)flag1, (String)"flag1", (int)0);
        DefensiveTools.checkRange((int)flag2, (String)"flag2", (int)0);
        DefensiveTools.checkNull((Object)data, (String)"data");
        this.snacCommand = null;
        this.family = family;
        this.command = command;
        this.reqid = reqid;
        this.flag1 = flag1;
        this.flag2 = flag2;
        this.block = data;
    }

    SnacPacket(long reqid, SnacCommand command) {
        DefensiveTools.checkRange((long)reqid, (String)"reqid", (long)0L);
        DefensiveTools.checkNull((Object)command, (String)"command");
        this.snacCommand = command;
        this.family = command.getFamily();
        this.command = command.getCommand();
        this.reqid = reqid;
        this.flag1 = command.getFlag1();
        this.flag2 = command.getFlag2();
        this.block = null;
    }

    public final int getFamily() {
        return this.family;
    }

    public final int getCommand() {
        return this.command;
    }

    public final long getReqid() {
        return this.reqid;
    }

    public final short getFlag1() {
        return this.flag1;
    }

    public final short getFlag2() {
        return this.flag2;
    }

    public final ByteBlock getData() {
        return this.block;
    }

    public void write(OutputStream out) throws IOException {
        BinaryTools.writeUShort((OutputStream)out, (int)this.family);
        BinaryTools.writeUShort((OutputStream)out, (int)this.command);
        BinaryTools.writeUByte((OutputStream)out, (int)this.flag1);
        BinaryTools.writeUByte((OutputStream)out, (int)this.flag2);
        BinaryTools.writeUInt((OutputStream)out, (long)this.reqid);
        if (this.snacCommand != null) {
            this.snacCommand.writeData(out);
        } else if (this.block != null) {
            this.block.write(out);
        }
    }

    public String toString() {
        return "SnacPacket type 0x" + Integer.toHexString(this.family) + "/0x" + Integer.toHexString(this.command) + (this.flag1 == 0 ? "" : ", flag1=0x" + Integer.toHexString(this.flag1)) + (this.flag2 == 0 ? "" : ", flag2=0x" + Integer.toHexString(this.flag2)) + ": " + (this.block == null ? null : this.block.getLength() + " bytes") + " (id=" + this.reqid + ")";
    }
}

