/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.openymsg.network.ServiceType;
import org.openymsg.network.YMSG9Packet;

public class YMSG9InputStream
extends BufferedInputStream {
    public YMSG9InputStream(InputStream inputStream) {
        super(inputStream);
    }

    public YMSG9Packet readPacket() throws IOException {
        YMSG9Packet yMSG9Packet = new YMSG9Packet();
        String string = System.getProperty("openymsg.network.charEncoding", "UTF-8");
        byte[] byArray = new byte[20];
        if (this.readBuffer(byArray) <= 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        yMSG9Packet.magic = stringBuffer.toString();
        yMSG9Packet.version = this.u2i(byArray[5]);
        yMSG9Packet.length = (this.u2i(byArray[8]) << 8) + this.u2i(byArray[9]);
        yMSG9Packet.service = ServiceType.getServiceType((this.u2i(byArray[10]) << 8) + this.u2i(byArray[11]));
        yMSG9Packet.status = (this.u2i(byArray[12]) << 24) + (this.u2i(byArray[13]) << 16) + (this.u2i(byArray[14]) << 8) + this.u2i(byArray[15]);
        yMSG9Packet.sessionId = (this.u2i(byArray[16]) << 24) + (this.u2i(byArray[17]) << 16) + (this.u2i(byArray[18]) << 8) + this.u2i(byArray[19]);
        if (!yMSG9Packet.magic.equals("YMSG")) {
            throw new IOException("Bad YMSG9 header");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        byte[] byArray2 = new byte[yMSG9Packet.length];
        if (this.readBuffer(byArray2) < 0) {
            return null;
        }
        int n = 0;
        boolean bl = true;
        for (int i = 0; i < byArray2.length - 1; ++i) {
            if (this.u2i(byArray2[i]) != 192 || this.u2i(byArray2[i + 1]) != 128) continue;
            String string2 = new String(byArray2, n, i - n, string);
            if (bl) {
                if (this.isKey(string2 = this.cleanse(string2))) {
                    arrayList.add(string2);
                }
            } else {
                arrayList.add(string2);
            }
            bl = !bl;
            n = ++i + 1;
        }
        if (arrayList.size() % 2 != 0) {
            arrayList.remove(arrayList.size() - 1);
        }
        yMSG9Packet.body = new String[arrayList.size()];
        yMSG9Packet.body = arrayList.toArray(yMSG9Packet.body);
        return yMSG9Packet;
    }

    private int u2i(byte by) {
        return by & 0xFF;
    }

    private String cleanse(String string) {
        while (string.length() > 0 && (string.charAt(0) == '\u0000' || string.charAt(0) > '\u007f')) {
            string = string.substring(1);
        }
        return string;
    }

    private boolean isKey(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return string.length() <= 5;
    }

    private int readBuffer(byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        for (n = 0; n < byArray.length; n += n2) {
            n2 = super.read(byArray, n, byArray.length - n);
            if (n2 >= 0) continue;
            return (n + 1) * -1;
        }
        return n;
    }
}

