/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Collector;
import org.apache.jasper.compiler.ELFunctionMapper;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.ScriptingVariabler;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SmapUtil;
import org.apache.jasper.compiler.TagFileProcessor;
import org.apache.jasper.compiler.TextOptimizer;
import org.apache.jasper.compiler.Validator;
import org.apache.jasper.servlet.JspServletWrapper;
import org.apache.jasper.util.SystemLogHandler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;

public class Compiler {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$jasper$compiler$Compiler == null ? (class$org$apache$jasper$compiler$Compiler = Compiler.class$("org.apache.jasper.compiler.Compiler")) : class$org$apache$jasper$compiler$Compiler));
    static Object javacLock = new Object();
    protected JspCompilationContext ctxt;
    private ErrorDispatcher errDispatcher;
    private PageInfo pageInfo;
    private JspServletWrapper jsw;
    private JasperAntLogger logger;
    private TagFileProcessor tfp;
    protected Project project = null;
    protected Options options;
    protected Node.Nodes pageNodes;
    static /* synthetic */ Class class$org$apache$jasper$compiler$Compiler;

    public Compiler(JspCompilationContext ctxt) {
        this(ctxt, null);
    }

    public Compiler(JspCompilationContext ctxt, JspServletWrapper jsw) {
        this.jsw = jsw;
        this.ctxt = ctxt;
        this.options = ctxt.getOptions();
    }

    private Project getProject() {
        if (this.project != null) {
            return this.project;
        }
        this.project = new Project();
        this.logger = new JasperAntLogger();
        this.logger.setOutputPrintStream(System.out);
        this.logger.setErrorPrintStream(System.err);
        this.logger.setMessageOutputLevel(2);
        this.project.addBuildListener((BuildListener)this.logger);
        if (System.getProperty("catalina.home") != null) {
            this.project.setBasedir(System.getProperty("catalina.home"));
        }
        if (this.options.getCompiler() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Compiler " + this.options.getCompiler()));
            }
            this.project.setProperty("build.compiler", this.options.getCompiler());
        }
        this.project.init();
        return this.project;
    }

    /*
     * Unable to fully structure code
     */
    private String[] generateJava() throws Exception {
        block22: {
            block19: {
                block20: {
                    smapStr = null;
                    t1 = System.currentTimeMillis();
                    this.pageInfo = new PageInfo(new BeanRepository(this.ctxt.getClassLoader(), this.errDispatcher));
                    jspConfig = this.options.getJspConfig();
                    jspProperty = jspConfig.findJspProperty(this.ctxt.getJspFile());
                    this.pageInfo.setELIgnored(JspUtil.booleanValue(jspProperty.isELIgnored()));
                    this.pageInfo.setScriptingInvalid(JspUtil.booleanValue(jspProperty.isScriptingInvalid()));
                    if (jspProperty.getIncludePrelude() != null) {
                        this.pageInfo.setIncludePrelude(jspProperty.getIncludePrelude());
                    }
                    if (jspProperty.getIncludeCoda() != null) {
                        this.pageInfo.setIncludeCoda(jspProperty.getIncludeCoda());
                    }
                    javaFileName = this.ctxt.getServletJavaFileName();
                    writer = null;
                    javaEncoding = this.ctxt.getOptions().getJavaEncoding();
                    osw = null;
                    try {
                        osw = new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding);
                    }
                    catch (UnsupportedEncodingException ex) {
                        this.errDispatcher.jspError("jsp.error.needAlternateJavaEncoding", javaEncoding);
                    }
                    writer = new ServletWriter(new PrintWriter(osw));
                    this.ctxt.setWriter(writer);
                    JspUtil.resetTemporaryVariableName();
                    parserCtl = new ParserController(this.ctxt, this);
                    this.pageNodes = parserCtl.parse(this.ctxt.getJspFile());
                    if (!this.ctxt.isPrototypeMode()) break block19;
                    Generator.generate(writer, this, this.pageNodes);
                    writer.close();
                    writer = null;
                    var11_13 = null;
                    var19_15 = null;
                    if (writer == null) break block20;
                    try {
                        writer.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                return var11_13;
            }
            try {
                block21: {
                    Validator.validate(this, this.pageNodes);
                    t2 = System.currentTimeMillis();
                    Collector.collect(this, this.pageNodes);
                    this.tfp = new TagFileProcessor();
                    this.tfp.loadTagFiles(this, this.pageNodes);
                    t3 = System.currentTimeMillis();
                    ScriptingVariabler.set(this.pageNodes, this.errDispatcher);
                    tagPluginManager = this.options.getTagPluginManager();
                    tagPluginManager.apply(this.pageNodes, this.errDispatcher, this.pageInfo);
                    TextOptimizer.concatenate(this, this.pageNodes);
                    ELFunctionMapper.map(this, this.pageNodes);
                    Generator.generate(writer, this, this.pageNodes);
                    writer.close();
                    writer = null;
                    this.ctxt.setWriter(null);
                    t4 = System.currentTimeMillis();
                    if (t4 - t1 <= 500L) break block21;
                    Compiler.log.debug((Object)("Generated " + javaFileName + " total=" + (t4 - t1) + " generate=" + (t4 - t3) + " validate=" + (t2 - t1)));
                }
                var19_16 = null;
                ** if (writer == null) goto lbl-1000
            }
            catch (Throwable var18_24) {
                var19_17 = null;
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                throw var18_24;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    writer.close();
                }
                catch (Exception e2) {}
            }
lbl-1000:
            // 2 sources

            {
                break block22;
                catch (Exception e) {
                    if (writer != null) {
                        try {
                            writer.close();
                            writer = null;
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    new File(javaFileName).delete();
                    throw e;
                }
            }
        }
        if (!this.options.isSmapSuppressed()) {
            smapStr = SmapUtil.generateSmap(this.ctxt, this.pageNodes);
        }
        this.tfp.removeProtoTypeFiles(this.ctxt.getClassFileName());
        return smapStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateClass(String[] smap) throws FileNotFoundException, JasperException, Exception {
        long t2;
        BuildException be;
        StringBuffer errorReport;
        String javaFileName;
        long t1;
        block18: {
            t1 = System.currentTimeMillis();
            String javaEncoding = this.ctxt.getOptions().getJavaEncoding();
            javaFileName = this.ctxt.getServletJavaFileName();
            String classpath = this.ctxt.getClassPath();
            String sep = System.getProperty("path.separator");
            errorReport = new StringBuffer();
            StringBuffer info = new StringBuffer();
            info.append("Compile: javaFileName=" + javaFileName + "\n");
            info.append("    classpath=" + classpath + "\n");
            SystemLogHandler.setThread();
            this.getProject();
            Javac javac = (Javac)this.project.createTask("javac");
            Path path = new Path(this.project);
            path.setPath(System.getProperty("java.class.path"));
            info.append("    cp=" + System.getProperty("java.class.path") + "\n");
            StringTokenizer tokenizer = new StringTokenizer(classpath, sep);
            while (tokenizer.hasMoreElements()) {
                String pathElement = tokenizer.nextToken();
                File repository = new File(pathElement);
                path.setLocation(repository);
                info.append("    cp=" + repository + "\n");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using classpath: " + System.getProperty("java.class.path") + sep + classpath));
            }
            Path srcPath = new Path(this.project);
            srcPath.setLocation(this.options.getScratchDir());
            info.append("    work dir=" + this.options.getScratchDir() + "\n");
            String exts = System.getProperty("java.ext.dirs");
            if (exts != null) {
                Path extdirs = new Path(this.project);
                extdirs.setPath(exts);
                javac.setExtdirs(extdirs);
                info.append("    extension dir=" + exts + "\n");
            }
            javac.setEncoding(javaEncoding);
            javac.setClasspath(path);
            javac.setDebug(this.ctxt.getOptions().getClassDebugInfo());
            javac.setSrcdir(srcPath);
            javac.setOptimize(!this.ctxt.getOptions().getClassDebugInfo());
            javac.setFork(this.ctxt.getOptions().getFork());
            info.append("    srcDir=" + srcPath + "\n");
            if (this.options.getCompiler() != null) {
                javac.setCompiler(this.options.getCompiler());
                info.append("    compiler=" + this.options.getCompiler() + "\n");
            }
            PatternSet.NameEntry includes = javac.createInclude();
            includes.setName(this.ctxt.getJavaPath());
            info.append("    include=" + this.ctxt.getJavaPath() + "\n");
            be = null;
            try {
                if (this.ctxt.getOptions().getFork()) {
                    javac.execute();
                    break block18;
                }
                Object object = javacLock;
                synchronized (object) {
                    javac.execute();
                }
            }
            catch (BuildException e) {
                be = e;
                log.error((Object)"Javac exception ", (Throwable)e);
                log.error((Object)("Env: " + info.toString()));
            }
        }
        errorReport.append(this.logger.getReport());
        String errorCapture = SystemLogHandler.unsetThread();
        if (errorCapture != null) {
            errorReport.append(System.getProperty("line.separator"));
            errorReport.append(errorCapture);
        }
        if (!this.ctxt.keepGenerated()) {
            File javaFile = new File(javaFileName);
            javaFile.delete();
        }
        if (be != null) {
            String errorReportString = errorReport.toString();
            log.error((Object)("Error compiling file: " + javaFileName + " " + errorReportString));
            JavacErrorDetail[] javacErrors = ErrorDispatcher.parseJavacErrors(errorReportString, javaFileName, this.pageNodes);
            if (javacErrors != null) {
                this.errDispatcher.javacError(javacErrors);
            } else {
                this.errDispatcher.javacError(errorReportString, (Exception)((Object)be));
            }
        }
        if ((t2 = System.currentTimeMillis()) - t1 > 500L) {
            log.debug((Object)("Compiled " + javaFileName + " " + (t2 - t1)));
        }
        if (this.ctxt.isPrototypeMode()) {
            return;
        }
        if (!this.options.isSmapSuppressed()) {
            SmapUtil.installSmap(smap);
        }
    }

    public void compile() throws FileNotFoundException, JasperException, Exception {
        this.compile(true);
    }

    public void compile(boolean compileClass) throws FileNotFoundException, JasperException, Exception {
        this.compile(compileClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compile(boolean compileClass, boolean jspcMode) throws FileNotFoundException, JasperException, Exception {
        if (this.errDispatcher == null) {
            this.errDispatcher = new ErrorDispatcher(jspcMode);
        }
        try {
            String[] smap = this.generateJava();
            if (compileClass) {
                this.generateClass(smap);
            }
            Object var5_4 = null;
            if (this.tfp != null) {
                this.tfp.removeProtoTypeFiles(null);
            }
            this.tfp = null;
            this.errDispatcher = null;
            this.logger = null;
            this.project = null;
            this.pageInfo = null;
            this.pageNodes = null;
            if (this.ctxt.getWriter() == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.tfp != null) {
                this.tfp.removeProtoTypeFiles(null);
            }
            this.tfp = null;
            this.errDispatcher = null;
            this.logger = null;
            this.project = null;
            this.pageInfo = null;
            this.pageNodes = null;
            if (this.ctxt.getWriter() == null) throw throwable;
            this.ctxt.getWriter().close();
            this.ctxt.setWriter(null);
            throw throwable;
        }
        this.ctxt.getWriter().close();
        this.ctxt.setWriter(null);
    }

    public boolean isOutDated() {
        return this.isOutDated(true);
    }

    public boolean isOutDated(boolean checkClass) {
        boolean outDated = false;
        String jsp = this.ctxt.getJspFile();
        long jspRealLastModified = 0L;
        try {
            URL jspUrl = this.ctxt.getResource(jsp);
            if (jspUrl == null) {
                this.ctxt.incrementRemoved();
                return false;
            }
            URLConnection uc = jspUrl.openConnection();
            jspRealLastModified = uc.getLastModified();
            uc.getInputStream().close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        long targetLastModified = 0L;
        File targetFile = checkClass ? new File(this.ctxt.getClassFileName()) : new File(this.ctxt.getServletJavaFileName());
        if (!targetFile.exists()) {
            outDated = true;
        } else {
            targetLastModified = targetFile.lastModified();
            if (checkClass && this.jsw != null) {
                this.jsw.setServletClassLastModifiedTime(targetLastModified);
            }
            if (targetLastModified < jspRealLastModified) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Compiler: outdated: " + targetFile + " " + targetLastModified));
                }
                outDated = true;
            }
        }
        if (this.jsw == null) {
            return outDated;
        }
        List depends = this.jsw.getDependants();
        if (depends == null) {
            return outDated;
        }
        Iterator it = depends.iterator();
        while (it.hasNext()) {
            String include = (String)it.next();
            try {
                URL includeUrl = this.ctxt.getResource(include);
                if (includeUrl == null) {
                    outDated = true;
                }
                if (!outDated) {
                    URLConnection includeUconn = includeUrl.openConnection();
                    long includeLastModified = includeUconn.getLastModified();
                    includeUconn.getInputStream().close();
                    if (includeLastModified > targetLastModified) {
                        outDated = true;
                    }
                }
                if (!outDated) continue;
                this.ctxt.getRuntimeContext().removeWrapper(include);
            }
            catch (Exception e) {
                e.printStackTrace();
                outDated = true;
            }
        }
        return outDated;
    }

    public ErrorDispatcher getErrorDispatcher() {
        return this.errDispatcher;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public JspCompilationContext getCompilationContext() {
        return this.ctxt;
    }

    public void removeGeneratedFiles() {
        try {
            String classFileName = this.ctxt.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting " + classFile));
                }
                classFile.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String javaFileName = this.ctxt.getServletJavaFileName();
            if (javaFileName != null) {
                File javaFile = new File(javaFileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting " + javaFile));
                }
                javaFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeGeneratedClassFiles() {
        try {
            String classFileName = this.ctxt.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting " + classFile));
                }
                classFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class JasperAntLogger
    extends DefaultLogger {
        private StringBuffer reportBuf = new StringBuffer();

        JasperAntLogger() {
        }

        protected void printMessage(String message, PrintStream stream, int priority) {
        }

        protected void log(String message) {
            this.reportBuf.append(message);
            this.reportBuf.append(System.getProperty("line.separator"));
        }

        protected String getReport() {
            String report = this.reportBuf.toString();
            this.reportBuf.setLength(0);
            return report;
        }
    }
}

