/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import com.reardencommerce.kernel.collections.shared.evictable.ConcurrentLinkedHashMap;
import gnu.inet.encoding.IDNA;
import gnu.inet.encoding.Stringprep;
import gnu.inet.encoding.StringprepException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.Immutable;
import org.xmpp.util.ValueWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class JID
implements Comparable<JID>,
Serializable {
    private static final long serialVersionUID = 8135170608402192877L;
    private static final ConcurrentMap<String, ValueWrapper<String>> NODEPREP_CACHE = ConcurrentLinkedHashMap.create(ConcurrentLinkedHashMap.EvictionPolicy.SECOND_CHANCE, 10000);
    private static final ConcurrentMap<String, ValueWrapper<String>> DOMAINPREP_CACHE = ConcurrentLinkedHashMap.create(ConcurrentLinkedHashMap.EvictionPolicy.SECOND_CHANCE, 500);
    private static final ConcurrentMap<String, ValueWrapper<String>> RESOURCEPREP_CACHE = ConcurrentLinkedHashMap.create(ConcurrentLinkedHashMap.EvictionPolicy.SECOND_CHANCE, 10000);
    private final String node;
    private final String domain;
    private final String resource;
    private final String cachedFullJID;
    private final String cachedBareJID;

    public static String escapeNode(String node) {
        if (node == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(node.length() + 8);
        int i = 0;
        int n = node.length();
        while (i < n) {
            char c = node.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("\\22");
                    break;
                }
                case '&': {
                    buf.append("\\26");
                    break;
                }
                case '\'': {
                    buf.append("\\27");
                    break;
                }
                case '/': {
                    buf.append("\\2f");
                    break;
                }
                case ':': {
                    buf.append("\\3a");
                    break;
                }
                case '<': {
                    buf.append("\\3c");
                    break;
                }
                case '>': {
                    buf.append("\\3e");
                    break;
                }
                case '@': {
                    buf.append("\\40");
                    break;
                }
                case '\\': {
                    buf.append("\\5c");
                    break;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        buf.append("\\20");
                        break;
                    }
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String unescapeNode(String node) {
        if (node == null) {
            return null;
        }
        nodeChars = node.toCharArray();
        buf = new StringBuilder(nodeChars.length);
        i = 0;
        n = nodeChars.length;
        while (i < n) {
            block17: {
                block19: {
                    block18: {
                        block16: {
                            c = node.charAt(i);
                            if (c != '\\' || i + 2 >= n) ** GOTO lbl-1000
                            c2 = nodeChars[i + 1];
                            c3 = nodeChars[i + 2];
                            if (c2 != '2') break block16;
                            switch (c3) {
                                case '0': {
                                    buf.append(' ');
                                    i += 2;
                                    break block17;
                                }
                                case '2': {
                                    buf.append('\"');
                                    i += 2;
                                    break block17;
                                }
                                case '6': {
                                    buf.append('&');
                                    i += 2;
                                    break block17;
                                }
                                case '7': {
                                    buf.append('\'');
                                    i += 2;
                                    break block17;
                                }
                                case 'f': {
                                    buf.append('/');
                                    i += 2;
                                    break block17;
                                }
                            }
                            ** GOTO lbl-1000
                        }
                        if (c2 != '3') break block18;
                        switch (c3) {
                            case 'a': {
                                buf.append(':');
                                i += 2;
                                break block17;
                            }
                            case 'c': {
                                buf.append('<');
                                i += 2;
                                break block17;
                            }
                            case 'e': {
                                buf.append('>');
                                i += 2;
                                break block17;
                            }
                        }
                        ** GOTO lbl-1000
                    }
                    if (c2 != '4') break block19;
                    if (c3 != '0') ** GOTO lbl-1000
                    buf.append("@");
                    i += 2;
                    break block17;
                }
                if (c2 == '5' && c3 == 'c') {
                    buf.append("\\");
                    i += 2;
                } else lbl-1000:
                // 5 sources

                {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String nodeprep(String node) {
        String answer;
        if (node == null) {
            return null;
        }
        ValueWrapper cachedResult = (ValueWrapper)NODEPREP_CACHE.get(node);
        if (cachedResult == null) {
            try {
                answer = Stringprep.nodeprep((String)node);
                if (answer != null && answer.getBytes("UTF-8").length > 1023) {
                    throw new IllegalArgumentException("Node cannot be larger than 1023 bytes. Size is " + answer.getBytes("UTF-8").length + " bytes.");
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException("Unable to construct a JID node.", ex);
            }
            catch (Exception ex) {
                NODEPREP_CACHE.put(node, new ValueWrapper(ValueWrapper.Representation.ILLEGAL));
                throw new IllegalArgumentException("The input is not a valid JID node: " + node, ex);
            }
            NODEPREP_CACHE.put(answer, new ValueWrapper(ValueWrapper.Representation.USE_KEY));
            if (!node.equals(answer)) {
                NODEPREP_CACHE.put(node, new ValueWrapper<String>(answer));
            }
        } else {
            switch (cachedResult.getRepresentation()) {
                case USE_KEY: {
                    answer = node;
                    break;
                }
                case USE_VALUE: {
                    answer = (String)cachedResult.getValue();
                    break;
                }
                case ILLEGAL: {
                    throw new IllegalArgumentException("The input is not a valid JID node: " + node);
                }
                default: {
                    throw new IllegalStateException("The implementation of JID#nodeprep(String) is broken.");
                }
            }
        }
        return answer;
    }

    public static String domainprep(String domain) throws StringprepException {
        String answer;
        if (domain == null) {
            throw new IllegalArgumentException("Argument 'domain' cannot be null.");
        }
        ValueWrapper cachedResult = (ValueWrapper)DOMAINPREP_CACHE.get(domain);
        if (cachedResult == null) {
            try {
                answer = Stringprep.nameprep((String)IDNA.toASCII((String)domain), (boolean)false);
                if (answer != null && answer.getBytes("UTF-8").length > 1023) {
                    throw new IllegalArgumentException("Domain cannot be larger than 1023 bytes. Size is " + answer.getBytes("UTF-8").length + " bytes.");
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException("Unable to construct a JID domain.", ex);
            }
            catch (Exception ex) {
                DOMAINPREP_CACHE.put(domain, new ValueWrapper(ValueWrapper.Representation.ILLEGAL));
                throw new IllegalArgumentException("The input is not a valid JID domain part: " + domain, ex);
            }
            DOMAINPREP_CACHE.put(answer, new ValueWrapper(ValueWrapper.Representation.USE_KEY));
            if (!domain.equals(answer)) {
                DOMAINPREP_CACHE.put(domain, new ValueWrapper<String>(answer));
            }
        } else {
            switch (cachedResult.getRepresentation()) {
                case USE_KEY: {
                    answer = domain;
                    break;
                }
                case USE_VALUE: {
                    answer = (String)cachedResult.getValue();
                    break;
                }
                case ILLEGAL: {
                    throw new IllegalArgumentException("The input is not a valid JID domain part: " + domain);
                }
                default: {
                    throw new IllegalStateException("The implementation of JID#domainprep(String) is broken.");
                }
            }
        }
        return answer;
    }

    public static String resourceprep(String resource) throws StringprepException {
        String answer;
        if (resource == null) {
            return null;
        }
        ValueWrapper cachedResult = (ValueWrapper)RESOURCEPREP_CACHE.get(resource);
        if (cachedResult == null) {
            try {
                answer = Stringprep.resourceprep((String)resource);
                if (answer != null && answer.getBytes("UTF-8").length > 1023) {
                    throw new IllegalArgumentException("Resource cannot be larger than 1023 bytes. Size is " + answer.getBytes("UTF-8").length + " bytes.");
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException("Unable to construct a JID resource.", ex);
            }
            catch (Exception ex) {
                RESOURCEPREP_CACHE.put(resource, new ValueWrapper(ValueWrapper.Representation.ILLEGAL));
                throw new IllegalArgumentException("The input is not a valid JID resource: " + resource, ex);
            }
            RESOURCEPREP_CACHE.put(answer, new ValueWrapper(ValueWrapper.Representation.USE_KEY));
            if (!resource.equals(answer)) {
                RESOURCEPREP_CACHE.put(resource, new ValueWrapper<String>(answer));
            }
        } else {
            switch (cachedResult.getRepresentation()) {
                case USE_KEY: {
                    answer = resource;
                    break;
                }
                case USE_VALUE: {
                    answer = (String)cachedResult.getValue();
                    break;
                }
                case ILLEGAL: {
                    throw new IllegalArgumentException("The input is not a valid JID resource part: " + resource);
                }
                default: {
                    throw new IllegalStateException("The implementation of JID#resourceprep(String) is broken.");
                }
            }
        }
        return answer;
    }

    public JID(String jid) {
        this(JID.getParts(jid), false);
    }

    public JID(String jid, boolean skipStringPrep) {
        this(JID.getParts(jid), skipStringPrep);
    }

    private JID(String[] parts, boolean skipStringPrep) {
        this(parts[0], parts[1], parts[2], skipStringPrep);
    }

    public JID(String node, String domain, String resource) {
        this(node, domain, resource, false);
    }

    public JID(String node, String domain, String resource, boolean skipStringprep) {
        if (domain == null) {
            throw new NullPointerException("Domain cannot be null");
        }
        if (skipStringprep) {
            this.node = node;
            this.domain = domain;
            this.resource = resource;
        } else {
            if (node != null && node.equals("")) {
                node = null;
            }
            if (resource != null && resource.equals("")) {
                resource = null;
            }
            try {
                this.node = JID.nodeprep(node);
                this.domain = JID.domainprep(domain);
                this.resource = JID.resourceprep(resource);
            }
            catch (Exception e) {
                StringBuilder buf = new StringBuilder();
                if (node != null) {
                    buf.append(node).append("@");
                }
                buf.append(domain);
                if (resource != null) {
                    buf.append("/").append(resource);
                }
                throw new IllegalArgumentException("Illegal JID: " + buf.toString(), e);
            }
        }
        StringBuilder buf = new StringBuilder(40);
        if (this.node != null) {
            buf.append(this.node).append("@");
        }
        buf.append(this.domain);
        this.cachedBareJID = buf.toString();
        if (this.resource != null) {
            buf.append("/").append(this.resource);
            this.cachedFullJID = buf.toString();
        } else {
            this.cachedFullJID = this.cachedBareJID;
        }
    }

    static String[] getParts(String jid) {
        String[] parts = new String[3];
        String node = null;
        if (jid == null) {
            return parts;
        }
        int atIndex = jid.indexOf("@");
        int slashIndex = jid.indexOf("/");
        if (atIndex > 0) {
            node = jid.substring(0, atIndex);
        }
        if (atIndex + 1 > jid.length()) {
            throw new IllegalArgumentException("JID with empty domain not valid");
        }
        String domain = atIndex < 0 ? (slashIndex > 0 ? jid.substring(0, slashIndex) : jid) : (slashIndex > 0 ? jid.substring(atIndex + 1, slashIndex) : jid.substring(atIndex + 1));
        String resource = slashIndex + 1 > jid.length() || slashIndex < 0 ? null : jid.substring(slashIndex + 1);
        parts[0] = node;
        parts[1] = domain;
        parts[2] = resource;
        return parts;
    }

    public String getNode() {
        return this.node;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getResource() {
        return this.resource;
    }

    public String toBareJID() {
        return this.cachedBareJID;
    }

    public String toFullJID() {
        if (this.resource == null) {
            throw new IllegalStateException("This JID was instantiated without a resource identifier. A full JID representation is not available for: " + this.toString());
        }
        return this.cachedFullJID;
    }

    public String toString() {
        return this.cachedFullJID;
    }

    public int hashCode() {
        return this.cachedFullJID.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JID)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        JID jid = (JID)object;
        if (this.node != null ? !this.node.equals(jid.node) : jid.node != null) {
            return false;
        }
        if (!this.domain.equals(jid.domain)) {
            return false;
        }
        return !(this.resource != null ? !this.resource.equals(jid.resource) : jid.resource != null);
    }

    @Override
    public int compareTo(JID jid) {
        int compare = this.domain.compareTo(jid.domain);
        if (compare == 0) {
            String myNode = this.node != null ? this.node : "";
            String hisNode = jid.node != null ? jid.node : "";
            compare = myNode.compareTo(hisNode);
        }
        if (compare == 0) {
            String myResource = this.resource != null ? this.resource : "";
            String hisResource = jid.resource != null ? jid.resource : "";
            compare = myResource.compareTo(hisResource);
        }
        return compare;
    }

    public static boolean equals(String jid1, String jid2) {
        return new JID(jid1).equals(new JID(jid2));
    }
}

