/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class ClientInvocation {
    private final NodeEngine nodeEngine;
    private final Operation op;
    private final String serviceName;
    private final Address target;
    private final int partitionId;
    private final int replicaIndex;
    private final ClientEndpoint endpoint;

    ClientInvocation(NodeEngine nodeEngine, Operation op, String serviceName, int partitionId, int replicaIndex, ClientEndpoint endpoint) {
        this.nodeEngine = nodeEngine;
        this.op = op;
        this.serviceName = serviceName;
        this.partitionId = partitionId;
        this.replicaIndex = replicaIndex;
        this.endpoint = endpoint;
        this.target = null;
    }

    ClientInvocation(NodeEngine nodeEngine, Operation operation, String serviceName, Address target, ClientEndpoint endpoint) {
        this.nodeEngine = nodeEngine;
        this.op = operation;
        this.serviceName = serviceName;
        this.target = target;
        this.endpoint = endpoint;
        this.partitionId = -1;
        this.replicaIndex = 0;
    }

    public Object invoke() throws InterruptedException, ExecutionException, TimeoutException {
        this.op.setCallerUuid(this.endpoint.getUuid());
        InvocationBuilder builder = this.target == null ? this.nodeEngine.getOperationService().createInvocationBuilder(this.serviceName, this.op, this.partitionId).setReplicaIndex(this.replicaIndex) : this.nodeEngine.getOperationService().createInvocationBuilder(this.serviceName, this.op, this.target);
        builder.setTryCount(100).setCallTimeout(20000L);
        Invocation inv = builder.build();
        Future f = inv.invoke();
        return f.get(30L, TimeUnit.SECONDS);
    }
}

