/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ChangePrefixMapping;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.Comment;
import weblogic.xml.stream.EndDocument;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.EndPrefixMapping;
import weblogic.xml.stream.EntityReference;
import weblogic.xml.stream.ProcessingInstruction;
import weblogic.xml.stream.Space;
import weblogic.xml.stream.StartDocument;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.StartPrefixMapping;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.AttributeImpl;
import weblogic.xml.stream.events.ChangePrefixMappingEvent;
import weblogic.xml.stream.events.CharacterDataEvent;
import weblogic.xml.stream.events.CommentEvent;
import weblogic.xml.stream.events.ElementTypeNames;
import weblogic.xml.stream.events.EndDocumentEvent;
import weblogic.xml.stream.events.EndElementEvent;
import weblogic.xml.stream.events.EndPrefixMappingEvent;
import weblogic.xml.stream.events.Name;
import weblogic.xml.stream.events.ProcessingInstructionEvent;
import weblogic.xml.stream.events.SpaceEvent;
import weblogic.xml.stream.events.StartDocumentEvent;
import weblogic.xml.stream.events.StartElementEvent;
import weblogic.xml.stream.events.StartPrefixMappingEvent;

public class XMLEventReader {
    protected Reader reader;
    protected char currentChar;
    protected int currentLine = 0;

    public XMLEventReader() {
    }

    public XMLEventReader(Reader reader) throws IOException {
        this.setReader(reader);
    }

    public void setReader(Reader reader) throws IOException {
        this.reader = reader;
        this.read();
        this.skipSpace();
    }

    protected String readString(char c) throws IOException, XMLStreamException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.getChar() != c) {
            if (this.getChar() == '[' && c == ']') {
                this.read();
                stringBuffer.append('[');
                if (this.getChar() != ']') {
                    stringBuffer.append(this.readString(']'));
                }
                stringBuffer.append(']');
                this.read(']');
                continue;
            }
            stringBuffer.append(this.getChar());
            this.read();
        }
        return stringBuffer.toString();
    }

    protected char getChar() {
        return this.currentChar;
    }

    protected void skipSpace() throws IOException {
        while (this.currentChar == ' ' | this.currentChar == '\n' | this.currentChar == '\t' | this.currentChar == '\r') {
            this.read();
        }
    }

    protected char read() throws IOException {
        this.currentChar = (char)this.reader.read();
        if (this.currentChar == '\n') {
            ++this.currentLine;
        }
        return this.currentChar;
    }

    protected char read(char c) throws XMLStreamException, IOException {
        if (this.currentChar == c) {
            return this.read();
        }
        throw new XMLStreamException("Unexpected character '" + this.currentChar + "' , expected '" + c + "' at line " + this.currentLine);
    }

    protected void read(String string) throws XMLStreamException, IOException {
        int n = 0;
        while (n < string.length()) {
            this.read(string.charAt(n));
            ++n;
        }
    }

    protected int readType() throws XMLStreamException, IOException {
        this.read('[');
        String string = this.readString(']');
        int n = ElementTypeNames.getType((String)string);
        this.read(']');
        return n;
    }

    public StartElement readStartElement() throws XMLStreamException, IOException {
        this.read('[');
        XMLName xMLName = this.readName();
        StartElementEvent startElementEvent = new StartElementEvent(xMLName);
        this.read("][");
        List list = this.readAttributes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            startElementEvent.addAttribute((Attribute)iterator.next());
        }
        this.read(']');
        return startElementEvent;
    }

    public EndElement readEndElement() throws XMLStreamException, IOException {
        this.read('[');
        EndElementEvent endElementEvent = new EndElementEvent(this.readName());
        this.read(']');
        return endElementEvent;
    }

    public ProcessingInstruction readProcessingInstruction() throws XMLStreamException, IOException {
        this.read('[');
        String string = this.readString(']');
        this.read(']');
        String string2 = null;
        if (this.getChar() == ',') {
            this.read(",[");
            string2 = this.readString(']');
            this.read(']');
        }
        return new ProcessingInstructionEvent((XMLName)new Name(string), string2);
    }

    public CharacterData readCharacterData() throws XMLStreamException, IOException {
        this.read('[');
        CharacterDataEvent characterDataEvent = new CharacterDataEvent(this.readString(']'));
        this.read(']');
        return characterDataEvent;
    }

    public StartDocument readStartDocument() throws XMLStreamException, IOException {
        if (this.getChar() != ';') {
            this.read('[');
            String string = this.readString(']');
            this.read(']');
            this.read(',');
            this.read('[');
            String string2 = this.readString(']');
            this.read(']');
            this.read(',');
            this.read('[');
            String string3 = this.readString(']');
            this.read(']');
            StartDocumentEvent startDocumentEvent = new StartDocumentEvent();
            startDocumentEvent.setVersion(string);
            startDocumentEvent.setEncoding(string2);
            startDocumentEvent.setStandalone(string3);
            return startDocumentEvent;
        }
        return new StartDocumentEvent();
    }

    public EndDocument readEndDocument() throws XMLStreamException {
        return new EndDocumentEvent();
    }

    public Comment readComment() throws XMLStreamException, IOException {
        this.read('[');
        CommentEvent commentEvent = new CommentEvent(this.readString(']'));
        this.read(']');
        return commentEvent;
    }

    public StartPrefixMapping readStartPrefixMapping() throws XMLStreamException, IOException {
        this.read('[');
        String string = this.readString(',');
        this.read(',');
        String string2 = this.readString(']');
        this.read(']');
        return new StartPrefixMappingEvent(string, string2);
    }

    public ChangePrefixMapping readChangePrefixMapping() throws XMLStreamException, IOException {
        this.read('[');
        this.read('[');
        String string = this.readString(',');
        this.read(',');
        String string2 = this.readString(']');
        this.read(']');
        this.read(',');
        this.read('[');
        this.readString(',');
        this.read(',');
        String string3 = this.readString(']');
        this.read(']');
        this.read(']');
        return new ChangePrefixMappingEvent(string2, string3, string);
    }

    public EndPrefixMapping readEndPrefixMapping() throws XMLStreamException, IOException {
        this.read('[');
        String string = this.readString(']');
        this.read(']');
        return new EndPrefixMappingEvent(string);
    }

    public String getPrefix(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public String getName(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public XMLName readName() throws XMLStreamException, IOException {
        return this.readName(']');
    }

    public XMLName readName(char c) throws XMLStreamException, IOException {
        String string = null;
        String string2 = null;
        if (this.getChar() == '[') {
            this.read();
            this.read('\'');
            string = this.readString('\'');
            this.read('\'');
            this.read(']');
            this.read(':');
        }
        String string3 = this.readString(c);
        string2 = this.getPrefix(string3);
        String string4 = this.getName(string3);
        return new Name(string, string4, string2);
    }

    public List readAttributes() throws XMLStreamException, IOException {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        while (this.getChar() == ' ') {
            this.read();
            arrayList.add(this.readAttribute());
        }
        return arrayList;
    }

    public Attribute readAttribute() throws XMLStreamException, IOException {
        this.read('[');
        XMLName xMLName = this.readName(',');
        this.read(",");
        String string = this.readString(']');
        this.read(']');
        return new AttributeImpl(xMLName, string, "CDATA");
    }

    public EntityReference readEntityReference() throws XMLStreamException, IOException {
        this.read('[');
        this.readString(']');
        this.read(']');
        return null;
    }

    public Space readSpace() throws XMLStreamException, IOException {
        this.read('[');
        String string = this.readString(']');
        this.read(']');
        return new SpaceEvent(string);
    }

    public XMLEvent readElement() throws XMLStreamException, IOException {
        StartElement startElement;
        int n = this.readType();
        switch (n) {
            case 2: {
                startElement = this.readStartElement();
                break;
            }
            case 4: {
                startElement = this.readEndElement();
                break;
            }
            case 8: {
                startElement = this.readProcessingInstruction();
                break;
            }
            case 16: {
                startElement = this.readCharacterData();
                break;
            }
            case 32: {
                startElement = this.readComment();
                break;
            }
            case 256: {
                startElement = this.readStartDocument();
                break;
            }
            case 512: {
                startElement = this.readEndDocument();
                break;
            }
            case 1024: {
                startElement = this.readStartPrefixMapping();
                break;
            }
            case 2048: {
                startElement = this.readEndPrefixMapping();
                break;
            }
            case 4096: {
                startElement = this.readChangePrefixMapping();
                break;
            }
            case 8192: {
                startElement = this.readEntityReference();
                break;
            }
            case 64: {
                startElement = this.readSpace();
                break;
            }
            case 128: {
                throw new XMLStreamException("Attempt to read a null element.");
            }
            default: {
                throw new XMLStreamException("Attempt to read unknown element [" + n + "]");
            }
        }
        this.read(';');
        this.skipSpace();
        return startElement;
    }

    public boolean hasNext() throws IOException {
        return this.reader.ready();
    }

    public static void main(String[] stringArray) throws Exception {
        XMLEventReader xMLEventReader = new XMLEventReader(new FileReader(stringArray[0]));
        while (xMLEventReader.hasNext()) {
            System.out.print(xMLEventReader.readElement());
        }
    }
}

