/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.ProgressStatusProvider;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.Transferrer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StreamInfo;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTransferrer
implements Transferrer,
ProgressStatusProvider {
    private static final Logger LOGGER = Logger.getLogger(AbstractTransferrer.class.getName());
    protected final long offset;
    protected final long length;
    private volatile long position = 0L;
    @Nullable
    private Selector selector;
    @Nullable
    private final SelectableChannel selectable;
    private final ReadableByteChannel readable;
    private final WritableByteChannel writable;

    public AbstractTransferrer(ReadableByteChannel readable, WritableByteChannel writable, @Nullable SelectableChannel selectable, long offset, long toTransfer) {
        this.readable = readable;
        this.writable = writable;
        this.selectable = selectable;
        this.offset = offset;
        this.length = toTransfer;
    }

    public AbstractTransferrer(StreamInfo stream, long offset, long toDownload) {
        this(stream.getReadableChannel(), stream.getWritableChannel(), stream.getSelectableChannel(), offset, toDownload);
    }

    protected void waitUntilReady() throws IOException {
        if (this.selector != null) {
            this.selector.select(50L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transfer() throws IOException {
        boolean wasBlocking;
        if (this.selectable != null) {
            this.selector = Selector.open();
            wasBlocking = this.selectable.isBlocking();
        } else {
            this.selector = null;
            wasBlocking = false;
        }
        try {
            long totalTransferred;
            block20: {
                if (this.selectable != null) {
                    if (wasBlocking) {
                        this.selectable.configureBlocking(false);
                    }
                    this.selectable.register(this.selector, this.getSelectionKey());
                }
                this.setPosition(this.offset);
                totalTransferred = 0L;
                while (true) {
                    if (totalTransferred > this.length) {
                        LOGGER.severe("downloaded too much: " + totalTransferred + " >= length " + this.length);
                        break block20;
                    }
                    if (totalTransferred == this.length) break block20;
                    boolean waited = this.waitIfPaused();
                    if (waited) continue;
                    long remaining = this.length - totalTransferred;
                    this.waitUntilReady();
                    long transferred = this.transfer(this.readable, this.writable, totalTransferred, remaining);
                    if (transferred == -1L) {
                        LOGGER.severe("transfer returned -1");
                        break block20;
                    }
                    this.setPosition(this.offset + (totalTransferred += transferred));
                    if (this.isCancelled()) break;
                }
                LOGGER.fine("Someone said to cancel receiving");
            }
            long l = totalTransferred;
            return l;
        }
        finally {
            try {
                if (this.selector != null) {
                    this.selector.close();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Couldn't close selector", e);
            }
            try {
                if (wasBlocking) {
                    this.selectable.configureBlocking(true);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Couldn't reset blocking mode", e);
            }
            this.cleanUp();
        }
    }

    protected void cleanUp() throws IOException {
    }

    protected abstract int getSelectionKey();

    protected abstract boolean isCancelled();

    protected abstract boolean waitIfPaused();

    protected abstract long transfer(ReadableByteChannel var1, WritableByteChannel var2, long var3, long var5) throws IOException;

    public long getStartPosition() {
        return this.offset;
    }

    public long getPosition() {
        return this.position;
    }

    public long getLength() {
        return this.length;
    }

    private void setPosition(long position) {
        this.position = position;
    }
}

