/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.search;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.search.InterestInfo;
import net.kano.joscar.snaccmd.search.SearchCommand;

public class InterestListCmd
extends SearchCommand {
    public static final int CODE_SUCCESS = 1;
    public static final int CODE_UNAVAILABLE = 11;
    private final int code;
    private final InterestInfo[] interests;

    protected InterestListCmd(SnacPacket snacPacket) {
        super(5);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.code = BinaryTools.getUShort(byteBlock, 0);
        int n = BinaryTools.getUShort(byteBlock, 2);
        if (byteBlock.getLength() > 4) {
            InterestInfo interestInfo;
            ByteBlock byteBlock2 = byteBlock.subBlock(4);
            ArrayList<InterestInfo> arrayList = new ArrayList<InterestInfo>();
            for (int i = 0; i < n && (interestInfo = InterestInfo.readInterestInfo(byteBlock2)) != null; ++i) {
                arrayList.add(interestInfo);
                byteBlock2 = byteBlock2.subBlock(interestInfo.getTotalSize());
            }
            this.interests = arrayList.toArray(new InterestInfo[arrayList.size()]);
        } else {
            this.interests = null;
        }
    }

    public InterestListCmd(int n) {
        this(n, null);
    }

    public InterestListCmd(InterestInfo[] interestInfoArray) {
        this(interestInfoArray != null ? 1 : 11, interestInfoArray);
    }

    public InterestListCmd(int n, InterestInfo[] interestInfoArray) {
        super(5);
        DefensiveTools.checkRange(n, "code", 0);
        this.code = n;
        this.interests = interestInfoArray == null ? null : (InterestInfo[])interestInfoArray.clone();
    }

    public int getResultCode() {
        return this.code;
    }

    public final InterestInfo[] getInterests() {
        return this.interests == null ? null : (InterestInfo[])this.interests.clone();
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.code);
        if (this.interests != null) {
            BinaryTools.writeUShort(outputStream, this.interests.length);
            for (InterestInfo interestInfo : this.interests) {
                interestInfo.write(outputStream);
            }
        }
    }

    public String toString() {
        return "InterestListCmd: code=" + this.code + ", " + (this.interests == null ? -1 : this.interests.length) + " interests";
    }
}

