/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.loc.GetDirInfoCmd;
import net.kano.joscar.snaccmd.loc.GetInfoCmd;
import net.kano.joscar.snaccmd.loc.LocRightsRequest;
import net.kano.joscar.snaccmd.loc.OldGetInfoCmd;
import net.kano.joscar.snaccmd.loc.SetDirInfoCmd;
import net.kano.joscar.snaccmd.loc.SetInfoCmd;
import net.kano.joscar.snaccmd.loc.SetInterestsCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerLocCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList(new CmdType(2, 2), new CmdType(2, 4), new CmdType(2, 5), new CmdType(2, 11), new CmdType(2, 15), new CmdType(2, 9), new CmdType(2, 21));

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket snacPacket) {
        if (snacPacket.getFamily() != 2) {
            return null;
        }
        int n = snacPacket.getCommand();
        if (n == 2) {
            return new LocRightsRequest(snacPacket);
        }
        if (n == 4) {
            return new SetInfoCmd(snacPacket);
        }
        if (n == 5) {
            return new OldGetInfoCmd(snacPacket);
        }
        if (n == 11) {
            return new GetDirInfoCmd(snacPacket);
        }
        if (n == 15) {
            return new SetInterestsCmd(snacPacket);
        }
        if (n == 9) {
            return new SetDirInfoCmd(snacPacket);
        }
        if (n == 21) {
            return new GetInfoCmd(snacPacket);
        }
        return null;
    }
}

