/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icbm.SingleBuddyRequest;
import net.kano.joscar.snaccmd.loc.LocCommand;

public class OldGetInfoCmd
extends LocCommand
implements SingleBuddyRequest {
    public static final int TYPE_INFO = 1;
    public static final int TYPE_AWAYMSG = 3;
    public static final int TYPE_CAPS = 4;
    private final String sn;
    private final int type;

    protected OldGetInfoCmd(SnacPacket snacPacket) {
        super(5);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.type = BinaryTools.getUShort(byteBlock, 0);
        ByteBlock byteBlock2 = byteBlock.subBlock(2);
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock2);
        this.sn = stringBlock == null ? null : stringBlock.getString();
    }

    public OldGetInfoCmd(int n, String string) {
        super(5);
        DefensiveTools.checkRange(n, "type", 0);
        DefensiveTools.checkNull(string, "sn");
        this.type = n;
        this.sn = string;
    }

    public final int getRequestType() {
        return this.type;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.type);
        OscarTools.writeScreenname(outputStream, this.sn);
    }

    public String toString() {
        return "OldGetInfoCmd for " + this.sn + ", type=" + this.type;
    }
}

