/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.icbm.AbstractImIcbm;
import net.kano.joscar.snaccmd.icbm.InstantMessage;
import net.kano.joscar.snaccmd.icbm.OldIconHashInfo;
import net.kano.joscar.snaccmd.icbm.RecvIcbm;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecvImIcbm
extends AbstractImIcbm
implements RecvIcbm {
    private static final int TYPE_CAN_TYPE = 11;
    private final boolean canType;
    private final FullUserInfo userInfo;

    protected RecvImIcbm(SnacPacket snacPacket) {
        super(7, snacPacket);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = this.getChannelData();
        this.userInfo = FullUserInfo.readUserInfo(byteBlock);
        ByteBlock byteBlock2 = byteBlock.subBlock(this.userInfo.getTotalSize());
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock2);
        this.processImTlvs(immutableTlvChain);
        this.canType = immutableTlvChain.hasTlv(11);
    }

    public RecvImIcbm(long l, FullUserInfo fullUserInfo, InstantMessage instantMessage, boolean bl, boolean bl2, OldIconHashInfo oldIconHashInfo, Collection<ExtraInfoBlock> collection, ByteBlock byteBlock, boolean bl3) {
        super(7, l, instantMessage, bl, bl2, oldIconHashInfo, collection, byteBlock);
        DefensiveTools.checkNull(fullUserInfo, "userInfo");
        this.canType = bl3;
        this.userInfo = fullUserInfo;
    }

    @Override
    public final FullUserInfo getSenderInfo() {
        return this.userInfo;
    }

    public final boolean canType() {
        return this.canType;
    }

    @Override
    protected final void writeChannelData(OutputStream outputStream) throws IOException {
        this.userInfo.write(outputStream);
        if (this.canType) {
            new Tlv(11).write(outputStream);
        }
        this.writeImTlvs(outputStream);
    }

    @Override
    public String toString() {
        return "RecvImIcbm: message from " + this.userInfo + ": " + this.getMessage();
    }
}

