/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.snaccmd.conn.RateClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateInfoCmd
extends ConnCommand {
    private final List<RateClassInfo> infos;

    protected RateInfoCmd(SnacPacket snacPacket) {
        super(7);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        int n = BinaryTools.getUShort(byteBlock, 0);
        ArrayList<RateClassInfo> arrayList = new ArrayList<RateClassInfo>(n);
        ByteBlock byteBlock2 = byteBlock.subBlock(2);
        for (int i = 0; i < n; ++i) {
            RateClassInfo rateClassInfo = RateClassInfo.readRateClassInfo(byteBlock2);
            arrayList.add(rateClassInfo);
            byteBlock2 = byteBlock2.subBlock((int)rateClassInfo.getWritableLength());
        }
        Iterator iterator = arrayList.iterator();
        for (int i = 0; i < n; ++i) {
            assert (iterator.hasNext());
            int n2 = BinaryTools.getUShort(byteBlock2, 0);
            int n3 = BinaryTools.getUShort(byteBlock2, 2);
            ArrayList<CmdType> arrayList2 = new ArrayList<CmdType>(n3);
            RateClassInfo rateClassInfo = (RateClassInfo)iterator.next();
            if (n2 != rateClassInfo.getRateClass()) continue;
            for (int j = 0; j < n3; ++j) {
                int n4 = BinaryTools.getUShort(byteBlock2, 4 + j * 4);
                int n5 = BinaryTools.getUShort(byteBlock2, 4 + j * 4 + 2);
                arrayList2.add(new CmdType(n4, n5));
            }
            rateClassInfo.setCommands(arrayList2);
            byteBlock2 = byteBlock2.subBlock(4 + n3 * 4);
        }
        this.infos = arrayList;
    }

    public RateInfoCmd(Collection<RateClassInfo> collection) {
        super(7);
        this.infos = DefensiveTools.getSafeListCopy(collection, "infos");
    }

    public List<RateClassInfo> getRateClassInfos() {
        return this.infos;
    }

    @Override
    public void writeData(OutputStream outputStream) throws IOException {
        int n = this.infos == null ? 0 : this.infos.size();
        BinaryTools.writeUShort(outputStream, n);
        if (this.infos != null) {
            for (RateClassInfo rateClassInfo : this.infos) {
                rateClassInfo.write(outputStream);
            }
            for (RateClassInfo rateClassInfo : this.infos) {
                BinaryTools.writeUShort(outputStream, rateClassInfo.getRateClass());
                if (rateClassInfo.getCommands() == null) {
                    BinaryTools.writeUShort(outputStream, 0);
                    continue;
                }
                BinaryTools.writeUShort(outputStream, rateClassInfo.getCommands().size());
                for (CmdType cmdType : rateClassInfo.getCommands()) {
                    BinaryTools.writeUShort(outputStream, cmdType.getFamily());
                    BinaryTools.writeUShort(outputStream, cmdType.getCommand());
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RateInfoCmd: ");
        for (RateClassInfo rateClassInfo : this.infos) {
            stringBuffer.append(rateClassInfo);
            stringBuffer.append(" - ");
        }
        return stringBuffer.toString();
    }
}

