/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sf.fmj.codegen.FormatTraceUtils;
import net.sf.fmj.utility.FormatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AviVideoFormat
extends VideoFormat {
    protected int planes = -1;
    protected int bitsPerPixel = -1;
    protected int imageSize = -1;
    protected int xPelsPerMeter = -1;
    protected int yPelsPerMeter = -1;
    protected int clrUsed = -1;
    protected int clrImportant = -1;
    protected byte[] codecSpecificHeader;

    public AviVideoFormat(String string) {
        super(string);
    }

    public AviVideoFormat(String string, Dimension dimension, int n, Class<?> clazz, float f, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray) {
        super(string, dimension, n, clazz, f);
        this.planes = n2;
        this.bitsPerPixel = n3;
        this.imageSize = n4;
        this.xPelsPerMeter = n5;
        this.yPelsPerMeter = n6;
        this.clrUsed = n7;
        this.clrImportant = n8;
        this.codecSpecificHeader = byArray;
    }

    @Override
    public Object clone() {
        return new AviVideoFormat(this.encoding, this.size, this.maxDataLength, this.dataType, this.frameRate, this.planes, this.bitsPerPixel, this.imageSize, this.xPelsPerMeter, this.yPelsPerMeter, this.clrUsed, this.clrImportant, this.codecSpecificHeader);
    }

    @Override
    protected void copy(Format format) {
        super.copy(format);
        AviVideoFormat aviVideoFormat = (AviVideoFormat)format;
        this.planes = aviVideoFormat.planes;
        this.bitsPerPixel = aviVideoFormat.bitsPerPixel;
        this.imageSize = aviVideoFormat.imageSize;
        this.xPelsPerMeter = aviVideoFormat.xPelsPerMeter;
        this.yPelsPerMeter = aviVideoFormat.yPelsPerMeter;
        this.clrUsed = aviVideoFormat.clrUsed;
        this.clrImportant = aviVideoFormat.clrImportant;
        this.codecSpecificHeader = aviVideoFormat.codecSpecificHeader;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof AviVideoFormat)) {
            return false;
        }
        AviVideoFormat aviVideoFormat = (AviVideoFormat)object;
        return this.planes == aviVideoFormat.planes && this.bitsPerPixel == aviVideoFormat.bitsPerPixel && this.imageSize == aviVideoFormat.imageSize && this.xPelsPerMeter == aviVideoFormat.xPelsPerMeter && this.yPelsPerMeter == aviVideoFormat.yPelsPerMeter && this.clrUsed == aviVideoFormat.clrUsed && this.clrImportant == aviVideoFormat.clrImportant && FormatUtils.byteArraysEqual(this.codecSpecificHeader, aviVideoFormat.codecSpecificHeader);
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getClrImportant() {
        return this.clrImportant;
    }

    public int getClrUsed() {
        return this.clrUsed;
    }

    public byte[] getCodecSpecificHeader() {
        return this.codecSpecificHeader;
    }

    public int getImageSize() {
        return this.imageSize;
    }

    public int getPlanes() {
        return this.planes;
    }

    public int getXPelsPerMeter() {
        return this.xPelsPerMeter;
    }

    public int getYPelsPerMeter() {
        return this.yPelsPerMeter;
    }

    @Override
    public Format intersects(Format format) {
        Format format2 = super.intersects(format);
        if (format instanceof AviVideoFormat) {
            AviVideoFormat aviVideoFormat = (AviVideoFormat)format2;
            AviVideoFormat aviVideoFormat2 = (AviVideoFormat)format;
            if (this.getClass().isAssignableFrom(format.getClass())) {
                if (FormatUtils.specified(this.planes)) {
                    aviVideoFormat.planes = this.planes;
                }
                if (FormatUtils.specified(this.bitsPerPixel)) {
                    aviVideoFormat.bitsPerPixel = this.bitsPerPixel;
                }
                if (FormatUtils.specified(this.imageSize)) {
                    aviVideoFormat.imageSize = this.imageSize;
                }
                if (FormatUtils.specified(this.xPelsPerMeter)) {
                    aviVideoFormat.xPelsPerMeter = this.xPelsPerMeter;
                }
                if (FormatUtils.specified(this.yPelsPerMeter)) {
                    aviVideoFormat.yPelsPerMeter = this.yPelsPerMeter;
                }
                if (FormatUtils.specified(this.clrUsed)) {
                    aviVideoFormat.clrUsed = this.clrUsed;
                }
                if (FormatUtils.specified(this.clrImportant)) {
                    aviVideoFormat.clrImportant = this.clrImportant;
                }
                if (FormatUtils.specified(this.codecSpecificHeader)) {
                    aviVideoFormat.codecSpecificHeader = this.codecSpecificHeader;
                }
            } else if (format.getClass().isAssignableFrom(this.getClass())) {
                if (FormatUtils.specified(this.planes)) {
                    aviVideoFormat.planes = aviVideoFormat2.planes;
                }
                if (FormatUtils.specified(this.bitsPerPixel)) {
                    aviVideoFormat.bitsPerPixel = aviVideoFormat2.bitsPerPixel;
                }
                if (FormatUtils.specified(this.imageSize)) {
                    aviVideoFormat.imageSize = aviVideoFormat2.imageSize;
                }
                if (FormatUtils.specified(this.xPelsPerMeter)) {
                    aviVideoFormat.xPelsPerMeter = aviVideoFormat2.xPelsPerMeter;
                }
                if (FormatUtils.specified(this.yPelsPerMeter)) {
                    aviVideoFormat.yPelsPerMeter = aviVideoFormat2.yPelsPerMeter;
                }
                if (FormatUtils.specified(this.clrUsed)) {
                    aviVideoFormat.clrUsed = aviVideoFormat2.clrUsed;
                }
                if (FormatUtils.specified(this.clrImportant)) {
                    aviVideoFormat.clrImportant = aviVideoFormat2.clrImportant;
                }
                if (!FormatUtils.specified(aviVideoFormat.codecSpecificHeader)) {
                    aviVideoFormat.codecSpecificHeader = aviVideoFormat2.codecSpecificHeader;
                }
            }
        }
        return format2;
    }

    @Override
    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof AviVideoFormat)) {
            return true;
        }
        AviVideoFormat aviVideoFormat = (AviVideoFormat)format;
        return FormatUtils.matches(this.planes, aviVideoFormat.planes) && FormatUtils.matches(this.bitsPerPixel, aviVideoFormat.bitsPerPixel) && FormatUtils.matches(this.imageSize, aviVideoFormat.imageSize) && FormatUtils.matches(this.xPelsPerMeter, aviVideoFormat.xPelsPerMeter) && FormatUtils.matches(this.yPelsPerMeter, aviVideoFormat.yPelsPerMeter) && FormatUtils.matches(this.clrUsed, aviVideoFormat.clrUsed) && FormatUtils.matches(this.clrImportant, aviVideoFormat.clrImportant);
    }

    @Override
    public Format relax() {
        AviVideoFormat aviVideoFormat = (AviVideoFormat)super.relax();
        aviVideoFormat.imageSize = -1;
        FormatTraceUtils.traceRelax(this, aviVideoFormat);
        return aviVideoFormat;
    }

    @Override
    public String toString() {
        int n = this.codecSpecificHeader == null ? 0 : this.codecSpecificHeader.length;
        return super.toString() + " " + n + " extra bytes";
    }
}

